/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.swing.ComboColorDownList;
import com.kingdee.cosmic.ctrl.swing.KDColorChooser;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorSelectedEvent;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorSelectedListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class KingdeeComboColorDownListUI
extends ComponentUI {
    private ComboColorDownList downList;
    private JLabel labChooser;
    private JSeparator separator;
    private JLabel labText;
    private Color defaultColor;
    private Font downListFont;
    KDColorChooser colorChooser;
    private MouseHandler mouseHandler = new MouseHandler();
    private ChooserHandler chooserHandler = new ChooserHandler();
    Color selectedRectColor = Color.BLUE;
    private int targetRow = -1;
    private int targetCol = 1;
    private int lastTargetRow = -1;
    private int lastTargetCol = 1;
    private static final int left = 10;
    private static final int top = 8;
    private static final int smlW = 12;
    private static final int smlH = 12;
    private static final int gap = 6;
    private static final int smlRowCnt = 5;
    private static final int smlColCnt = 8;
    private static final int bigH = 17;
    private static final int halfGap = 3;
    private static final int thirdGap = 2;
    private static final int bigW = 138;
    private static final int width = 158;
    private static final int height = 124;
    private boolean isUsedColorUI;
    protected static int usedColorHeight;
    private LinkedList<Color> usedColorList;
    private KDComboColor.IUsedColorPersistence usedColorPersistence;
    private Color[][] prepareColors = new Color[][]{{new Color(0, 0, 0), new Color(153, 51, 0), new Color(51, 51, 0), new Color(0, 51, 0), new Color(0, 51, 102), new Color(0, 0, 128), new Color(51, 51, 153), new Color(51, 51, 51)}, {new Color(128, 0, 0), new Color(255, 102, 0), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 255), new Color(102, 102, 153), new Color(128, 128, 128)}, {new Color(255, 0, 0), new Color(255, 153, 0), new Color(153, 204, 0), new Color(51, 153, 102), new Color(51, 204, 204), new Color(51, 102, 255), new Color(128, 0, 128), new Color(153, 153, 153)}, {new Color(255, 0, 255), new Color(255, 204, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 204, 255), new Color(153, 51, 102), new Color(192, 192, 192)}, {new Color(255, 153, 204), new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 204), new Color(204, 255, 255), new Color(153, 204, 255), new Color(204, 153, 255), new Color(255, 255, 255)}};

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.downList = (ComboColorDownList)c;
        if (this.downList.isUsedColorUI()) {
            this.isUsedColorUI = true;
            usedColorHeight = 95;
            this.usedColorList = new LinkedList();
            this.installDefaultWithUsedColor(c);
            this.installComponentWithUsedColor(c);
            this.installListener(c);
        } else {
            this.installDefault(c);
            this.installComponent(c);
            this.installListener(c);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.unInstallListener(c);
        this.unInstallComponent(c);
    }

    private void installDefault(JComponent c) {
        this.downListFont = new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 0, 12);
        this.labChooser = new JLabel(this.getMLS("otherColor", "\u5176\u5b83\u989c\u8272"));
        c.setFont(this.downListFont);
        this.labChooser.setFont(this.downListFont);
        this.labChooser.setHorizontalAlignment(0);
    }

    private void installComponent(JComponent c) {
        c.setLayout(new DownListLayout());
        c.add(this.labChooser);
    }

    private void unInstallComponent(JComponent c) {
        c = null;
    }

    private void unInstallListener(JComponent c) {
        c.removeMouseMotionListener(this.mouseHandler);
        c.removeMouseListener(this.mouseHandler);
        this.labChooser.removeMouseListener(this.chooserHandler);
    }

    private void installListener(JComponent c) {
        c.addMouseMotionListener(this.mouseHandler);
        c.addMouseListener(this.mouseHandler);
        this.labChooser.addMouseListener(this.chooserHandler);
    }

    private void installDefaultWithUsedColor(JComponent c) {
        this.downListFont = new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 0, 12);
        this.labChooser = new JLabel(this.getMLS("otherColor", "\u5176\u5b83\u989c\u8272"));
        c.setFont(this.downListFont);
        this.labChooser.setFont(this.downListFont);
        this.labChooser.setHorizontalAlignment(2);
        this.separator = new JSeparator();
        this.labText = new JLabel(this.getMLS("lastOtherColor", "\u6700\u8fd1\u4f7f\u7528\u7684\u5176\u5b83\u989c\u8272"));
        this.labText.setFont(this.downListFont);
        this.labText.setHorizontalAlignment(2);
        int x = 10;
        int y = 124 + usedColorHeight - 17 - 72;
        this.labChooser.setBounds(x, y - 6, 138, 23);
        this.separator.setBounds(1, y + 17 + 3, 156, 2);
        this.labText.setBounds(x, y + 17 + 10, 138, 17);
    }

    private void installComponentWithUsedColor(JComponent c) {
        c.setLayout(null);
        c.setPreferredSize(new Dimension(158, 124 + usedColorHeight));
        c.add(this.labChooser);
        c.add(this.separator);
        c.add(this.labText);
    }

    public void init() {
        this.targetRow = -1;
        this.targetCol = 1;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int j;
        int i;
        this.defaultColor = this.downList.getDefaultColor();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int fmH = fm.getHeight();
        int fmW = fm.stringWidth(this.downList.getDefaultColorPrompt());
        int y = 8 + fmH - 1;
        int x = 79 - fmW / 2;
        g.setColor(Color.BLACK);
        g.drawString(this.downList.getDefaultColorPrompt(), x, y);
        if (null != this.defaultColor) {
            g.setColor(this.defaultColor);
            g.fillRect(16, 11, 12, 12);
            g.setColor(new Color(102, 102, 102));
            g.drawRect(16, 11, 12, 12);
        }
        boolean isSelected = false;
        for (i = 1; i <= this.prepareColors.length; ++i) {
            for (j = 1; j <= this.prepareColors[i - 1].length; ++j) {
                x = this.getBlockX(j);
                y = this.getBlockY(i);
                g.setColor(this.prepareColors[i - 1][j - 1]);
                g.fillRect(x, y, 12, 12);
                g.setColor(new Color(102, 102, 102));
                g.drawRect(x, y, 12, 12);
                if (!this.prepareColors[i - 1][j - 1].equals(this.downList.getColor())) continue;
                this.drawSelectedRect(i, j, g);
                isSelected = true;
            }
        }
        if (this.isUsedColorUI) {
            if (this.usedColorPersistence != null && this.usedColorPersistence.load() != null) {
                this.usedColorList = this.usedColorPersistence.load();
            }
            for (i = 1; i <= 2; ++i) {
                for (j = 1; j <= 8; ++j) {
                    x = this.getBlockX(j);
                    y = this.getBlockY(i + 8);
                    int index = 8 * (i - 1) + j - 1;
                    if (this.usedColorList.size() > index) {
                        g.setColor(this.usedColorList.get(index));
                        g.fillRect(x, y, 12, 12);
                        g.setColor(new Color(102, 102, 102));
                        g.drawRect(x, y, 12, 12);
                        if (!this.usedColorList.get(index).equals(this.downList.getColor())) continue;
                        if (this.prepareColors[i - 1][j - 1].equals(this.downList.getColor())) {
                            this.clearSelectedRect(i, j);
                        }
                        this.drawSelectedRect(i + 8, j, g);
                        isSelected = true;
                        continue;
                    }
                    g.setColor(new Color(222, 222, 222));
                    g.drawRect(x, y, 12, 12);
                }
            }
        }
        if (!isSelected && (this.downList.getColor() == null && this.downList.getDefaultColor() == null || this.downList.getColor() != null && this.downList.getColor().equals(this.downList.getDefaultColor()))) {
            this.drawSelectedRect(0, 1, g);
        }
    }

    private int getBlockX(int j) {
        return (j - 1) * 18 + 10;
    }

    private int getBlockY(int i) {
        if (i == 0) {
            return 8;
        }
        return (i - 1) * 18 + 8 + 17 + 6 + 3;
    }

    private int getBlockW(int i) {
        if (i == 0) {
            return 138;
        }
        if (i > 5) {
            return 0;
        }
        return 12;
    }

    private int getBlockH(int i) {
        if (i == 0) {
            return 17;
        }
        if (i > 5) {
            return 0;
        }
        return 12;
    }

    private void drawSelectedRect(int i, int j, Graphics g) {
        if (this.isUsedColorUI) {
            int index;
            if (i >= 0 && i <= 5) {
                g.setColor(this.selectedRectColor);
                g.drawRect(this.getBlockX(j) - 2, this.getBlockY(i) - 2, this.getBlockW(i) + 4, this.getBlockH(i) + 4);
            } else if (i > 5 && i <= 7) {
                JComponent c = (JComponent)this.downList.getComponent(i - 5 - 1);
                c.setBorder(BorderFactory.createLineBorder(this.selectedRectColor));
            } else if (i >= 9 && i <= 10 && (index = (i - 9) * 8 + j) <= this.usedColorList.size()) {
                g.setColor(this.selectedRectColor);
                g.drawRect(this.getBlockX(j) - 2, this.getBlockY(i) - 2, 16, 16);
            }
        } else if (i >= 0 && i <= 5) {
            g.setColor(this.selectedRectColor);
            g.drawRect(this.getBlockX(j) - 2, this.getBlockY(i) - 2, this.getBlockW(i) + 4, this.getBlockH(i) + 4);
        } else if (i > 5) {
            JComponent c = (JComponent)this.downList.getComponent(i - 5 - 1);
            c.setBorder(BorderFactory.createLineBorder(this.selectedRectColor));
        }
    }

    private void clearSelectedRect(int i, int j) {
        if (this.isUsedColorUI) {
            if (i >= 0 && i <= 5) {
                this.downList.repaint(this.getBlockX(j) - 3, this.getBlockY(i) - 3, this.getBlockW(i) + 6, this.getBlockH(i) + 6);
            } else if (i > 5 && i <= 7) {
                JComponent c = (JComponent)this.downList.getComponent(i - 5 - 1);
                c.setBorder(null);
            } else if (i >= 9 && i <= 10) {
                this.downList.repaint(this.getBlockX(j) - 3, this.getBlockY(i) - 3, 18, 18);
            }
        } else if (i >= 0 && i <= 5) {
            this.downList.repaint(this.getBlockX(j) - 3, this.getBlockY(i) - 3, this.getBlockW(i) + 6, this.getBlockH(i) + 6);
        } else if (i > 5) {
            JComponent c = (JComponent)this.downList.getComponent(i - 5 - 1);
            c.setBorder(null);
        }
    }

    private void acceptSelection(int i, int j) {
        if (i == -1) {
            return;
        }
        Color old = this.downList.getColor();
        if (i == 0) {
            this.downList.setColor(this.defaultColor);
        } else if (i >= 1 && i <= 5) {
            this.downList.setColor(this.prepareColors[i - 1][j - 1]);
        } else if (i == 6) {
            Color newC;
            Color oldC = this.downList.getColor();
            Container parent = this.downList;
            Window win = SwingUtilities.getWindowAncestor(this.downList);
            if (win != null) {
                parent = win.getParent();
            }
            this.downList.setColor((newC = this.showColorChooser(parent, this.getMLS("titleColorChooser", "\u989c\u8272"), oldC)) == null || newC == oldC ? oldC : newC);
            if (newC == null) {
                return;
            }
            if (this.isUsedColorUI) {
                int k;
                boolean isPrepareColors = false;
                for (k = 1; k <= this.prepareColors.length; ++k) {
                    for (int l = 1; l <= this.prepareColors[k - 1].length; ++l) {
                        if (!this.prepareColors[k - 1][l - 1].equals(newC)) continue;
                        isPrepareColors = true;
                    }
                }
                if (!isPrepareColors) {
                    for (k = 0; k < this.usedColorList.size(); ++k) {
                        Color color = this.usedColorList.get(k);
                        if (color.getRGB() != newC.getRGB()) continue;
                        this.usedColorList.remove(k);
                    }
                    this.usedColorList.add(0, newC);
                    if (this.usedColorList.size() > 16) {
                        this.usedColorList.remove(this.usedColorList.size() - 1);
                    }
                }
            }
            if (this.usedColorPersistence != null) {
                this.usedColorPersistence.save(this.usedColorList);
            }
        } else if (i >= 9 && i <= 10 && this.usedColorList.size() > 8 * (i - 9) + j - 1) {
            this.downList.setColor(this.usedColorList.get(8 * (i - 9) + j - 1));
        }
        this.downList.repaint();
        this.fireSelected(old, this.downList.getColor());
    }

    private Color showColorChooser(Component parent, String title, Color oldC) {
        if (this.colorChooser == null) {
            this.colorChooser = new KDColorChooser(oldC != null ? oldC : Color.white);
        }
        ColorTracker ok = new ColorTracker(this.colorChooser);
        JDialog dialog = KDColorChooser.createDialog(null, title, true, this.colorChooser, ok, null);
        dialog.setVisible(true);
        return ok.getColor();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return super.getPreferredSize(c);
    }

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeComboColorDownListUI();
    }

    void moveUp() {
        int totalRow = 5 + this.downList.getComponentCount();
        if (this.isUsedColorUI) {
            totalRow = 7 + this.downList.getComponentCount();
        }
        if (this.targetRow == -1) {
            this.targetRow = 0;
        } else {
            int n = this.targetRow = this.targetRow == 0 ? totalRow : (this.targetRow = this.targetRow - 1);
        }
        if (this.isUsedColorUI) {
            if (this.targetRow == 10 && this.usedColorList.size() < 9) {
                this.targetRow = 9;
            }
            if (this.targetRow == 9 && this.usedColorList.size() < 1) {
                this.targetRow = 6;
            }
            if (this.targetRow == 8) {
                this.targetRow = 6;
            }
        }
        if (this.targetRow == 0) {
            this.targetCol = 1;
        }
        this.clearSelectedRect(this.lastTargetRow, this.lastTargetCol);
        this.drawSelectedRect(this.targetRow, this.targetCol, this.downList.getGraphics());
        this.lastTargetRow = this.targetRow;
        this.lastTargetCol = this.targetCol;
    }

    void moveDown() {
        int totalRow = 5 + this.downList.getComponentCount();
        if (this.isUsedColorUI) {
            totalRow = 7 + this.downList.getComponentCount();
        }
        if (this.targetRow == -1) {
            this.targetRow = 0;
        } else {
            int n = this.targetRow = this.targetRow == totalRow ? 0 : (this.targetRow = this.targetRow + 1);
        }
        if (this.isUsedColorUI) {
            if (this.targetRow == 7) {
                this.targetRow = 9;
            }
            if (this.targetRow == 9) {
                if (this.usedColorList.size() >= this.targetCol) {
                    this.targetRow = 9;
                } else if (this.usedColorList.size() > 1 && this.usedColorList.size() < this.targetCol) {
                    this.targetRow = 9;
                    this.targetCol = this.usedColorList.size();
                } else {
                    this.targetRow = 0;
                }
            }
            if (this.targetRow == 10) {
                if (this.usedColorList.size() >= this.targetCol + 8) {
                    this.targetRow = 10;
                } else if (this.usedColorList.size() > 8 && this.usedColorList.size() < this.targetCol + 8) {
                    this.targetRow = 10;
                    this.targetCol = this.usedColorList.size();
                } else {
                    this.targetRow = 0;
                }
            }
        }
        if (this.targetRow == 0) {
            this.targetCol = 1;
        }
        this.clearSelectedRect(this.lastTargetRow, this.lastTargetCol);
        this.drawSelectedRect(this.targetRow, this.targetCol, this.downList.getGraphics());
        this.lastTargetRow = this.targetRow;
        this.lastTargetCol = this.targetCol;
    }

    void moveLeft() {
        int totalRow = 5 + this.downList.getComponentCount();
        if (this.isUsedColorUI) {
            totalRow = 7 + this.downList.getComponentCount();
        }
        if (this.targetRow == -1) {
            this.targetRow = 0;
            this.targetCol = 1;
        } else {
            int n = this.targetCol = this.targetCol == 1 ? 8 : (this.targetCol = this.targetCol - 1);
            if (this.targetCol == 8) {
                int n2 = this.targetRow = this.targetRow == 0 ? totalRow : (this.targetRow = this.targetRow - 1);
                if (this.isUsedColorUI) {
                    if (this.targetRow == 0 || this.targetRow == 8) {
                        this.targetCol = 1;
                    }
                } else if (this.targetRow == 0 || this.targetRow > 5) {
                    this.targetCol = 1;
                }
            }
        }
        if (this.isUsedColorUI) {
            if (this.targetRow == 10) {
                if (this.usedColorList.size() >= 9 && this.usedColorList.size() < this.targetCol + 8) {
                    this.targetCol = this.usedColorList.size() - 8;
                } else if (this.usedColorList.size() < 9 || this.usedColorList.size() < this.targetCol + 8) {
                    this.targetRow = 9;
                }
            }
            if (this.targetRow == 9) {
                if (this.usedColorList.size() >= 1 && this.usedColorList.size() < this.targetCol) {
                    this.targetCol = this.usedColorList.size();
                }
                if (this.usedColorList.size() < 1) {
                    this.targetRow = 6;
                }
            }
            if (this.targetRow == 8) {
                this.targetRow = 6;
            }
        }
        if (this.targetRow == 6) {
            this.targetCol = 1;
        }
        this.clearSelectedRect(this.lastTargetRow, this.lastTargetCol);
        this.drawSelectedRect(this.targetRow, this.targetCol, this.downList.getGraphics());
        this.lastTargetRow = this.targetRow;
        this.lastTargetCol = this.targetCol;
    }

    void moveRight() {
        int totalRow = 5 + this.downList.getComponentCount();
        if (this.isUsedColorUI) {
            totalRow = 7 + this.downList.getComponentCount();
        }
        if (this.targetRow == -1) {
            this.targetRow = 0;
            this.targetCol = 1;
        } else {
            if (this.isUsedColorUI) {
                this.targetCol = this.targetRow == 6 || this.targetRow == 0 ? 1 : (this.targetCol == 8 ? 1 : (this.targetCol = this.targetCol + 1));
            } else if (this.targetRow == 0 || this.targetRow > 5) {
                this.targetCol = 1;
            } else {
                int n = this.targetCol = this.targetCol == 8 ? 1 : (this.targetCol = this.targetCol + 1);
            }
            if (this.targetCol == 1) {
                int n = this.targetRow = this.targetRow == totalRow ? 0 : (this.targetRow = this.targetRow + 1);
            }
        }
        if (this.isUsedColorUI) {
            if (this.targetRow == 7) {
                this.targetRow = 9;
            }
            if (this.targetRow == 9) {
                if (this.usedColorList.size() < 9 && this.usedColorList.size() < this.targetCol) {
                    this.targetRow = 0;
                } else if (this.usedColorList.size() < this.targetCol) {
                    this.targetRow = 10;
                }
            }
            if (this.targetRow == 10) {
                if (this.usedColorList.size() >= 9 && this.usedColorList.size() < this.targetCol + 8) {
                    this.targetRow = 0;
                } else if (this.usedColorList.size() < 9 || this.usedColorList.size() < this.targetCol + 8) {
                    this.targetRow = 0;
                }
            }
        }
        if (this.targetRow == 0) {
            this.targetCol = 1;
        }
        this.clearSelectedRect(this.lastTargetRow, this.lastTargetCol);
        this.drawSelectedRect(this.targetRow, this.targetCol, this.downList.getGraphics());
        this.lastTargetRow = this.targetRow;
        this.lastTargetCol = this.targetCol;
    }

    void pressEnter() {
        int j;
        int i;
        int index;
        if (this.isUsedColorUI && (index = ((i = this.targetRow) - 9) * 8 + (j = this.targetCol)) > this.usedColorList.size()) {
            this.targetRow = -1;
            this.targetCol = 1;
        }
        this.clearSelectedRect(this.lastTargetRow, this.lastTargetCol);
        this.acceptSelection(this.targetRow, this.targetCol);
    }

    public void addChooseKeyListener(KeyListener l) {
        this.downList.addKeyListener(l);
    }

    public void removeChooseKeyListener(KeyListener l) {
        this.downList.removeKeyListener(l);
    }

    public void addChooseMouseListener(MouseListener l) {
        this.downList.addMouseListener(l);
    }

    public void removeChooseMouseListener(MouseListener l) {
        this.downList.removeMouseListener(l);
    }

    public void setSaveUsedColorListener(KDComboColor.IUsedColorPersistence i) {
        this.usedColorPersistence = i;
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlSwingMessages.getMLS(key, defaultValue);
    }

    private void fireSelected(Color oldColor, Color newColor) {
        EventListener[] listeners = this.downList.getListeners(ComboColorSelectedListener.class);
        ComboColorSelectedEvent event = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (null == event) {
                event = new ComboColorSelectedEvent(this.downList, oldColor, newColor);
            }
            ((ComboColorSelectedListener)listeners[i]).selected(event);
        }
    }

    protected class ChooserHandler
    extends MouseAdapter {
        protected ChooserHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            KingdeeComboColorDownListUI.this.clearSelectedRect(KingdeeComboColorDownListUI.this.lastTargetRow, KingdeeComboColorDownListUI.this.lastTargetCol);
            KingdeeComboColorDownListUI.this.acceptSelection(KingdeeComboColorDownListUI.this.targetRow, KingdeeComboColorDownListUI.this.targetCol);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            KingdeeComboColorDownListUI.this.targetRow = 6;
            KingdeeComboColorDownListUI.this.targetCol = 1;
            KingdeeComboColorDownListUI.this.clearSelectedRect(KingdeeComboColorDownListUI.this.lastTargetRow, KingdeeComboColorDownListUI.this.lastTargetCol);
            KingdeeComboColorDownListUI.this.drawSelectedRect(KingdeeComboColorDownListUI.this.targetRow, KingdeeComboColorDownListUI.this.targetCol, KingdeeComboColorDownListUI.this.downList.getGraphics());
            KingdeeComboColorDownListUI.this.lastTargetRow = KingdeeComboColorDownListUI.this.targetRow;
            KingdeeComboColorDownListUI.this.lastTargetCol = KingdeeComboColorDownListUI.this.targetCol;
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        int smlStartX = 7;
        int smlStartY = 31;
        int smlEndX = this.smlStartX + 144;
        int smlEndY = this.smlStartY + 90;
        int bigStartX = 7;
        int bigStartY = 5;
        int bigEndX = this.bigStartX + 138 + 6;
        int bigEndY = this.bigStartY + 17 + 6;
        int usedStartY = 178;
        int usedEndY = 208;

        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            KingdeeComboColorDownListUI.this.acceptSelection(KingdeeComboColorDownListUI.this.targetRow, KingdeeComboColorDownListUI.this.targetCol);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.calculateTarget(e.getX(), e.getY());
            if (KingdeeComboColorDownListUI.this.lastTargetRow != KingdeeComboColorDownListUI.this.targetRow || KingdeeComboColorDownListUI.this.lastTargetCol != KingdeeComboColorDownListUI.this.targetCol) {
                KingdeeComboColorDownListUI.this.clearSelectedRect(KingdeeComboColorDownListUI.this.lastTargetRow, KingdeeComboColorDownListUI.this.lastTargetCol);
                KingdeeComboColorDownListUI.this.drawSelectedRect(KingdeeComboColorDownListUI.this.targetRow, KingdeeComboColorDownListUI.this.targetCol, KingdeeComboColorDownListUI.this.downList.getGraphics());
            }
            KingdeeComboColorDownListUI.this.lastTargetRow = KingdeeComboColorDownListUI.this.targetRow;
            KingdeeComboColorDownListUI.this.lastTargetCol = KingdeeComboColorDownListUI.this.targetCol;
        }

        private void calculateTarget(int x, int y) {
            KingdeeComboColorDownListUI.this.targetRow = -1;
            KingdeeComboColorDownListUI.this.targetCol = 1;
            if (y >= this.smlStartY && y < this.smlEndY) {
                if (x >= this.smlStartX && x < this.smlEndX) {
                    KingdeeComboColorDownListUI.this.targetCol = (x - this.smlStartX) / 18 + 1;
                    KingdeeComboColorDownListUI.this.targetRow = (y - this.smlStartY) / 18 + 1;
                }
            } else if (y >= this.bigStartY && y < this.bigEndY && x >= this.bigStartX && x < this.bigEndX) {
                KingdeeComboColorDownListUI.this.targetRow = 0;
                KingdeeComboColorDownListUI.this.targetCol = 1;
            }
            if (KingdeeComboColorDownListUI.this.isUsedColorUI && y >= this.usedStartY && y <= this.usedEndY && x >= this.smlStartX && x < this.smlEndX) {
                KingdeeComboColorDownListUI.this.targetCol = (x - this.smlStartX) / 18 + 1;
                KingdeeComboColorDownListUI.this.targetRow = (y - this.smlStartY) / 18 + 1;
                int i = KingdeeComboColorDownListUI.this.targetRow;
                int j = KingdeeComboColorDownListUI.this.targetCol;
                int index = (i - 9) * 8 + j;
                if (index > KingdeeComboColorDownListUI.this.usedColorList.size()) {
                    KingdeeComboColorDownListUI.this.targetRow = -1;
                    KingdeeComboColorDownListUI.this.targetCol = 1;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }

    private static class DownListLayout
    implements LayoutManager {
        private DownListLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int extH = parent.getComponentCount() * 23 + 6;
            return new Dimension(158, 124 + extH);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension pDim = parent.getSize();
            int x = insets.left + 6;
            int y = 126;
            int w = pDim.width - insets.left - insets.right - 12;
            int h = 23;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component child = parent.getComponent(i);
                child.setBounds(x, y, w, h);
                y += h;
            }
        }
    }

    static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

