/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDMultiLangArea;
import com.kingdee.cosmic.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.cosmic.ctrl.swing.plaf.DefaultMultiLangBoxUI;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeMultiLangBoxUI;
import com.kingdee.cosmic.ctrl.swing.plaf.MultiLangAreaEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import org.apache.log4j.Logger;

public class KingdeeMultiLangAreaUI
extends KingdeeMultiLangBoxUI {
    private static final Logger logger = LogUtil.getPackageLogger(KingdeeMultiLangAreaUI.class);

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeMultiLangAreaUI();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new MultiLangAreaEditor.UIResource();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new MulitLangAreaLayout();
    }

    @Override
    protected Insets getInsets() {
        return super.getInsets();
    }

    protected Component getEditor() {
        return this.editor;
    }

    protected Component getArrowButton() {
        return this.arrowButton;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Component edt = this.getEditor();
        Dimension d = edt.getPreferredSize();
        return d;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        ComboBoxEditor edt = this.comboBox.getEditor();
        if (edt instanceof MultiLangAreaEditor) {
            MultiLangAreaEditor mledt = (MultiLangAreaEditor)edt;
            mledt.addFocusListener(this.focusHandler);
            mledt.addDataChangeListener(this.dataChangeHandler);
        }
        InputMap inputMap = this.comboBox.getInputMap();
        ActionMap actionMap = this.comboBox.getActionMap();
        KeyStroke newKeyStroke = KeyStroke.getKeyStroke(90, 2, false);
        inputMap.put(newKeyStroke, "undo-textfield");
        newKeyStroke = KeyStroke.getKeyStroke(89, 2, false);
        inputMap.put(newKeyStroke, "redo-textfield");
        actionMap.put("undo-MultiLangArea", new UndoAction());
        actionMap.put("redo-MultiLangArea", new RedoAction());
    }

    @Override
    protected void uninstallListeners() {
        ComboBoxEditor edt = this.comboBox.getEditor();
        if (edt instanceof MultiLangAreaEditor) {
            MultiLangAreaEditor mledt = (MultiLangAreaEditor)edt;
            mledt.removeFocusListener(this.focusHandler);
            mledt.removeDataChangeListener(this.dataChangeHandler);
        }
        super.uninstallListeners();
        InputMap inputMap = this.comboBox.getInputMap();
        ActionMap actionMap = this.comboBox.getActionMap();
        inputMap.remove(KeyStroke.getKeyStroke(90, 2, false));
        inputMap.remove(KeyStroke.getKeyStroke(89, 2, false));
        actionMap.remove("undo-MultiLangArea");
        actionMap.remove("redo-MultiLangArea");
    }

    @Override
    protected FocusListener createFocusHandler() {
        return new MultiLangAreaFocusHandler(this.comboBox);
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -4298477188098636541L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (((KDMultiLangArea)KingdeeMultiLangAreaUI.this.comboBox).manager.canRedo()) {
                    ((KDMultiLangArea)KingdeeMultiLangAreaUI.this.comboBox).manager.redo();
                }
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -4716008722938370553L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (((KDMultiLangArea)KingdeeMultiLangAreaUI.this.comboBox).manager.canUndo()) {
                    ((KDMultiLangArea)KingdeeMultiLangAreaUI.this.comboBox).manager.undo();
                }
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }

    public static class MultiLangAreaFocusHandler
    implements FocusListener {
        protected JComboBox combo;

        public MultiLangAreaFocusHandler(JComboBox comp) {
            this.combo = comp;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.combo.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ComboBoxEditor editor = this.combo.getEditor();
            Object item = editor.getItem();
            if (!e.isTemporary() && item != null && !item.equals(this.combo.getSelectedItem())) {
                this.combo.actionPerformed(new ActionEvent(editor, 0, "", EventQueue.getMostRecentEventTime(), 0));
            }
            this.combo.repaint();
        }
    }

    public class MulitLangAreaLayout
    extends DefaultMultiLangBoxUI.ComboBoxLayoutManager {
        public MulitLangAreaLayout() {
            super(KingdeeMultiLangAreaUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            Component edt = KingdeeMultiLangAreaUI.this.getEditor();
            if (edt != null) {
                JComboBox cb = (JComboBox)parent;
                int width = cb.getWidth();
                int height = cb.getHeight();
                Insets insets = KingdeeMultiLangAreaUI.this.getInsets();
                Rectangle cvb = new Rectangle(insets.left, insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom);
                edt.setBounds(cvb);
                if (edt instanceof KDTextAreaCtrl) {
                    ((KDTextAreaCtrl)edt).setCorner("UPPER_RIGHT_CORNER", KingdeeMultiLangAreaUI.this.getArrowButton());
                }
            }
        }
    }
}

