/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class KingdeeProgressBarUI
extends BasicProgressBarUI {
    public static final int SHADOW_HORIZONTAL = 1;
    public static final int SHADOW_VERTICAL = 2;
    private Color firstShadowColor = null;
    private Color secondShadowColor = null;
    private Color thirdShadowColor = null;
    private Color fourthShadowColor = null;
    private Color fifthsShadowColor = null;
    private static final int preWidth = 279;
    private static final int preHeight = 12;

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.initSelfColors();
    }

    protected Color getCellsShadow() {
        return UIManager.getColor("ProgressBar.cellsShadowColor");
    }

    protected Color getCellsDarkShadow() {
        return UIManager.getColor("ProgressBar.cellsDarkShadowColor");
    }

    protected void initSelfColors() {
        this.firstShadowColor = UIManager.getColor("ProgressBar.firstShadowColor");
        if (this.firstShadowColor == null) {
            this.firstShadowColor = Color.decode("#E6EDF3");
        }
        this.secondShadowColor = UIManager.getColor("ProgressBar.secondShadowColor");
        if (this.secondShadowColor == null) {
            this.secondShadowColor = Color.decode("#E5EDF3");
        }
        this.thirdShadowColor = UIManager.getColor("ProgressBar.thirdShadowColor");
        if (this.thirdShadowColor == null) {
            this.thirdShadowColor = Color.decode("#E4EBF2");
        }
        this.fourthShadowColor = UIManager.getColor("ProgressBar.fourthShadowColor");
        if (this.fourthShadowColor == null) {
            this.fourthShadowColor = Color.decode("#E2E9F1");
        }
        this.fifthsShadowColor = UIManager.getColor("ProgressBar.fifthsShadowColor");
        if (this.fifthsShadowColor == null) {
            this.fifthsShadowColor = Color.decode("#D3E0EB");
        }
    }

    @Override
    public void paintDeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        Paint oldPaint = g2.getPaint();
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int cellLength = this.getCellLength();
        int cellSpacing = this.getCellSpacing();
        if (cellLength == 0 && cellSpacing == 0) {
            cellLength = 1;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        BasicStroke cellsStrock = null;
        BasicStroke shadowStrock = null;
        if (this.progressBar.getOrientation() == 0) {
            if (cellSpacing == 0 && amountFull > 0) {
                cellsStrock = new BasicStroke(barRectHeight, 0, 2);
                shadowStrock = new BasicStroke(1.0f, 0, 2);
            } else {
                cellsStrock = new BasicStroke(barRectHeight, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f);
                shadowStrock = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f);
            }
            Rectangle rect = c.getBounds();
            int height = c.getHeight();
            float perHeight1 = 1.0f;
            float perHeight2 = 9.0f;
            float perHeight3 = 1.0f;
            float perHeight4 = 9.0f;
            float x0 = 0.0f;
            float y0 = 0.0f;
            float x1 = x0;
            float y1 = y0 + perHeight1;
            float x2 = x1;
            float y2 = y1 + perHeight2;
            float x3 = x2;
            float y3 = y2 + perHeight3;
            float x4 = x3;
            float y4 = y3 + perHeight4;
            GradientPaint gradient = new GradientPaint(x0, y0, this.firstShadowColor, x1, y1, this.secondShadowColor);
            g2.setPaint(gradient);
            g2.fillRect((int)x0, (int)y0, rect.width, (int)perHeight1);
            gradient = new GradientPaint(x1, y1, this.secondShadowColor, x2, y2, this.thirdShadowColor);
            g2.setPaint(gradient);
            g2.fillRect((int)x1, (int)y1, rect.width, (int)perHeight2);
            gradient = new GradientPaint(x2, y2, this.thirdShadowColor, x3, y3, this.fourthShadowColor);
            g2.setPaint(gradient);
            g2.fillRect((int)x2, (int)y2, rect.width, (int)perHeight3);
            gradient = new GradientPaint(x3, y3, this.fourthShadowColor, x4, y4, this.fifthsShadowColor);
            g2.setPaint(gradient);
            g2.fillRect((int)x3, (int)y3, rect.width, height - (int)y3);
            if (KingdeeUtils.isLeftToRight(c)) {
                g2.setStroke(cellsStrock);
                GradientPaint progressPaint = new GradientPaint(b.left, b.top, UIManager.getColor("ProgressBar.backStartColor"), amountFull + b.left, b.top, UIManager.getColor("ProgressBar.backEndColor"));
                g2.setPaint(progressPaint);
                g2.drawLine(b.left, barRectHeight / 2 + b.top, amountFull + b.left, barRectHeight / 2 + b.top);
            } else {
                g2.setStroke(cellsStrock);
                GradientPaint progressPaint = new GradientPaint(b.left + barRectWidth, b.top, UIManager.getColor("ProgressBar.backStartColor"), barRectWidth + b.left - amountFull, b.top, UIManager.getColor("ProgressBar.backEndColor"));
                g2.setPaint(progressPaint);
                g2.drawLine(barRectWidth + b.left, barRectHeight / 2 + b.top, barRectWidth + b.left - amountFull, barRectHeight / 2 + b.top);
            }
            g2.setPaint(oldPaint);
        } else {
            if (cellSpacing == 0 && amountFull > 0) {
                cellsStrock = new BasicStroke(barRectWidth, 0, 2);
                shadowStrock = new BasicStroke(1.0f, 0, 2);
            } else {
                cellsStrock = new BasicStroke(barRectWidth, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f);
                shadowStrock = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f);
            }
            g2.setColor(UIManager.getColor("ProgressBar.background"));
            g2.fillRect(b.left, b.top, barRectWidth, barRectHeight);
            g2.setStroke(cellsStrock);
            GradientPaint progressPaint = new GradientPaint(b.left, amountFull + b.top, UIManager.getColor("ProgressBar.backStartColor"), b.left, b.top, UIManager.getColor("ProgressBar.backEndColor"));
            g2.setPaint(progressPaint);
            g2.drawLine(barRectWidth / 2 + b.left, b.top + barRectHeight, barRectWidth / 2 + b.left, b.top + barRectHeight - amountFull);
            g2.setPaint(oldPaint);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    @Override
    public void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Graphics2D g2 = (Graphics2D)g;
        Image img = ((ImageIcon)UIManager.getIcon("ProgressBar.indeterminateIcon")).getImage();
        g2.drawImage(img, b.left, b.top, barRectWidth, barRectHeight, c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(279, 12);
    }
}

