/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.plaf.PaintUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonMenuItemUI;

public class KingdeeRadioButtonMenuItemUI
extends BasicRadioButtonMenuItemUI {
    private static final int BG_INIT = 0;
    private static final int BG_ROLLVER = 1;
    private int leftAreaWidth = 22;
    private static Color leftBgShadow = null;
    private static Color leftBgDarkShadow = null;
    private static Color leftRollBgShadow = null;
    private static Color leftRollBgDarkShadow = null;
    private static Color separatorShadow = null;
    private static Color separatorDarkShadow = null;
    private static Color separatorRollShadow = null;
    private static Color separatorRollDarkShadow = null;

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeRadioButtonMenuItemUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.leftAreaWidth = (Integer)UIManager.get("MenuItem.leftAreaWidth") + 3;
        leftBgShadow = UIManager.getColor("MenuItem.leftBgShadow");
        leftBgDarkShadow = UIManager.getColor("MenuItem.leftBgDarkShadow");
        leftRollBgShadow = UIManager.getColor("MenuItem.leftRollBgShadow");
        leftRollBgDarkShadow = UIManager.getColor("MenuItem.leftRollBgDarkShadow");
        separatorShadow = UIManager.getColor("MenuItem.separatorShadow");
        separatorDarkShadow = UIManager.getColor("MenuItem.separatorDarkShadow");
        separatorRollShadow = UIManager.getColor("MenuItem.separatorRollShadow");
        separatorRollDarkShadow = UIManager.getColor("MenuItem.separatorRollDarkShadow");
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension dim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        if (icon == null) {
            dim.width += this.leftAreaWidth;
        }
        return dim;
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        textRect.x = this.leftAreaWidth + 5;
        super.paintText(g, menuItem, textRect, text);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(UIManager.getColor("MenuItem.selectionBackground"));
                g.fillRect(this.leftAreaWidth, 0, menuWidth, menuHeight);
                this.paintLeftBackground(g, 1);
                this.paintMiddleSeparator(g, 1);
            } else {
                g.setColor(UIManager.getColor("MenuItem.background"));
                g.fillRect(this.leftAreaWidth, 0, menuWidth, menuHeight);
                this.paintLeftBackground(g, 0);
                this.paintMiddleSeparator(g, 0);
            }
            g.setColor(oldColor);
        }
    }

    protected void paintLeftBackground(Graphics g, int state) {
        Rectangle rect = new Rectangle(0, 0, this.leftAreaWidth, this.menuItem.getHeight());
        switch (state) {
            case 1: {
                PaintUtil.drawShadow(g, 1.0f, 1.0f, leftRollBgShadow, this.leftAreaWidth, 1.0f, leftRollBgDarkShadow, rect, 0);
                break;
            }
            default: {
                PaintUtil.drawShadow(g, 1.0f, 1.0f, leftBgShadow, this.leftAreaWidth, 1.0f, leftBgDarkShadow, rect, 0);
            }
        }
    }

    protected void paintMiddleSeparator(Graphics g, int state) {
        int h = this.menuItem.getHeight();
        switch (state) {
            case 1: {
                g.setColor(separatorRollShadow);
                g.drawLine(this.leftAreaWidth, 0, this.leftAreaWidth, h);
                g.setColor(separatorRollDarkShadow);
                g.drawLine(this.leftAreaWidth + 1, 0, this.leftAreaWidth + 1, h);
                break;
            }
            default: {
                g.setColor(separatorShadow);
                g.drawLine(this.leftAreaWidth, 0, this.leftAreaWidth, h);
                g.setColor(separatorDarkShadow);
                g.drawLine(this.leftAreaWidth + 1, 0, this.leftAreaWidth + 1, h);
            }
        }
    }
}

