/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeCellEditor;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeCellRenderer;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.tree.TreeDragNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class KingdeeTreeUI
extends BasicTreeUI {
    private static final Logger logger = LogUtil.getPackageLogger(KingdeeTreeUI.class);
    private DragDropHandler dragDropHandler = null;
    private NodeSelectionHandler nodeSelectionHandler = null;
    private TreeKeyListener treeKeyListener = null;
    protected Image verticalLine;
    protected Image horizontalLine;

    public static ComponentUI createUI(JComponent x) {
        return new KingdeeTreeUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.treeModel != null) {
            super.paint(g, c);
        }
        this.tree.setBackground(UIManager.getColor("Tree.background"));
    }

    @Override
    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        super.selectPathForEvent(path, event);
        if (SwingUtilities.isRightMouseButton(event) && !((KDTree)this.tree).isPathsContainsPath(this.tree.getSelectionPaths(), path)) {
            this.tree.setSelectionPath(path);
            if (this.isToggleEvent(event)) {
                this.toggleExpandState(path);
            }
        }
    }

    public void redoLayout() {
        this.treeState.invalidateSizes();
    }

    @Override
    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultKingdeeTreeCellRenderer) {
            DefaultKingdeeTreeCellEditor editor = new DefaultKingdeeTreeCellEditor(this.tree, (DefaultKingdeeTreeCellRenderer)this.currentCellRenderer);
            return editor;
        }
        return new DefaultKingdeeTreeCellEditor(this.tree, null);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.setExpandedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.setCollapsedIcon(UIManager.getIcon("Tree.collapsedIcon"));
        Icon tempIcon = UIManager.getIcon("Tree.horizontalLineIcon");
        this.horizontalLine = tempIcon instanceof ImageIcon ? ((ImageIcon)tempIcon).getImage() : KDResourceManager.getImageOfRapid("tree_line_h.gif");
        tempIcon = UIManager.getIcon("Tree.verticalLineIcon");
        this.verticalLine = tempIcon instanceof ImageIcon ? ((ImageIcon)tempIcon).getImage() : KDResourceManager.getImageOfRapid("tree_line_v.gif");
        int rowHeight = UIManager.getInt("Tree.rowHeight");
        if (rowHeight == 0) {
            this.tree.setRowHeight(16);
        } else {
            this.tree.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tree.addMouseListener(this.createCheckMouseListener());
        this.tree.addPropertyChangeListener(new InnerPropertyChangeListener());
        if (this.nodeSelectionHandler == null) {
            this.nodeSelectionHandler = new NodeSelectionHandler();
            this.tree.addMouseListener(this.nodeSelectionHandler);
        }
        if (this.treeKeyListener == null) {
            this.treeKeyListener = new TreeKeyListener();
            this.tree.addKeyListener(this.treeKeyListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.dragDropHandler != null) {
            this.tree.removeMouseMotionListener(this.dragDropHandler);
            this.tree.removeMouseListener(this.dragDropHandler);
            this.dragDropHandler = null;
        }
        if (this.nodeSelectionHandler != null) {
            this.tree.removeMouseListener(this.nodeSelectionHandler);
            this.nodeSelectionHandler = null;
        }
        if (this.treeKeyListener != null) {
            this.tree.removeKeyListener(this.treeKeyListener);
            this.treeKeyListener = null;
        }
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseListener createCheckMouseListener() {
        return new CheckMouseHandler();
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.tree instanceof KDTree && !((KDTree)this.tree).isCollapsePathDisabled()) {
            super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        Object lineStyle = this.tree.getClientProperty("JTree.lineStyle");
        if (!"None".equals(lineStyle)) {
            Color oldclr = g.getColor();
            g.setColor(UIManager.getColor("Tree.dotLineColor"));
            this.drawDashedVerticalLine(g, x, top, bottom);
            g.setColor(oldclr);
        }
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        Object lineStyle = this.tree.getClientProperty("JTree.lineStyle");
        if (!"None".equals(lineStyle)) {
            Color oldclr = g.getColor();
            g.setColor(UIManager.getColor("Tree.dotLineColor"));
            this.drawDashedHorizontalLine(g, y, left, right);
            g.setColor(oldclr);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        KeyStroke spacePressed = KeyStroke.getKeyStroke(32, 0, false);
        this.tree.getInputMap().put(spacePressed, "CheckBoxClick");
        this.tree.getActionMap().put("CheckBoxClick", new SpaceAction());
    }

    protected void resetShowCheckBox(Boolean obj) {
        this.treeState.invalidateSizes();
        this.updateSize();
    }

    private void reSetDragNode(boolean b) {
        if (b && this.dragDropHandler == null) {
            this.dragDropHandler = new DragDropHandler();
            this.tree.addMouseMotionListener(this.dragDropHandler);
            this.tree.addMouseListener(this.dragDropHandler);
        } else if (!b && this.dragDropHandler != null) {
            this.tree.removeMouseMotionListener(this.dragDropHandler);
            this.tree.removeMouseListener(this.dragDropHandler);
            this.dragDropHandler = null;
        }
    }

    public void resetSize() {
        this.treeState.invalidateSizes();
        this.updateSize();
    }

    private class TreeKeyListener
    extends KeyAdapter {
        private TreeKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 106) {
                TreePath path = KingdeeTreeUI.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                ((KDTree)KingdeeTreeUI.this.tree).expandAllNodes(true, node);
            } else if (e.getKeyCode() == 107) {
                TreePath path = KingdeeTreeUI.this.tree.getSelectionPath();
                KingdeeTreeUI.this.tree.expandPath(path);
            } else if (e.getKeyCode() == 109) {
                TreePath path = KingdeeTreeUI.this.tree.getSelectionPath();
                KingdeeTreeUI.this.tree.collapsePath(path);
            }
        }
    }

    protected class NodeSelectionHandler
    extends MouseAdapter {
        protected NodeSelectionHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TreePath closestPath;
            if (KingdeeTreeUI.this.tree == null || !KingdeeTreeUI.this.tree.isEnabled() || !(KingdeeTreeUI.this.tree instanceof KDTree)) {
                return;
            }
            if (KingdeeTreeUI.this.isEditing(KingdeeTreeUI.this.tree) && KingdeeTreeUI.this.tree.getInvokesStopCellEditing() && !KingdeeTreeUI.this.stopEditing(KingdeeTreeUI.this.tree)) {
                return;
            }
            if (KingdeeTreeUI.this.tree.isRequestFocusEnabled()) {
                KingdeeTreeUI.this.tree.requestFocus();
            }
            if ((closestPath = ((KDTree)KingdeeTreeUI.this.tree).getClosestPath(e.getX(), e.getY())) == null) {
                return;
            }
            Rectangle closestPathRect = KingdeeTreeUI.this.getPathBounds(KingdeeTreeUI.this.tree, closestPath);
            if (e.getX() > closestPathRect.x + closestPathRect.width && e.getX() < KingdeeTreeUI.this.tree.getWidth() && !KingdeeTreeUI.this.startEditing(closestPath, e)) {
                KingdeeTreeUI.this.selectPathForEvent(closestPath, e);
            }
        }
    }

    protected class DragDropHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private KDTree kdtree;
        private Cursor canDropCursor;
        private Cursor noDropCursor;
        private TreeDragNode[] dragNodes;
        private boolean draged;
        private boolean dragable;
        private TreePath lastToPath;

        public DragDropHandler() {
            this.kdtree = (KDTree)KingdeeTreeUI.this.tree;
            this.dragNodes = null;
            this.draged = false;
            this.dragable = false;
            Image bufImg = KDResourceManager.getImageOfRapid("mos_forbit.gif");
            this.noDropCursor = KingdeeTreeUI.this.tree.getToolkit().createCustomCursor(bufImg, new Point(8, 8), "NoDrop");
            bufImg = KDResourceManager.getImageOfRapid("mos_movedrop.gif");
            this.canDropCursor = KingdeeTreeUI.this.tree.getToolkit().createCustomCursor(bufImg, new Point(0, 0), "CanDrop");
        }

        private Rectangle getPathTextBounds(TreePath path) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            Rectangle r = KingdeeTreeUI.this.tree.getPathBounds(path);
            if (this.kdtree.isShowCheckBox() && node.isCheckBoxVisible()) {
                return new Rectangle(r.x + 35, r.y, r.width - 36, r.height - 1);
            }
            return new Rectangle(r.x + 18, r.y, r.width - 19, r.height - 1);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!(this.kdtree.isDragNodeEnabled() && this.dragable && this.kdtree.isEnabled())) {
                return;
            }
            TreePath toPath = this.kdtree.getClosestPath(e.getX(), e.getY());
            if (toPath == null) {
                KingdeeTreeUI.this.tree.setCursor(this.noDropCursor);
                this.lastToPath = toPath;
                return;
            }
            if (this.draged) {
                if (toPath != this.lastToPath) {
                    Graphics g = KingdeeTreeUI.this.tree.getGraphics();
                    if (this.lastToPath != null && this.kdtree.getNodesDragDropLogic().isDropable(this.dragNodes)) {
                        Rectangle lr = this.getPathTextBounds(this.lastToPath);
                        g.setColor(KingdeeTreeUI.this.tree.getBackground());
                        g.drawRect(lr.x, lr.y, lr.width, lr.height);
                    }
                    DefaultKingdeeTreeNode toParent = (DefaultKingdeeTreeNode)toPath.getLastPathComponent();
                    for (int i = 0; i < this.dragNodes.length; ++i) {
                        this.dragNodes[i].setToParent(toParent);
                    }
                    if (this.kdtree.getNodesDragDropLogic().isDropable(this.dragNodes)) {
                        Rectangle r = this.getPathTextBounds(toPath);
                        g.setColor(UIManager.getColor("Tree.selectionBackground"));
                        g.drawRect(r.x, r.y, r.width, r.height);
                        KingdeeTreeUI.this.tree.setCursor(this.canDropCursor);
                    } else {
                        KingdeeTreeUI.this.tree.setCursor(this.noDropCursor);
                    }
                    this.lastToPath = toPath;
                }
            } else {
                TreePath[] paths = KingdeeTreeUI.this.tree.getSelectionPaths();
                this.dragNodes = new TreeDragNode[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
                    this.dragNodes[i] = new TreeDragNode();
                    this.dragNodes[i].setDragNode(node);
                    this.dragNodes[i].setFromParent((DefaultKingdeeTreeNode)node.getParent());
                }
                KingdeeTreeUI.this.tree.setCursor(this.noDropCursor);
                this.draged = true;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.kdtree.isDragNodeEnabled() || !this.kdtree.isEnabled()) {
                return;
            }
            if (e.getButton() == 1) {
                TreePath toPath = this.kdtree.getClosestPath(e.getX(), e.getY());
                if (toPath != null) {
                    Rectangle r = KingdeeTreeUI.this.tree.getPathBounds(toPath);
                    this.dragable = this.kdtree.isPathsContainsPath(KingdeeTreeUI.this.tree.getSelectionPaths(), toPath) && e.getX() > r.x && e.getX() < r.x + r.width;
                } else {
                    this.dragable = false;
                }
            } else if (this.dragable) {
                this.dragable = false;
                KingdeeTreeUI.this.tree.setCursor(new Cursor(0));
                this.draged = false;
                this.dragNodes = null;
                this.lastToPath = null;
                KingdeeTreeUI.this.tree.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.kdtree.isDragNodeEnabled() || !this.draged || e.getButton() != 1) {
                return;
            }
            KingdeeTreeUI.this.tree.setCursor(new Cursor(0));
            this.draged = false;
            if (this.dragNodes != null) {
                TreePath toPath = this.kdtree.getClosestPath(e.getX(), e.getY());
                if (toPath != null) {
                    DefaultKingdeeTreeNode toParent = (DefaultKingdeeTreeNode)toPath.getLastPathComponent();
                    for (int i = 0; i < this.dragNodes.length; ++i) {
                        this.dragNodes[i].setToParent(toParent);
                    }
                    if (this.kdtree.getNodesDragDropLogic().isDropable(this.dragNodes)) {
                        if (!this.kdtree.fireNodesPreDropped(this.dragNodes)) {
                            this.dragNodes = null;
                            this.lastToPath = null;
                            KingdeeTreeUI.this.tree.repaint();
                            return;
                        }
                        this.doMoveNode();
                        this.kdtree.fireNodesDroped(this.dragNodes);
                    }
                }
                this.dragNodes = null;
                this.lastToPath = null;
                KingdeeTreeUI.this.tree.repaint();
            }
        }

        protected void doMoveNode() {
            DefaultKingdeeTreeNode tempDragNode;
            int i;
            TreePath[] selectedPaths = new TreePath[this.dragNodes.length];
            DefaultTreeModel treeModel = (DefaultTreeModel)KingdeeTreeUI.this.tree.getModel();
            for (i = 0; i < this.dragNodes.length; ++i) {
                tempDragNode = this.dragNodes[i].getDragNode();
                treeModel.removeNodeFromParent(tempDragNode);
            }
            for (i = 0; i < this.dragNodes.length; ++i) {
                DefaultKingdeeTreeNode tempFromParent = this.dragNodes[i].getFromParent();
                if (!this.kdtree.isShowCheckBox() || !this.kdtree.isSyncChecked()) continue;
                if (tempFromParent.getChildCount() > 0) {
                    ((DefaultKingdeeTreeNode)tempFromParent.getFirstLeaf()).syncChecked();
                    continue;
                }
                tempFromParent.syncChecked();
            }
            for (i = 0; i < this.dragNodes.length; ++i) {
                tempDragNode = this.dragNodes[i].getDragNode();
                DefaultKingdeeTreeNode tempToParent = this.dragNodes[i].getToParent();
                treeModel.insertNodeInto(tempDragNode, tempToParent, tempToParent.getChildCount());
                selectedPaths[i] = new TreePath(tempDragNode.getPath());
            }
            if (this.kdtree.isShowCheckBox() && this.kdtree.isSyncChecked()) {
                this.dragNodes[0].getDragNode().syncChecked();
            }
            KingdeeTreeUI.this.tree.setSelectionPaths(selectedPaths);
        }
    }

    protected class InnerPropertyChangeListener
    implements PropertyChangeListener {
        protected InnerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("showCheckBox")) {
                Boolean obj = (Boolean)e.getNewValue();
                KingdeeTreeUI.this.resetShowCheckBox(obj);
            } else if ("isdragnodeenabled".equals(name)) {
                KingdeeTreeUI.this.reSetDragNode((Boolean)e.getNewValue());
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            if (KingdeeTreeUI.this.tree != null) {
                KingdeeTreeUI.this.tree.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.focusGained(e);
        }
    }

    public class CheckMouseHandler
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath path;
            if (e.getModifiers() == 4) {
                return;
            }
            KDTree kdtree = (KDTree)KingdeeTreeUI.this.tree;
            if (kdtree != null && kdtree.isShowCheckBox() && kdtree.isEnabled() && (path = KingdeeTreeUI.this.tree.getClosestPathForLocation(e.getX(), e.getY())) != null) {
                try {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (node.isCheckBoxVisible() && node.isCheckBoxEnabled()) {
                        Rectangle bounds = KingdeeTreeUI.this.getPathBounds(KingdeeTreeUI.this.tree, path);
                        if (this.isCheckRange(e.getX(), e.getY(), bounds, node, KingdeeTreeUI.this.tree.isExpanded(path))) {
                            node.setChecked(!node.isChecked());
                            if (((KDTree)KingdeeTreeUI.this.tree).isSyncChecked()) {
                                node.syncChecked();
                                KingdeeTreeUI.this.tree.repaint();
                            } else {
                                KingdeeTreeUI.this.tree.repaint(bounds);
                            }
                            kdtree.fireTreeNodeStateChange(node);
                        }
                    }
                }
                catch (Exception ec) {
                    logger.error((Object)"err", (Throwable)ec);
                }
            }
        }

        boolean isCheckRange(int x, int y, Rectangle cellRenderRect, DefaultKingdeeTreeNode node, boolean isExpand) {
            Rectangle rcBox = new Rectangle(cellRenderRect);
            Icon icon = node.getRenderIcon(KingdeeTreeUI.this.tree.getModel().isLeaf(node), isExpand);
            rcBox.x += icon.getIconWidth() + 2;
            rcBox.y += (KingdeeTreeUI.this.tree.getRowHeight() - 18) / 2;
            rcBox.height = 18;
            rcBox.width = 18;
            return rcBox.contains(x, y);
        }
    }

    public class SpaceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1965124780275441296L;

        @Override
        public void actionPerformed(ActionEvent e) {
            KDTree kdtree = (KDTree)KingdeeTreeUI.this.tree;
            if (kdtree.isEnabled() && kdtree.isShowCheckBox()) {
                TreePath[] paths = KingdeeTreeUI.this.tree.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    TreePath path = paths[i];
                    try {
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                        if (!node.isCheckBoxVisible() || !node.isCheckBoxEnabled()) continue;
                        node.setChecked(!node.isChecked());
                        Rectangle bounds = KingdeeTreeUI.this.getPathBounds(KingdeeTreeUI.this.tree, path);
                        if (((KDTree)KingdeeTreeUI.this.tree).isSyncChecked()) {
                            node.syncChecked();
                            KingdeeTreeUI.this.tree.repaint();
                        } else {
                            KingdeeTreeUI.this.tree.repaint(bounds);
                        }
                        kdtree.fireTreeNodeStateChange(node);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

