/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.cosmic.ctrl.swing.plaf.PaintUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class KingdeeWorkButtonUI
extends BasicButtonUI {
    private AssistMouseHandler assistMouseHandler = null;
    private AbstractButton selfAbstractButton = null;
    private PropertyHandler propertyHandler = null;
    private Color rollverCol = null;
    private Color pressCol = null;
    private Color arrowCol = null;
    private int faceType = 1;
    private Color grayInitC0 = null;
    private Color grayInitC1 = null;
    private Color grayRolC0 = null;
    private Color grayRolC1 = null;
    private Color grayPresC0 = null;
    private Color grayPresC1 = null;
    private Color grayDeActiveC0 = null;
    private Color grayDeActiveC1 = null;
    private boolean rightLineShow = false;

    public static ComponentUI createUI(JComponent c) {
        int i;
        ButtonUI oldUI;
        KingdeeWorkButtonUI newUI = new KingdeeWorkButtonUI();
        newUI.selfAbstractButton = (AbstractButton)c;
        if (c instanceof KDWorkButton && (oldUI = ((KDWorkButton)c).getUI()) != null && (i = ((KingdeeWorkButtonUI)oldUI).getFactType()) != 1) {
            newUI.setFactType(i);
        }
        return newUI;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
        b.setBorderPainted(true);
        this.setFactType(this.faceType);
        LookAndFeel.installColors(b, "WorkButton.background", "WorkButton.foreground");
        if (b.getMargin() == null || b.getMargin() instanceof UIResource) {
            b.setMargin(UIManager.getInsets("WrokButton.margin"));
        }
        if (b.getParent() != null && b.getParent() instanceof JToolBar) {
            b.setOpaque(false);
        }
    }

    private void initColor() {
        if (this.faceType == 1) {
            if (this.grayInitC0 == null) {
                this.grayInitC0 = UIManager.getColor("WorkButton.grayInitCol0");
                Color color = this.grayInitC0 = this.grayInitC0 != null ? this.grayInitC0 : Color.decode("#F7FBF3");
            }
            if (this.grayInitC1 == null) {
                this.grayInitC1 = UIManager.getColor("WorkButton.grayInitCol1");
                Color color = this.grayInitC1 = this.grayInitC1 != null ? this.grayInitC1 : Color.decode("#D5D5D0");
            }
            if (this.grayRolC0 == null) {
                this.grayRolC0 = UIManager.getColor("WorkButton.grayRolCol0");
                Color color = this.grayRolC0 = this.grayRolC0 != null ? this.grayRolC0 : Color.decode("#D5D6D0");
            }
            if (this.grayRolC1 == null) {
                this.grayRolC1 = UIManager.getColor("WorkButton.grayRolCol1");
                Color color = this.grayRolC1 = this.grayRolC1 != null ? this.grayRolC1 : Color.decode("#F7FBF3");
            }
            if (this.grayPresC0 == null) {
                this.grayPresC0 = UIManager.getColor("WorkButton.grayPresCol0");
                Color color = this.grayPresC0 = this.grayPresC0 != null ? this.grayPresC0 : Color.decode("#D5D6D0");
            }
            if (this.grayPresC1 == null) {
                this.grayPresC1 = UIManager.getColor("WorkButton.grayPresCol1");
                Color color = this.grayPresC1 = this.grayPresC1 != null ? this.grayPresC1 : Color.decode("#F7FBF3");
            }
            if (this.grayDeActiveC0 == null) {
                this.grayDeActiveC0 = UIManager.getColor("WorkButton.grayDeActCol0");
                Color color = this.grayDeActiveC0 = this.grayDeActiveC0 != null ? this.grayDeActiveC0 : Color.decode("#D3D3D3");
            }
            if (this.grayDeActiveC1 == null) {
                this.grayDeActiveC1 = UIManager.getColor("WorkButton.grayDeActCol1");
                this.grayDeActiveC1 = this.grayDeActiveC1 != null ? this.grayDeActiveC1 : Color.decode("#F7F7F7");
            }
            this.rollverCol = null;
            this.pressCol = null;
            this.arrowCol = null;
        } else {
            if (this.arrowCol == null) {
                this.arrowCol = UIManager.getColor("WorkButton.arrowColor");
                Color color = this.arrowCol = this.arrowCol != null ? this.arrowCol : Color.decode("#10497B");
            }
            if (this.rollverCol == null) {
                this.rollverCol = UIManager.getColor("WorkButton.rolloverBackground");
                Color color = this.rollverCol = this.rollverCol != null ? this.rollverCol : Color.decode("#BBD2E7");
            }
            if (this.pressCol == null) {
                this.pressCol = UIManager.getColor("WorkButton.activeBackground");
                this.pressCol = this.pressCol != null ? this.pressCol : Color.decode("#B5CADE");
            }
            this.grayInitC0 = null;
            this.grayInitC1 = null;
            this.grayRolC0 = null;
            this.grayRolC1 = null;
            this.grayPresC0 = null;
            this.grayPresC1 = null;
            this.grayDeActiveC0 = null;
            this.grayDeActiveC1 = null;
        }
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        if (this.assistMouseHandler == null) {
            this.assistMouseHandler = new AssistMouseHandler();
            b.addMouseListener(this.assistMouseHandler);
        }
        if (this.propertyHandler == null) {
            this.propertyHandler = new PropertyHandler();
            b.addPropertyChangeListener(this.propertyHandler);
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        if (this.assistMouseHandler != null) {
            b.removeMouseListener(this.assistMouseHandler);
            this.assistMouseHandler = null;
        }
        if (this.propertyHandler != null) {
            b.removePropertyChangeListener(this.propertyHandler);
            this.propertyHandler = null;
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.rollverCol = null;
        this.pressCol = null;
        this.arrowCol = null;
        this.grayInitC0 = null;
        this.grayInitC1 = null;
        this.grayRolC0 = null;
        this.grayRolC1 = null;
        this.grayPresC0 = null;
        this.grayPresC1 = null;
        this.grayDeActiveC0 = null;
        this.grayDeActiveC1 = null;
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        switch (this.faceType) {
            case 0: {
                this.paintBlueBackGround(g, c);
                break;
            }
            default: {
                this.paintGrayBackground(g, c);
            }
        }
        if (this.isPaintArrow(c)) {
            this.paintWorkArrowButton(g, c);
        }
        super.paint(g, c);
    }

    protected void paintBackground(Graphics g, JComponent c) {
        ButtonModel model = ((AbstractButton)c).getModel();
        boolean isArmed = model.isArmed();
        boolean isRollover = model.isRollover();
        boolean isPress = model.isPressed();
        boolean isEnabled = c.isEnabled();
        if (isEnabled) {
            if (c.getParent() instanceof KDToolBar) {
                if (isRollover || isArmed) {
                    if (isPress) {
                        this.fillBackground(g, c.getWidth(), c.getHeight(), UIManager.getColor("WorkButton.toolbarMousedownShadowBegin"), UIManager.getColor("WorkButton.toolbarMousedownShadowEnd"));
                    } else {
                        this.fillBackground(g, c.getWidth(), c.getHeight(), UIManager.getColor("WorkButton.toolbarMouseoverShadowBegin"), UIManager.getColor("WorkButton.toolbarMouseoverShadowEnd"));
                    }
                }
            } else if (isRollover || isArmed) {
                if (isPress) {
                    PaintUtil.drawHoriShadow(g, c, 5.0f, 1.0f, UIManager.getColor("WorkButton.mousedownShadowBegin"), 5.0f, c.getHeight() - 2, UIManager.getColor("WorkButton.mousedownShadowEnd"));
                } else {
                    PaintUtil.drawHoriShadow(g, c, 5.0f, 1.0f, UIManager.getColor("WorkButton.mouseoverShadowBegin"), 5.0f, c.getHeight() - 2, UIManager.getColor("WorkButton.mouseoverShadowEnd"));
                }
            } else {
                PaintUtil.drawHoriShadow(g, c, 5.0f, 1.0f, UIManager.getColor("WorkButton.initShadowBegin"), 5.0f, c.getHeight() - 2, UIManager.getColor("WorkButton.initShadowEnd"));
            }
        } else if (!(c.getParent() instanceof KDToolBar)) {
            PaintUtil.drawHoriShadow(g, c, 5.0f, 1.0f, UIManager.getColor("WorkButton.disableShadowBegin"), 5.0f, c.getHeight() - 2, UIManager.getColor("WorkButton.disableShadowEnd"));
        }
    }

    protected void paintGrayBackground(Graphics g, JComponent c) {
        this.paintBackground(g, c);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        boolean isEnabled = model.isEnabled();
        boolean isRollover = model.isRollover();
        boolean isArmed = model.isArmed();
        boolean isPressed = model.isPressed();
        if (isEnabled) {
            if (c.getParent() instanceof KDToolBar) {
                if (isRollover || isArmed) {
                    if (isPressed) {
                        g.setColor(UIManager.getColor("WorkButton.toolbarMousedownForeground"));
                    } else {
                        g.setColor(UIManager.getColor("WorkButton.toolbarMouseoverForeground"));
                    }
                } else {
                    g.setColor(UIManager.getColor("ToolBar.foreground"));
                }
            } else if (isRollover || isArmed) {
                if (isPressed) {
                    g.setColor(UIManager.getColor("WorkButton.mousedownForeground"));
                } else {
                    g.setColor(UIManager.getColor("WorkButton.mouseoverForeground"));
                }
            } else {
                g.setColor(UIManager.getColor("WorkButton.initForeground"));
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            if (c.getParent() instanceof KDToolBar) {
                g.setColor(UIManager.getColor("WorkButton.toolbarDisableForeground"));
            } else {
                g.setColor(UIManager.getColor("WorkButton.disableForeground"));
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void fillBackground(Graphics g, int w, int h, Color beginColor, Color endColor) {
        Graphics2D g2d = (Graphics2D)g;
        GradientPaint gradient = null;
        gradient = new GradientPaint(1.0f, 1.0f, beginColor, 1.0f, h - 3, endColor);
        g2d.setPaint(gradient);
        g2d.fillRect(1, 1, w - 2, h - 3);
    }

    protected void paintBlueBackGround(Graphics g, JComponent c) {
        ButtonModel m = ((AbstractButton)c).getModel();
        boolean isArmed = m.isArmed();
        boolean isRollver = m.isRollover();
        boolean isPress = m.isPressed();
        boolean b = false;
        if (c.getParent() instanceof KDToolBar) {
            if (isRollver || isArmed) {
                if (isPress) {
                    this.fillBackground(g, c.getWidth(), c.getHeight(), UIManager.getColor("WorkButton.toolbarMousedownShadowBegin"), UIManager.getColor("WorkButton.toolbarMousedownShadowEnd"));
                } else {
                    this.fillBackground(g, c.getWidth(), c.getHeight(), UIManager.getColor("WorkButton.toolbarMouseoverShadowBegin"), UIManager.getColor("WorkButton.toolbarMouseoverShadowEnd"));
                }
            }
        } else {
            if (isRollver && !isArmed && !isPress) {
                b = true;
                g.setColor(UIManager.getColor("WorkButton.rolloverBackground"));
            } else if (isPress) {
                b = true;
                g.setColor(UIManager.getColor("WorkButton.activeBackground"));
            }
            if (b) {
                int w = c.getWidth();
                int h = c.getHeight();
                g.drawLine(2, h / 2 - 10, w - 3, h / 2 - 10);
                g.drawLine(2, h / 2 + 8, w - 3, h / 2 + 8);
                g.drawLine(1, h / 2 - 9, 1, h / 2 + 7);
                g.drawLine(w - 2, h / 2 - 9, w - 2, h / 2 + 7);
                g.fillRect(2, h / 2 - 9, w - 4, 17);
            }
        }
    }

    public void showLine(boolean flag) {
        this.rightLineShow = flag;
    }

    protected void paintWorkArrowButton(Graphics g, JComponent c) {
        Insets cIn = c.getInsets();
        cIn = cIn != null ? cIn : new Insets(0, 0, 0, 0);
        int startX = c.getWidth() - cIn.right + 5;
        int startY = c.getHeight() / 2 - 2;
        ButtonModel model = ((AbstractButton)c).getModel();
        boolean isRoll = model.isRollover();
        if (isRoll) {
            if (c.getParent() instanceof KDToolBar) {
                g.setColor(UIManager.getColor("WorkButton.toolbarVerticalLineColor"));
            } else {
                g.setColor(UIManager.getColor("WorkButton.verticalLineColor"));
            }
            if (this.rightLineShow) {
                ((Graphics2D)g).drawLine(startX, 0, startX, c.getHeight() - 2);
            }
        }
        int centerX = startX + 10;
        Polygon triangle = new Polygon();
        startX += 2;
        triangle.addPoint(centerX - 4, startY);
        triangle.addPoint(centerX + 4, startY);
        triangle.addPoint(centerX, startY + 4);
        if (c.getParent() instanceof KDToolBar) {
            g.setColor(UIManager.getColor("WorkButton.toolbarArrowColor"));
        } else {
            g.setColor(UIManager.getColor("WorkButton.arrowColor"));
        }
        ((Graphics2D)g).fill(triangle);
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        Icon tmpIcon = null;
        if (icon == null) {
            return;
        }
        if (!model.isEnabled()) {
            tmpIcon = b.getDisabledSelectedIcon();
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b.getPressedIcon();
            if (tmpIcon != null) {
                this.clearTextShiftOffset();
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            tmpIcon = model.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
        } else if (model.isSelected()) {
            tmpIcon = b.getSelectedIcon();
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        if (model.isPressed() && model.isArmed()) {
            icon.paintIcon(c, g, iconRect.x + this.getTextShiftOffset(), iconRect.y + this.getTextShiftOffset());
        } else {
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
    }

    private boolean isPaintArrow(JComponent c) {
        KDWorkButton selfWorkButton = this.getSelfWorkButton(c);
        if (selfWorkButton == null) {
            return false;
        }
        return selfWorkButton.isAssitButton();
    }

    protected void mousePressedOnButton(MouseEvent me) {
        KDWorkButton wb = this.getSelfWorkButton(me.getSource());
        if (wb != null && wb.isEnabled() && wb.isAssitButton() && this.isInArrowScope(me.getX(), me.getY())) {
            this.selfAbstractButton.putClientProperty("IsInArrowScope", Boolean.TRUE);
            String s = (String)wb.getClientProperty("isChild");
            if (s != null && s.equals("true")) {
                wb.getAssistPopup().show(wb, wb.getWidth() - 5, wb.getHeight());
            } else {
                wb.getAssistPopup().show(wb, 0, wb.getHeight());
            }
        } else {
            this.selfAbstractButton.putClientProperty("IsInArrowScope", Boolean.FALSE);
        }
    }

    private boolean isInArrowScope(int x, int y) {
        Insets insets = new Insets(0, 0, 0, 15);
        int w = this.selfAbstractButton.getWidth();
        int h = this.selfAbstractButton.getHeight();
        return x <= w && x >= w - insets.right && y >= 1 && y <= h;
    }

    private KDWorkButton getSelfWorkButton(Object obj) {
        if (obj instanceof KDWorkButton) {
            return (KDWorkButton)obj;
        }
        return null;
    }

    private void resetForMaxAssCompCount(int maxAssCompCount) {
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension d = super.getMinimumSize(c);
        return d;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        return d;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension d = super.getMaximumSize(c);
        return d;
    }

    private void setFactType(Integer newValue) {
        if (newValue == null) {
            return;
        }
        switch (newValue) {
            case 0: {
                this.faceType = 0;
                this.setBlueFaceBorder();
                break;
            }
            default: {
                this.faceType = 1;
                this.setGrayFaceBorder();
            }
        }
        this.initColor();
    }

    private int getFactType() {
        return this.faceType;
    }

    protected void setBlueFaceBorder() {
        this.selfAbstractButton.setBorder(KingdeeBorders.getWorkButtonBorder());
    }

    protected void setGrayFaceBorder() {
        this.selfAbstractButton.setBorder(KingdeeBorders.getCommonWorkButtonBorder());
    }

    private class PropertyHandler
    implements PropertyChangeListener {
        private PropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String pName = pce.getPropertyName();
            if ("maxAssistComponentCount".equals(pName)) {
                Object newVal = pce.getNewValue();
                if (newVal instanceof Integer) {
                    KingdeeWorkButtonUI.this.resetForMaxAssCompCount((Integer)newVal);
                }
            } else if ("selfFaceType".equals(pName)) {
                Integer facetype = (Integer)pce.getNewValue();
                KingdeeWorkButtonUI.this.setFactType(facetype);
            }
        }
    }

    private class AssistMouseHandler
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent me) {
            KingdeeWorkButtonUI.this.mousePressedOnButton(me);
        }
    }
}

