/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.resource;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class KDResourceManager {
    private static final Logger logger = LogUtil.getPackageLogger(KDResourceManager.class);
    private static KDResourceManager res = new KDResourceManager();
    private static Font buttonfont = new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 0, 12);
    static Hashtable images = new Hashtable();

    public static Image getImageOfRapid(String imageName) {
        if (images.containsKey(imageName)) {
            return (Image)images.get(imageName);
        }
        URL url = res.getClass().getResource(imageName);
        if (url != null) {
            try {
                Image image = new ImageIcon(url).getImage();
                if (image != null) {
                    images.put(imageName, image);
                }
                return image;
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return null;
    }

    public static BufferedImage getImage(String imageName) {
        if (images.containsKey(imageName)) {
            return (BufferedImage)images.get(imageName);
        }
        URL url = res.getClass().getResource(imageName);
        if (url != null) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(url);
            }
            catch (IOException e) {
                logger.error((Object)"err", (Throwable)e);
            }
            if (image != null) {
                images.put(imageName, image);
            }
            return image;
        }
        return null;
    }

    public static Image getImageByDefault(String imageName) {
        if (images.containsKey(imageName)) {
            return (Image)images.get(imageName);
        }
        URL url = res.getClass().getResource(imageName);
        if (url != null) {
            Image image = null;
            image = Toolkit.getDefaultToolkit().getImage(url);
            if (image != null) {
                images.put(imageName, image);
            }
            return image;
        }
        return null;
    }

    public static Font getFont() {
        return buttonfont;
    }

    public static String getMLS(String key, String defaultValue) {
        return CtrlSwingMessages.getMLS(key, defaultValue);
    }
}

