/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.util;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class ChineseInital {
    private static final Logger logger = LogUtil.getPackageLogger(ChineseInital.class);
    private static final int[] areaCode = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5590};
    private static final String[] letters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "w", "x", "y", "z"};

    public static String getAllFirstLetter(String str) {
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        StringBuilder _str = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            _str.append(ChineseInital.getFirstLetter(str.substring(i, i + 1)));
        }
        return _str.toString();
    }

    public static String getFirstLetter(String chinese) {
        if (chinese == null || chinese.trim().length() == 0) {
            return "";
        }
        if ((chinese = ChineseInital.conversionStr(chinese, "GB2312", "ISO8859-1")).length() > 1) {
            int li_SectorCode = chinese.charAt(0);
            int li_PositionCode = chinese.charAt(1);
            int li_SecPosCode = (li_SectorCode -= 160) * 100 + (li_PositionCode -= 160);
            if (li_SecPosCode > 1600 && li_SecPosCode < 5590) {
                for (int i = 0; i < 23; ++i) {
                    if (li_SecPosCode < areaCode[i] || li_SecPosCode >= areaCode[i + 1]) continue;
                    chinese = letters[i];
                    break;
                }
            } else {
                chinese = ChineseInital.conversionStr(chinese, "ISO8859-1", "GB2312");
                chinese = chinese.substring(0, 1);
            }
        }
        return chinese;
    }

    private static String conversionStr(String str, String charsetName, String toCharsetName) {
        try {
            str = new String(str.getBytes(charsetName), toCharsetName);
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)"err", (Throwable)ex);
        }
        return str;
    }
}

