/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.cache;

import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.service.IOuterCacheAliveChecker;
import com.kingdee.bos.framework.cache.service.OuterCacheAliveCheckerFactory;
import com.kingdee.eas.common.cache.CacheConfigNode;
import com.kingdee.eas.common.cache.CacheXMLConfiguration;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class CacheConfigDAO {
    private static Logger logger = Logger.getLogger(CacheConfigDAO.class);
    private static CacheConfigDAO ccdao = null;
    private CacheXMLConfiguration xmlConfig;
    private CacheXMLConfiguration customConfig;
    private int maxCacheSize;
    private boolean isCreateByClient = true;
    private boolean isUserCacheEnabled = false;
    Map<String, CacheConfigNode> configMap = new HashMap<String, CacheConfigNode>();
    static Set<String> aliveEhcacheServerSet = Collections.synchronizedSet(new HashSet());

    private CacheConfigDAO(boolean isCreateByClient) {
        this.isCreateByClient = isCreateByClient;
        if (!isCreateByClient) {
            new WatchFileThread("watchCacheFileModify").start();
        } else {
            this.loadConfig();
        }
    }

    public static CacheConfigDAO getInstance() {
        return CacheConfigDAO.getInstance(false);
    }

    public static CacheConfigDAO getInstance(boolean isCreateByClient) {
        if (ccdao == null) {
            ccdao = new CacheConfigDAO(isCreateByClient);
        }
        return ccdao;
    }

    private File getConfigFile() throws Exception {
        String cfgFileName = "CacheConfig.xml";
        String cfgFilePath = this.isCreateByClient ? new StringBuffer().append(System.getProperty("easclient.root")).append(File.separator).append("CacheConfig.xml").toString() : System.getProperty("EAS_HOME") + "/server/properties/" + "CacheConfig.xml";
        File cfgFile = new File(cfgFilePath);
        return cfgFile;
    }

    private File getCustomConfigFile() throws Exception {
        String cfgFilePath = System.getProperty("EAS_HOME") + "/server/properties/" + "CacheCustomConfig.xml";
        File cfgFile = new File(cfgFilePath);
        return cfgFile;
    }

    public int getMaxCacheSizeInMillionByte() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSizeInMillionByte(int size) {
        if (size != this.maxCacheSize) {
            long sizeInByte = size * 1024 * 1024;
            ICacheService ics = CacheServiceFactory.getInstance();
            if (sizeInByte < (long)this.maxCacheSize) {
                ics.discardAll();
            }
            ics.setMaxSize(sizeInByte);
            this.maxCacheSize = size;
        }
    }

    public boolean getIsEntityUsingCache(String bostype) {
        boolean value = false;
        CacheConfigNode entityNode = this.xmlConfig.getConfigNodeByBostype("entity", bostype);
        if (entityNode != null) {
            value = entityNode.isCache();
        }
        return value;
    }

    public String getMethodType(String bosType, String methodName) {
        String retValue = "";
        CacheConfigNode node = this.xmlConfig.getEntityMethodConfig(bosType, methodName);
        if (node == null) {
            node = this.xmlConfig.getFacadeMethodConfig(bosType, methodName);
        }
        if (node != null) {
            retValue = node.getType();
        }
        return retValue;
    }

    private Map<String, CacheConfigNode> createConfigMap(Iterator it, Map<String, CacheConfigNode> configMap) {
        while (it.hasNext()) {
            CacheConfigNode etyNode = (CacheConfigNode)it.next();
            if (!etyNode.isCache()) continue;
            configMap.put(etyNode.getBosType(), etyNode);
            for (CacheConfigNode mtdNode : etyNode.getMethods()) {
                String strKey = etyNode.getBosType() + mtdNode.getName();
                configMap.put(strKey, mtdNode);
            }
        }
        return configMap;
    }

    public Map<String, CacheConfigNode> initConfigMap() {
        this.configMap.clear();
        this.createConfigMap(this.xmlConfig.getEntityConfigList().iterator(), this.configMap);
        this.createConfigMap(this.xmlConfig.getFacadeConfigList().iterator(), this.configMap);
        return this.configMap;
    }

    public void setIsEntityUsingCache(String bostype, boolean usecache) {
    }

    private void initClientCtrlInfo() {
        if (!this.isCreateByClient) {
            return;
        }
        try {
            File clientCtrlFile = this.getClientCtrlFile();
            FileInputStream fin = new FileInputStream(clientCtrlFile);
            Properties props = new Properties();
            props.load(fin);
            fin.close();
            this.maxCacheSize = props.getProperty("cachesize") != null ? Integer.parseInt(props.getProperty("cachesize")) : 16;
            this.isUserCacheEnabled = props.getProperty("isUserCacheEnabled") != null ? "true".equalsIgnoreCase(props.getProperty("isUserCacheEnabled")) : true;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)(EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "8_CacheConfigDAO") + e));
        }
        catch (IOException e) {
            logger.error((Object)(EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "9_CacheConfigDAO") + e));
        }
    }

    private File getClientCtrlFile() throws IOException {
        String ctrlFilePath = new StringBuffer().append(System.getProperty("user.home")).append(File.separator).append("CacheConfig.properties").toString();
        File clientCtrlFile = new File(ctrlFilePath);
        if (!clientCtrlFile.exists()) {
            clientCtrlFile.createNewFile();
        }
        return clientCtrlFile;
    }

    public void loadConfig() {
        try {
            this.xmlConfig = CacheXMLConfiguration.getInstance(this.getConfigFile());
            if (!this.isCreateByClient) {
                this.customConfig = CacheXMLConfiguration.getInstance(this.getCustomConfigFile());
            }
            this.initClientCtrlInfo();
        }
        catch (Exception e) {
            throw new AbortException(e);
        }
    }

    public boolean isUserCacheEnabled() {
        return this.isUserCacheEnabled;
    }

    public boolean isSystemCacheEnabled() {
        return this.xmlConfig.isSystemCacheEnabled();
    }

    public void setUserCacheEnabled(boolean isClientCacheEnabled) {
        this.isUserCacheEnabled = isClientCacheEnabled;
    }

    public void storeConfig() {
        if (!this.isCreateByClient) {
            return;
        }
        try {
            File clientCtrlFile = this.getClientCtrlFile();
            FileOutputStream fout = new FileOutputStream(clientCtrlFile);
            Properties props = new Properties();
            props.put("cachesize", "" + this.maxCacheSize);
            props.put("isUserCacheEnabled", "" + this.isUserCacheEnabled);
            props.store(fout, "cache config information:");
            fout.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)(EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "8_CacheConfigDAO") + e));
        }
        catch (IOException e) {
            logger.error((Object)(EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "9_CacheConfigDAO") + e));
        }
    }

    public boolean isServerCacheEnabled() {
        return this.xmlConfig.isServerCacheEnabled();
    }

    public String[] getMemcacheServerList() {
        return this.customConfig.getMemcacheServerList();
    }

    public int getMemcacheHashAlg() {
        return this.customConfig.getMemcacheHashAlg();
    }

    public boolean isIgnoreException() {
        return this.customConfig.isIgnoreException();
    }

    public Map getStoreLevelMap() {
        return this.customConfig.getStoreLevelMap();
    }

    public String getOuterCacheServerType() {
        return this.customConfig.getOuterCacheServerType();
    }

    public String[] getOuterEhcacheServerAllList() {
        return this.customConfig.getOuterEhcacheServerList();
    }

    public String[] getOuterEhcacheServerList() {
        String[] s = new String[]{};
        return aliveEhcacheServerSet.toArray(s);
    }

    public IOuterCacheAliveChecker getOuterCacheAliveChecker() {
        return OuterCacheAliveCheckerFactory.getOuterCacheAliveChecker();
    }

    private static InetSocketAddress getAddress(String url) throws UnknownHostException {
        String[] s = url.trim().split(":");
        if (s.length != 2) {
            return null;
        }
        String host = s[0];
        int port = Integer.parseInt(s[1]);
        InetAddress addr = InetAddress.getByName(host);
        return new InetSocketAddress(addr, port);
    }

    private static class WatchFileThread
    extends Thread {
        long lastModify = 0L;

        public WatchFileThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (true) {
                if (ccdao != null) {
                    File fileCustom = null;
                    File fileC = null;
                    try {
                        fileCustom = ccdao.getCustomConfigFile();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    try {
                        fileC = ccdao.getConfigFile();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    long curLastModify = (fileCustom == null ? 0L : fileCustom.lastModified()) + (fileC == null ? 0L : fileC.lastModified());
                    if (curLastModify != this.lastModify) {
                        this.lastModify = curLastModify;
                        try {
                            ccdao.loadConfig();
                            ccdao.getStoreLevelMap();
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                    }
                    try {
                        String[] list = ccdao.getOuterEhcacheServerAllList();
                        IOuterCacheAliveChecker checker = ccdao.getOuterCacheAliveChecker();
                        for (String server : list) {
                            if (checker == null) continue;
                            try {
                                if (checker.checkAlive(server)) {
                                    aliveEhcacheServerSet.add(server);
                                    continue;
                                }
                                aliveEhcacheServerSet.remove(server);
                            }
                            catch (Exception e) {
                                logger.error((Object)"checker.checkAlive", (Throwable)e);
                                aliveEhcacheServerSet.remove(server);
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

