/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.cache;

import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.eas.common.cache.CacheConfigFileManagerImpl;
import com.kingdee.eas.common.cache.ICacheConfigFileManager;
import com.kingdee.eas.util.client.EASResource;
import org.apache.log4j.Logger;

public class CacheConfigHelper {
    private static Logger logger = Logger.getLogger(CacheConfigHelper.class);

    public static void createNewCacheConfigFile(String metaDataPath, String configFilePath) {
        try {
            ICacheConfigFileManager manager = CacheConfigFileManagerImpl.getInstance(metaDataPath, configFilePath, true);
            Thread managerThread = new Thread(manager);
            managerThread.start();
        }
        catch (DataAccessException e) {
            logger.error((Object)EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "10_CacheConfigHelper"));
        }
    }

    public static void updateCacheConfigFile(String metaDataPath, String configFilePath) {
        try {
            ICacheConfigFileManager manager = CacheConfigFileManagerImpl.getInstance(metaDataPath, configFilePath, false);
            Thread managerThread = new Thread(manager);
            managerThread.start();
        }
        catch (DataAccessException e) {
            logger.error((Object)EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "11_CacheConfigHelper"));
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            logger.error((Object)(EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "12_CacheConfigHelper") + EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "13_CacheConfigHelper") + EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "14_CacheConfigHelper") + EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "15_CacheConfigHelper") + ""));
            return;
        }
        String strMetaPath = args[0];
        String strFilePath = args[1];
        strMetaPath = strMetaPath.endsWith("\\") || strMetaPath.endsWith("/") ? strMetaPath + "/*.jar" : strMetaPath + "*.jar";
        boolean isCreateFile = "true".equalsIgnoreCase(args[2]);
        if (isCreateFile) {
            CacheConfigHelper.createNewCacheConfigFile(strMetaPath, strFilePath);
        } else {
            CacheConfigHelper.updateCacheConfigFile(strMetaPath, strFilePath);
        }
    }
}

