/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.cache;

import com.kingdee.eas.common.cache.CacheXMLConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class CacheConfigNode {
    Element el;
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ISCACHE = "isCache";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_REGION = "region";
    public static final String ATTR_SCENE = "scene";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_BOSTYPE = "bostype";
    public static final String ATTR_ISQUERYCACHE = "isQueryCache";
    public static final String ATTR_ORMOUTERCACHE = "OrmOuterCache";
    public static final String ATTR_ORMCLONEWHENGETCACHE = "OrmCloneWhenGetCache";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.util.CacheConfigItem");

    protected CacheConfigNode(Element element) {
        this.el = element;
    }

    public static CacheConfigNode CreateEntityNode(String name, String bosType, String isCache, String isQueryCache, String description) {
        Element el = new Element("entity");
        el.setAttribute(new Attribute(ATTR_NAME, name));
        el.setAttribute(new Attribute(ATTR_BOSTYPE, bosType));
        el.setAttribute(new Attribute(ATTR_ISCACHE, isCache));
        el.setAttribute(new Attribute(ATTR_ISQUERYCACHE, isQueryCache));
        el.setAttribute(new Attribute(ATTR_DESCRIPTION, description));
        return new CacheConfigNode(el);
    }

    public static CacheConfigNode CreateFacadeNode(String name, String bosType, String isCache, String isQueryCache, String description) {
        Element el = new Element("facade");
        el.setAttribute(new Attribute(ATTR_NAME, name));
        el.setAttribute(new Attribute(ATTR_BOSTYPE, bosType));
        el.setAttribute(new Attribute(ATTR_ISCACHE, isCache));
        el.setAttribute(new Attribute(ATTR_ISQUERYCACHE, isQueryCache));
        el.setAttribute(new Attribute(ATTR_DESCRIPTION, description));
        return new CacheConfigNode(el);
    }

    public static CacheConfigNode CreateMethodNode(String name, String type, String isCache, String region, String scene, String description) {
        Element el = new Element("method");
        el.setAttribute(new Attribute(ATTR_NAME, name));
        el.setAttribute(new Attribute(ATTR_TYPE, type));
        el.setAttribute(new Attribute(ATTR_ISCACHE, isCache));
        el.setAttribute(new Attribute(ATTR_REGION, region));
        el.setAttribute(new Attribute(ATTR_SCENE, scene));
        el.setAttribute(new Attribute(ATTR_DESCRIPTION, description));
        return new CacheConfigNode(el);
    }

    public synchronized void addChild(CacheConfigNode item) {
        this.el.addContent(item.el);
    }

    public synchronized CacheConfigNode getChildByPath(String path) {
        Element _el = CacheXMLConfiguration.getCacheConfigNodeElementByPath(this.el, path);
        if (_el != null) {
            return new CacheConfigNode(_el);
        }
        return null;
    }

    public synchronized List getChildren(String name) {
        List _els = CacheXMLConfiguration.getCacheConfigNodeElementList(this.el, name);
        if (_els != null) {
            ArrayList<CacheConfigNode> items = new ArrayList<CacheConfigNode>();
            for (int i = 0; i < _els.size(); ++i) {
                Element _el = (Element)_els.get(i);
                CacheConfigNode item = new CacheConfigNode(_el);
                items.add(item);
            }
            return items;
        }
        return null;
    }

    public synchronized List getChildrenByPath(String path) {
        List _els = CacheXMLConfiguration.getCacheConfigNodeElementListByPath(this.el, path);
        if (_els != null) {
            ArrayList<CacheConfigNode> items = new ArrayList<CacheConfigNode>();
            for (int i = 0; i < _els.size(); ++i) {
                Element _el = (Element)_els.get(i);
                CacheConfigNode item = new CacheConfigNode(_el);
                items.add(item);
            }
            return items;
        }
        return null;
    }

    public synchronized void removeChildren(String name) {
        List _els = CacheXMLConfiguration.getCacheConfigNodeElementList(this.el, name);
        if (_els != null) {
            for (int i = 0; i < _els.size(); ++i) {
                Element _el = (Element)_els.get(i);
                if (_el == null) continue;
                this.el.removeContent(_el);
            }
        }
    }

    public synchronized void removeMethod(CacheConfigNode node) {
        Element _el = node.el;
        if (_el != null) {
            this.el.removeContent(_el);
        }
    }

    public synchronized List getMethods() {
        List _listAttr = this.el.getChildren("method");
        ArrayList<CacheConfigNode> props = new ArrayList<CacheConfigNode>();
        for (int i = 0; i < _listAttr.size(); ++i) {
            Element _el = (Element)_listAttr.get(i);
            props.add(new CacheConfigNode(_el));
        }
        return props;
    }

    public synchronized void removeAllMethods() {
        this.el.removeChildren("method");
    }

    public void copy(CacheConfigNode configNode) {
        Element parent = this.el.getParent();
        this.el.detach();
        this.el = (Element)configNode.el.clone();
        if (parent != null) {
            parent.addContent(this.el);
        }
    }

    public String getName() {
        return this.el.getAttributeValue(ATTR_NAME);
    }

    public String getBosType() {
        return this.el.getAttributeValue(ATTR_BOSTYPE);
    }

    public void setBosType(String bosType) {
        this.el.setAttribute(ATTR_BOSTYPE, bosType);
    }

    public String getDescription() {
        return this.el.getAttributeValue(ATTR_DESCRIPTION);
    }

    public boolean isCache() {
        String bCache = this.el.getAttributeValue(ATTR_ISCACHE);
        if (bCache == null || bCache.trim().length() == 0) {
            bCache = "false";
        }
        return bCache.trim().equalsIgnoreCase("true");
    }

    public boolean isQueryCache() {
        String queryCache = this.el.getAttributeValue(ATTR_ISQUERYCACHE);
        if (queryCache == null || queryCache.trim().length() == 0) {
            queryCache = "true";
        }
        return queryCache.trim().equalsIgnoreCase("true");
    }

    public String getRegion() {
        return this.el.getAttributeValue(ATTR_REGION);
    }

    public String getScene() {
        return this.el.getAttributeValue(ATTR_SCENE);
    }

    public String getType() {
        return this.el.getAttributeValue(ATTR_TYPE);
    }

    public boolean isOrmOuterCache() {
        String ormOuterCache = this.el.getAttributeValue(ATTR_ORMOUTERCACHE);
        if (ormOuterCache == null || ormOuterCache.trim().length() == 0) {
            ormOuterCache = "false";
        }
        return ormOuterCache.trim().equalsIgnoreCase("true");
    }

    public boolean isOrmCloneWhenGetCache() {
        String ormCloneWhenGetCache = this.el.getAttributeValue(ATTR_ORMCLONEWHENGETCACHE);
        if (ormCloneWhenGetCache == null || ormCloneWhenGetCache.trim().length() == 0) {
            ormCloneWhenGetCache = "false";
        }
        return ormCloneWhenGetCache.trim().equalsIgnoreCase("true");
    }
}

