/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.calc;

import com.kingdee.eas.common.calc.CalcResource;
import com.kingdee.eas.common.calc.ICalculatorModelListener;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class CalculatorModel {
    public static final int MAX_PRECISION = 15;
    public static final int DEFAULT_PRECISION = 2;
    public static final String NIL_COMMAND = "NIL";
    public static final String OK_COMMAND = "OK";
    public static final String[] commandButtonlabels;
    public static final Map funcMap;
    private static final String V_ZERO = "0";
    private static final String METHOD_NUMBER = "number";
    private static final Operation OPERATION_NONE;
    private static final Operation OPERATION_ADD;
    private static final Operation OPERATION_SUB;
    private static final Operation OPERATION_MULTIPLY;
    private static final Operation OPERATION_DIVIDE;
    private static final String OVERWRITEABLE_OPERATION_COMMAND = "+-*/";
    private EventListenerList listenerList = new EventListenerList();
    private Status status = new Status();
    private boolean separateExpress = false;

    public CalculatorModel() {
        this.reset();
    }

    public void dispatch(String command) {
        String cmdName = this.getCommandMethodName(command.trim().toLowerCase());
        if (cmdName != null) {
            try {
                Method method = null;
                if (METHOD_NUMBER.equals(cmdName)) {
                    method = this.getClass().getMethod(cmdName, String.class);
                    method.invoke((Object)this, (Object[])new String[]{command});
                } else if ("INPUTASNEW".equalsIgnoreCase(cmdName)) {
                    this.status.inputAsNew = true;
                } else {
                    if (!this.status.isCalculated && OVERWRITEABLE_OPERATION_COMMAND.indexOf(command) != -1 && OVERWRITEABLE_OPERATION_COMMAND.indexOf(this.status.command) != -1) {
                        this.status.isCalculated = true;
                    }
                    if ((method = this.getClass().getMethod(cmdName, null)) != null) {
                        method.invoke((Object)this, null);
                    }
                }
                this.status.command = command;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isOKCommand(String cmd) {
        return " ".equals(cmd) || OK_COMMAND.equals(cmd);
    }

    public void setScale(int scale) {
        if (scale < 0) {
            throw new NumberFormatException("Negative scale");
        }
        this.status.scale = scale;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getExpressValue() {
        if (!this.status.isCalculated) {
            this.calculate();
        }
        String v = null;
        int dotIndex = this.status.expressValue.indexOf(46);
        v = dotIndex != -1 && dotIndex == this.status.expressValue.length() - 1 ? this.status.expressValue.substring(0, dotIndex) : this.status.expressValue;
        char c = v.charAt(0);
        if (c == 'E' || c == 'e') {
            v = '1' + v;
        }
        return v;
    }

    public void setExpressValue(String express) {
        this.number(V_ZERO);
        this.status.expressValue = new BigDecimal(express).toString();
        this.fireDisplayChange();
    }

    public void reset() {
        this.c();
    }

    private String getCommandMethodName(String command) {
        if (command.matches("\\d|\\.")) {
            return METHOD_NUMBER;
        }
        String methodName = (String)funcMap.get(command);
        if (methodName != null) {
            return methodName;
        }
        return command;
    }

    private BigDecimal getBigDecimal(String express) {
        BigDecimal bd = new BigDecimal(express);
        bd = bd.setScale(this.status.scale, 4);
        return bd;
    }

    private String fixExpress(String express, boolean limitPrecision, boolean trimRight) {
        int dotIndex = express.indexOf(46);
        if (limitPrecision && dotIndex != -1 && dotIndex + this.status.scale < express.length()) {
            char ch;
            String buf = express.substring(0, dotIndex + this.status.scale + 1);
            if (dotIndex + this.status.scale + 1 < express.length() && (ch = express.charAt(dotIndex + this.status.scale + 1)) > '4') {
                buf = this.getBigDecimal(buf).add(new BigDecimal(Math.pow(0.1, this.status.scale))).toString().substring(0, dotIndex + this.status.scale + 1);
            }
            express = buf;
        }
        if (dotIndex == 0) {
            express = V_ZERO + express;
        } else {
            int len = dotIndex == -1 ? express.length() : dotIndex - 1;
            int stopIndex = 0;
            for (int i = 0; i < len && express.charAt(i) == '0'; ++i) {
                ++stopIndex;
            }
            if (stopIndex > 0) {
                express = express.substring(stopIndex);
            }
        }
        if (trimRight && dotIndex > 0 && dotIndex != express.length()) {
            char[] chs = express.substring(dotIndex + 1).toCharArray();
            StringBuffer buf = new StringBuffer();
            boolean noCheck = false;
            for (int i = chs.length - 1; i >= 0; --i) {
                if (noCheck) {
                    buf.append(chs[i]);
                    continue;
                }
                if (chs[i] == '0') continue;
                buf.append(chs[i]);
                noCheck = true;
            }
            express = express.substring(0, dotIndex + 1) + buf.reverse().toString();
        }
        return express.length() != 0 ? express : V_ZERO;
    }

    private String getFormatedDisplayString(String express) {
        int dotIndex = express.lastIndexOf(46);
        if (dotIndex == -1) {
            express = express + ".";
        }
        if (this.separateExpress) {
            int end = dotIndex;
            if (dotIndex == -1) {
                end = express.length();
            }
            char[] chs = express.substring(0, end).toCharArray();
            StringBuffer sb = new StringBuffer();
            int j = 0;
            for (int i = chs.length - 1; i >= 0; --i) {
                sb.append(chs[i]);
                if (j != 0 && j % 3 == 0 && j != chs.length - 1) {
                    sb.append(',');
                }
                ++j;
            }
            express = sb.reverse().toString() + express.substring(end);
        }
        return express;
    }

    private void fireDisplayChange() {
        Object[] listeners = this.listenerList.getListenerList();
        String expressBuf = this.getFormatedDisplayString(this.status.expressValue);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ICalculatorModelListener.class) continue;
            ((ICalculatorModelListener)listeners[i + 1]).displayChanged(expressBuf);
        }
    }

    private void fireMemoryStatusChange(boolean haveMemory) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ICalculatorModelListener.class) continue;
            ((ICalculatorModelListener)listeners[i + 1]).memoryStatusChanged(haveMemory);
        }
    }

    private void fireMessageAccept(String msg) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ICalculatorModelListener.class) continue;
            ((ICalculatorModelListener)listeners[i + 1]).messageAccepted(msg);
        }
    }

    private void debug(Object value) {
        System.out.println("[CalculatorModel-Debug] " + value);
    }

    public void addCalculateListener(ICalculatorModelListener l) {
        this.listenerList.add(ICalculatorModelListener.class, l);
        this.fireDisplayChange();
    }

    public void removeCalculateListener(ICalculatorModelListener l) {
        this.listenerList.remove(ICalculatorModelListener.class, l);
    }

    public void c() {
        this.status.reset();
        this.number(V_ZERO);
        this.fireDisplayChange();
    }

    public void ce() {
        this.status.expressValue = V_ZERO;
        this.fireDisplayChange();
    }

    public void back() {
        if (this.status.allowBack && this.status.expressValue.length() > 0) {
            this.status.expressValue = this.status.expressValue.substring(0, this.status.expressValue.length() - 1);
            if (this.status.expressValue.length() == 0) {
                this.status.expressValue = V_ZERO;
            }
            this.fireDisplayChange();
        }
    }

    public void number(String value) {
        this.status.allowBack = true;
        if (this.status.inputAsNew) {
            this.status.inputAsNew = false;
            this.status.isCalculated = false;
            if (value.equals(".")) {
                this.status.expressValue = "0.";
            } else {
                this.status.expressValue = value;
            }
        } else if (!value.equals(".") || this.status.expressValue.indexOf(46) == -1) {
            this.status.expressValue = this.fixExpress(this.status.expressValue + value, false, false);
        }
        this.fireDisplayChange();
    }

    public void add() {
        if (!this.status.isCalculated) {
            this.calculate();
        }
        this.status.inputAsNew = true;
        this.status.operation = CalculatorModel.OPERATION_ADD;
    }

    public void sub() {
        if (!this.status.isCalculated) {
            this.calculate();
        }
        this.status.inputAsNew = true;
        this.status.operation = CalculatorModel.OPERATION_SUB;
    }

    public void multiply() {
        if (!this.status.isCalculated) {
            this.calculate();
        }
        this.status.inputAsNew = true;
        this.status.operation = CalculatorModel.OPERATION_MULTIPLY;
    }

    public void divide() {
        if (!this.status.isCalculated) {
            this.calculate();
        }
        this.status.inputAsNew = true;
        this.status.operation = CalculatorModel.OPERATION_DIVIDE;
    }

    public void mod() {
        BigDecimal bd = this.getBigDecimal(this.status.expressValue).divide(this.getBigDecimal("100"), this.status.scale, 4);
        this.status.expressValue = this.fixExpress(bd.toString(), true, true);
        this.status.allowBack = false;
        this.status.inputAsNew = true;
        this.fireDisplayChange();
    }

    public void sqrt() {
        double dd = Math.sqrt(this.getBigDecimal(this.status.expressValue).doubleValue());
        this.status.expressValue = this.fixExpress(String.valueOf(dd), true, true);
        this.status.allowBack = false;
        this.status.inputAsNew = true;
        this.fireDisplayChange();
    }

    public void negate() {
        if (this.status.expressValue.length() > 0) {
            if (this.status.expressValue.charAt(0) == '-') {
                this.status.expressValue = this.status.expressValue.substring(1, this.status.expressValue.length());
            } else {
                this.status.expressValue = "-" + this.status.expressValue;
            }
            this.fireDisplayChange();
        }
    }

    public void mc() {
        this.status.memory = V_ZERO;
        this.fireMemoryStatusChange(false);
    }

    public void mr() {
        this.status.expressValue = this.status.memory;
        this.status.inputAsNew = true;
        this.status.allowBack = false;
        this.fireDisplayChange();
    }

    public void ms() {
        this.status.memory = this.status.expressValue;
        this.status.inputAsNew = true;
        this.status.allowBack = false;
        this.fireMemoryStatusChange(true);
    }

    public void memoryAdd() {
        BigDecimal memoryExpress = this.getBigDecimal(this.status.memory).add(this.getBigDecimal(this.status.expressValue));
        this.status.memory = this.fixExpress(memoryExpress.toString(), true, true);
        this.status.inputAsNew = true;
        this.status.allowBack = false;
        this.fireMemoryStatusChange(true);
    }

    public void byOneDivied() {
        BigDecimal express = this.getBigDecimal(this.status.expressValue);
        if (express.doubleValue() == 0.0) {
            this.fireMessageAccept(CalcResource.getRes("divisor_cannotbe_zero"));
        } else {
            this.status.expressValue = this.fixExpress(new BigDecimal(1.0).divide(express, this.status.scale, 4).toString(), true, true);
            this.status.allowBack = false;
            this.status.inputAsNew = true;
            this.fireDisplayChange();
        }
    }

    public void ok() {
        if (!this.status.isCalculated) {
            this.calculate();
        }
    }

    public void calculate() {
        this.status.inputAsNew = true;
        if (this.status.operation == OPERATION_NONE) {
            this.status.calculated = this.getBigDecimal(this.status.expressValue);
            return;
        }
        if (this.status.isCalculated && this.status.lastOperation == this.status.operation) {
            this.status.expressValue = this.status.lastOperationExpressValue;
        } else {
            this.status.saveOperateMemory();
        }
        BigDecimal express = this.getBigDecimal(this.status.expressValue);
        if (this.status.operation == OPERATION_ADD) {
            this.status.calculated = this.status.calculated.add(express);
        } else if (this.status.operation == OPERATION_SUB) {
            this.status.calculated = this.status.calculated.subtract(express);
        } else if (this.status.operation == OPERATION_MULTIPLY) {
            this.status.calculated = this.status.calculated.multiply(express);
        } else if (this.status.operation == OPERATION_DIVIDE) {
            if (express.doubleValue() == 0.0) {
                this.fireMessageAccept(CalcResource.getRes("divisor_cannotbe_zero"));
                return;
            }
            this.status.calculated = this.status.calculated.divide(express, this.status.scale, 4);
        }
        this.status.expressValue = this.fixExpress(this.status.calculated.toString(), true, true);
        this.status.allowBack = false;
        this.status.isCalculated = true;
        this.fireDisplayChange();
    }

    public void separateExpress() {
        this.separateExpress = !this.separateExpress;
        this.fireDisplayChange();
    }

    public String getLastCommand() {
        return this.status.command;
    }

    static {
        OPERATION_NONE = new Operation("none");
        OPERATION_ADD = new Operation("+");
        OPERATION_SUB = new Operation("-");
        OPERATION_MULTIPLY = new Operation("*");
        OPERATION_DIVIDE = new Operation("/");
        funcMap = new HashMap();
        String cmd = "BK,CE,C,OK,MC,7,8,9,/,sqrt,MR,4,5,6,*,%,MS,1,2,3,-,1/x,M+,0,+/-,.,+,=";
        commandButtonlabels = cmd.split(",");
        funcMap.put("bk", "back");
        funcMap.put("+", "add");
        funcMap.put("-", "sub");
        funcMap.put("*", "multiply");
        funcMap.put("/", "divide");
        funcMap.put("%", "mod");
        funcMap.put("+/-", "negate");
        funcMap.put("1/x", "byOneDivied");
        funcMap.put("=", "calculate");
        funcMap.put(" ", "ok");
        funcMap.put("m+", "memoryAdd");
        funcMap.put("separate", "separateExpress");
    }

    class Status
    implements Cloneable {
        private boolean inputAsNew;
        private boolean allowBack;
        private boolean isCalculated;
        private String command;
        private Operation operation;
        private String expressValue;
        private Operation lastOperation;
        private String lastOperationExpressValue;
        private BigDecimal calculated;
        private String memory = "0";
        private int scale = 2;

        Status() {
        }

        public String getMemory() {
            return this.memory;
        }

        public void reset() {
            this.operation = OPERATION_NONE;
            this.inputAsNew = true;
            this.allowBack = true;
            this.isCalculated = false;
            this.expressValue = CalculatorModel.V_ZERO;
            this.calculated = new BigDecimal(CalculatorModel.V_ZERO);
            this.eraseOperateMemory();
        }

        private void eraseOperateMemory() {
            this.lastOperationExpressValue = null;
            this.lastOperation = null;
        }

        public void saveOperateMemory() {
            this.lastOperationExpressValue = this.expressValue;
            this.lastOperation = this.operation;
        }

        public String toString() {
            return this.operation + "/" + this.expressValue + "/" + this.memory + "/" + this.scale;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    static class Operation {
        private String name = null;

        public String toString() {
            return this.name;
        }

        public Operation(String name) {
            this.name = name;
        }
    }
}

