/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util;

import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.data.FKColumnPairCollection;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.util.EntityCompositionBuilder;
import com.kingdee.eas.util.EntityRefInfo;
import com.kingdee.eas.util.TableEntityMapping;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class EntityRefBuilder {
    private Logger logger = Logger.getLogger(EntityRefBuilder.class);
    public static final String TABLE = "T_SYS_EntityRef";
    public static final String FBOSTYPE = "FBOSType";
    public static final String FREFTABLENAME = "FRefTableName";
    public static final String FREFFIELDNAME = "FRefFieldName";
    public static final String FISBOSFK = "FIsBOSFK";
    public static final String FENTITYNAME = "FEntityName";
    public static final String FENTITYALIAS = "FEntityAlias";
    public static final String FREFENTITYNAME = "FRefEntityName";
    public static final String FREFENTITYALIAS = "FRefEntityAlias";
    private final IMetaDataLoader loader;
    private final PrintStream out;
    private Connection conn = null;

    public static void main(String[] args) {
        if (args == null || args.length != 3) {
            System.out.println("args: java " + EntityRefBuilder.class.getName() + " metadataPath & outputFilePath & bosConfig");
            System.exit(1);
        }
        String metaPath = args[0];
        String outPath = args[1];
        String bosConifg = args[2];
        if (args != null && args.length > 2) {
            bosConifg = args[2];
        }
        try {
            System.setProperty("bos.config", bosConifg);
            EntityRefBuilder builder = new EntityRefBuilder(metaPath, outPath);
            builder.doIt();
            EntityCompositionBuilder builder1 = new EntityCompositionBuilder(metaPath, outPath);
            builder1.doIt();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable te) {
            te.printStackTrace();
        }
    }

    public EntityRefBuilder(String metadataFilePath, String outFilePath) throws FileNotFoundException, UnsupportedEncodingException {
        MetaDataLoaderFactory.setClientMetaDataPath((String)metadataFilePath);
        this.loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        this.out = new PrintStream((OutputStream)new FileOutputStream(outFilePath), false, "UTF-8");
    }

    public EntityRefBuilder(String metadataFilePath, Connection conn) {
        MetaDataLoaderFactory.setClientMetaDataPath((String)metadataFilePath);
        this.loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        this.out = null;
        this.conn = conn;
    }

    private void doIt() {
        TableEntityMapping map = this.initTableMapping();
        this.addExcludedTable(map);
        EntityRefInfo ref = this.buildEntityRef(map);
        ref.output(this.out);
        this.out.close();
    }

    private TableEntityMapping initTableMapping() {
        TableEntityMapping map = new TableEntityMapping();
        EntityObjectCollection entities = this.loader.getEntityCollection();
        if (entities == null || !entities.isEmpty()) {
            // empty if block
        }
        int n = entities.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo ent = entities.get(i);
            DataTableInfo table = ent.getTable();
            if (table == null || table.getExtendedTables() == null) continue;
            map.addMapping(table.getFullName(), ent.getType());
            int m = table.getExtendedTables().size();
            for (int j = 0; j < m; ++j) {
                ExtendedTableInfo extTable = table.getExtendedTables().get(j);
                map.addMapping(extTable.getFullName(), ent.getType());
                map.addExcludedTable(extTable.getFullName(), table.getFullName());
            }
        }
        return map;
    }

    private void addExcludedTable(TableEntityMapping map) {
        EntityObjectCollection entities = this.loader.getEntityCollection();
        int n = entities.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo ent = entities.get(i);
            DataTableInfo table = ent.getTable();
            if (table == null) continue;
            map.addExcludedTable(table.getFullName(), this.getParentTable(ent));
            map.addExcludedTable(table.getFullName(), this.getHeaderTable(ent));
        }
    }

    private String getParentTable(EntityObjectInfo ent) {
        DataTableInfo parentTable;
        EntityObjectInfo parent = ent.getBaseEntity();
        if (parent != null && !parent.isAbstract() && (parentTable = parent.getTable()) != null) {
            return parentTable.getFullName();
        }
        return null;
    }

    private String getHeaderTable(EntityObjectInfo ent) {
        PropertyCollection propCol = ent.getInheritedNoDuplicatedProperties();
        int m = propCol.size();
        for (int j = 0; j < m; ++j) {
            DataTableInfo headTable;
            RelationshipInfo rel;
            PropertyInfo prop = propCol.get(j);
            if (!(prop instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(rel = ((LinkPropertyInfo)prop).getRelationship()).getType())) continue;
            EntityObjectInfo head = null;
            EntityObjectInfo detail = null;
            if (CardinalityType.isOneORZero((CardinalityType)rel.getClientCardinality()) && !CardinalityType.isOneORZero((CardinalityType)rel.getSupplierCardinality())) {
                head = rel.getClientObject();
                detail = rel.getSupplierObject();
            } else if (!CardinalityType.isOneORZero((CardinalityType)rel.getClientCardinality()) && CardinalityType.isOneORZero((CardinalityType)rel.getSupplierCardinality())) {
                head = rel.getSupplierObject();
                detail = rel.getClientObject();
            } else if (CardinalityType.isOneORZero((CardinalityType)rel.getClientCardinality()) && CardinalityType.isOneORZero((CardinalityType)rel.getSupplierCardinality())) {
                head = rel.getClientObject();
                detail = rel.getSupplierObject();
            } else assert (false);
            assert (head != null);
            assert (detail != null);
            if (head == null || detail == null || detail.getType() == null || !detail.getType().equals((Object)ent.getType()) || head.isAbstract() || (headTable = head.getTable()) == null) continue;
            return headTable.getFullName();
        }
        return null;
    }

    private EntityRefInfo buildEntityRef(TableEntityMapping map) {
        EntityRefInfo ref = new EntityRefInfo(this.loader);
        Enumeration e = map.getTableNames();
        while (e.hasMoreElements()) {
            DataTableInfo foreighTable;
            String foreighTableName = (String)e.nextElement();
            BOSObjectType foreighType = map.getMappingType(foreighTableName);
            try {
                foreighTable = this.loader.getDataTable((IMetaDataPK)new MetaDataPK(foreighTableName));
            }
            catch (ClassCastException cce) {
                foreighTable = this.loader.getExtendedTable((IMetaDataPK)new MetaDataPK(foreighTableName));
            }
            ForeignKeyCollection fks = foreighTable.getForeignKeys();
            if (fks == null) continue;
            int n = fks.size();
            for (int i = 0; i < n; ++i) {
                ForeignKeyInfo fk = fks.get(i);
                if (fk == null || fk.getRefTable() == null) {
                    this.logger.error((Object)("\u91cd\u5efa\u5b9e\u4f53\u5f15\u7528\u5173\u7cfb\u51fa\u9519\u3002\u5143\u6570\u636e\u914d\u7f6e\u5f02\u5e38\uff1a\u5f02\u5e38\u8868\uff1a" + foreighTable.getName()));
                    continue;
                }
                String primaryTableName = fk.getRefTable().getFullName();
                BOSObjectType primaryType = map.getMappingType(primaryTableName);
                if (primaryType == null) continue;
                FKColumnPairCollection colPairs = fk.getFKColumnPairs();
                int m = colPairs.size();
                for (int j = 0; j < m; ++j) {
                    if (colPairs.size() != 1) continue;
                    FKColumnPairInfo colPair = colPairs.get(0);
                    String foreighFieldName = colPair.getForeignKeyColumn().getName();
                    if (map.isExcluded(foreighTableName, primaryTableName)) continue;
                    String name = MetaDataUtils.getClassName((String)foreighTableName);
                    ref.addRefItem(primaryType, foreighType, name, foreighFieldName);
                }
            }
        }
        return ref;
    }

    public boolean buildReference() {
        long start = System.currentTimeMillis();
        TableEntityMapping map = this.initTableMapping();
        System.out.println("initTableMapping cost:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.addExcludedTable(map);
        System.out.println("addExcludedTable cost:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        EntityRefInfo ref = this.buildEntityRef(map);
        System.out.println("buildEntityRef cost:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        return ref.buildReference(this.conn);
    }
}

