/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.headfootdesigner;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.ExtendButtonAction;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.StyleDesigner;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDLayout;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

public class HeadFootDesignerPane
extends KDPanel {
    private static final long serialVersionUID = 5125206575708369771L;
    private HeadFootModel model;
    private KDComboBox comboRows = new KDComboBox();
    private JTextField txtRow;
    private KDList lstRows = new KDList();
    private KDWorkButton btnAdd = new KDWorkButton(this.getMLS("add", "Add"));
    private KDWorkButton btnDel = new KDWorkButton(this.getMLS("del", "Del"));
    private KDWorkButton btnMdf = new KDWorkButton(this.getMLS("modify", "Modify"));
    private KDWorkButton btnUp = new KDWorkButton(this.getMLS("moveUp", "\u2191"));
    private KDWorkButton btnDown = new KDWorkButton(this.getMLS("moveDown", "\u2193"));
    private KDWorkButton btnStyle = new KDWorkButton(this.getMLS("style", "Style"));
    private KDPanel panToolBar = new KDPanel();
    private KDWorkButton btnMark = new KDWorkButton();
    private KDWorkButton btnPage = new KDWorkButton();
    private KDWorkButton btnPageCnt = new KDWorkButton();
    private KDWorkButton btnDate = new KDWorkButton();
    private KDWorkButton btnTime = new KDWorkButton();
    private StyleDesigner sd;

    public HeadFootDesignerPane() {
        this(null);
    }

    public HeadFootDesignerPane(String[] dataList) {
        this.initComponents(dataList);
        this.installListener();
        this.installKeyListener();
    }

    private void init() {
        this.lstRows.removeAllElements();
        ListIterator mo = this.getModel().getRows();
        while (mo.hasNext()) {
            Object aRow = mo.next();
            if (!(aRow instanceof HeadFootRow)) continue;
            this.lstRows.addElement(((HeadFootRow)aRow).clone());
        }
        this.txtRow.setText("");
    }

    private void initComponents(String[] dataList) {
        this.comboRows.setEditable(true);
        if (dataList != null) {
            this.comboRows.addItems((Object[])dataList);
        }
        this.txtRow = (JTextField)this.comboRows.getEditor().getEditorComponent();
        this.lstRows.setSelectionMode(0);
        this.btnAdd.setEnabled(false);
        this.btnDel.setEnabled(false);
        this.btnMdf.setEnabled(false);
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        this.btnStyle.setEnabled(false);
        this.btnMark.setToolTipText(this.getMLS("toolTipMark", ""));
        this.btnPage.setToolTipText(this.getMLS("toolTipPage", ""));
        this.btnPageCnt.setToolTipText(this.getMLS("toolTipPageCount", ""));
        this.btnDate.setToolTipText(this.getMLS("toolTipDate", ""));
        this.btnTime.setToolTipText(this.getMLS("toolTipTime", ""));
        ImageIcon bi = ResourceManager.getImage("tbtn_paragragh.gif");
        if (bi == null) {
            this.btnMark.setText("x|x");
        } else {
            this.btnMark.setIcon((Icon)bi);
        }
        bi = ResourceManager.getImage("tbtn_page.gif");
        if (bi == null) {
            this.btnPage.setText(this.getMLS("toolTipPage", ""));
        } else {
            this.btnPage.setIcon((Icon)bi);
        }
        bi = ResourceManager.getImage("tbtn_allpagenumber.gif");
        if (bi == null) {
            this.btnPageCnt.setText(this.getMLS("toolTipPageCount", ""));
        } else {
            this.btnPageCnt.setIcon((Icon)bi);
        }
        bi = ResourceManager.getImage("tbtn_date.gif");
        if (bi == null) {
            this.btnDate.setText(this.getMLS("toolTipDate", ""));
        } else {
            this.btnDate.setIcon((Icon)bi);
        }
        bi = ResourceManager.getImage("tbtn_time.gif");
        if (bi == null) {
            this.btnTime.setText(this.getMLS("toolTipTime", ""));
        } else {
            this.btnTime.setIcon((Icon)bi);
        }
        this.btnMark.setOpaque(false);
        this.btnPage.setOpaque(false);
        this.btnPageCnt.setOpaque(false);
        this.btnDate.setOpaque(false);
        this.btnTime.setOpaque(false);
        this.panToolBar.add((Component)this.btnMark);
        this.panToolBar.add((Component)this.btnPage);
        this.panToolBar.add((Component)this.btnPageCnt);
        this.panToolBar.add((Component)this.btnDate);
        this.panToolBar.add((Component)this.btnTime);
        FlowLayout layout = new FlowLayout();
        layout.setHgap(0);
        layout.setVgap(0);
        layout.setAlignment(0);
        this.panToolBar.setLayout((LayoutManager)layout);
        this.panToolBar.setOpaque(false);
        KDScrollPane scpTemp = new KDScrollPane((Component)this.lstRows);
        this.add((Component)this.panToolBar);
        this.add((Component)this.comboRows);
        this.add((Component)scpTemp);
        this.add((Component)this.btnAdd);
        this.add((Component)this.btnDel);
        this.add((Component)this.btnMdf);
        this.add((Component)this.btnUp);
        this.add((Component)this.btnDown);
        this.add((Component)this.btnStyle);
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 436, 210));
        this.setPreferredSize(new Dimension(350, 252));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 10, 330, 21);
        cons.anchor = 12;
        this.panToolBar.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 40, 330, 21);
        cons.anchor = 12;
        this.comboRows.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 70, 330, 130);
        cons.anchor = 15;
        scpTemp.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(350, 40, 73, 21);
        cons.anchor = 8;
        this.btnAdd.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(350, 64, 73, 21);
        cons.anchor = 8;
        this.btnDel.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(350, 88, 73, 21);
        cons.anchor = 8;
        this.btnMdf.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(350, 122, 73, 21);
        cons.anchor = 8;
        this.btnUp.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(350, 146, 73, 21);
        cons.anchor = 8;
        this.btnDown.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(350, 180, 73, 21);
        cons.anchor = 8;
        this.btnStyle.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
    }

    private void installListener() {
        MyActionHandler actionHandler = new MyActionHandler();
        this.btnAdd.addActionListener((ActionListener)actionHandler);
        this.btnDel.addActionListener((ActionListener)actionHandler);
        this.btnMdf.addActionListener((ActionListener)actionHandler);
        this.btnUp.addActionListener((ActionListener)actionHandler);
        this.btnDown.addActionListener((ActionListener)actionHandler);
        this.btnStyle.addActionListener((ActionListener)actionHandler);
        this.btnMark.addActionListener((ActionListener)actionHandler);
        this.btnPage.addActionListener((ActionListener)actionHandler);
        this.btnPageCnt.addActionListener((ActionListener)actionHandler);
        this.btnDate.addActionListener((ActionListener)actionHandler);
        this.btnTime.addActionListener((ActionListener)actionHandler);
        this.lstRows.addListSelectionListener((ListSelectionListener)new ListHandler());
        this.txtRow.getDocument().addDocumentListener(new DocumentHandler());
    }

    private void installKeyListener() {
        KeyStroke ks_Mark = KeyStroke.getKeyStroke(83, 8);
        KeyStroke ks_Page = KeyStroke.getKeyStroke(80, 8);
        KeyStroke ks_Pgct = KeyStroke.getKeyStroke(67, 8);
        KeyStroke ks_Date = KeyStroke.getKeyStroke(68, 8);
        KeyStroke ks_Time = KeyStroke.getKeyStroke(84, 8);
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(ks_Mark, "Along_ALT_S");
        actionMap.put(inputMap.get(ks_Mark), new KeyMarkAction());
        inputMap.put(ks_Page, "Along_ALT_P");
        actionMap.put(inputMap.get(ks_Page), new KeyPageAction());
        inputMap.put(ks_Pgct, "Along_ALT_C");
        actionMap.put(inputMap.get(ks_Pgct), new KeyPageCountAction());
        inputMap.put(ks_Date, "Along_ALT_D");
        actionMap.put(inputMap.get(ks_Date), new KeyDateAction());
        inputMap.put(ks_Time, "Along_ALT_T");
        actionMap.put(inputMap.get(ks_Time), new KeyTimeAction());
    }

    public HeadFootModel getModel() {
        return this.model;
    }

    public void setModel(HeadFootModel model) {
        this.model = model;
        this.init();
    }

    private void insertText(String str) {
        try {
            int selectionStart = this.txtRow.getSelectionStart();
            int selectionLength = this.txtRow.getSelectionEnd() - selectionStart;
            this.txtRow.getDocument().remove(selectionStart, selectionLength);
            this.txtRow.getDocument().insertString(this.txtRow.getCaretPosition(), str, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.txtRow.requestFocus();
    }

    private void updateModel() {
        if (this.model == null) {
            this.model = new HeadFootModel();
        }
        this.model.setRowList(new ArrayList());
        for (int i = 0; i < this.lstRows.getElementCount(); ++i) {
            this.model.addRow((HeadFootRow)this.lstRows.getElement(i));
        }
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlPrintMessages.getMLS(key, defaultValue);
    }

    public void addExtendButton(ExtendButtonAction action) {
        KDWorkButton btn = new KDWorkButton();
        btn.addActionListener((ActionListener)new MyActionHandler());
        btn.setAction((Action)action);
        btn.addActionListener((ActionListener)new PreAction());
        btn.setOpaque(false);
        Object icon = action.getValue("ICON");
        if (icon instanceof Icon) {
            btn.setIcon((Icon)icon);
        }
        this.panToolBar.add((Component)btn);
    }

    private class PreAction
    implements ActionListener {
        private PreAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDWorkButton btn;
            Action action;
            if (e.getSource() instanceof KDWorkButton && (action = (btn = (KDWorkButton)e.getSource()).getAction()) instanceof ExtendButtonAction) {
                ((ExtendButtonAction)action).setString(HeadFootDesignerPane.this.txtRow.getSelectedText());
            }
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (!HeadFootDesignerPane.this.btnAdd.isEnabled()) {
                HeadFootDesignerPane.this.btnAdd.setEnabled(true);
            }
            if (!HeadFootDesignerPane.this.btnMdf.isEnabled() && HeadFootDesignerPane.this.lstRows.getSelectedIndex() != -1) {
                HeadFootDesignerPane.this.btnMdf.setEnabled(true);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (HeadFootDesignerPane.this.txtRow.getText().equals("")) {
                HeadFootDesignerPane.this.btnAdd.setEnabled(false);
                if (HeadFootDesignerPane.this.lstRows.getSelectedIndex() != -1) {
                    HeadFootDesignerPane.this.btnMdf.setEnabled(false);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int idx = HeadFootDesignerPane.this.lstRows.getSelectedIndex();
            if (idx != -1) {
                HeadFootDesignerPane.this.txtRow.setText(HeadFootDesignerPane.this.lstRows.getSelectedValue().toString());
                HeadFootDesignerPane.this.btnDel.setEnabled(true);
                HeadFootDesignerPane.this.btnMdf.setEnabled(true);
                HeadFootDesignerPane.this.btnStyle.setEnabled(true);
            } else {
                HeadFootDesignerPane.this.btnMdf.setEnabled(false);
                HeadFootDesignerPane.this.btnDel.setEnabled(false);
                HeadFootDesignerPane.this.btnStyle.setEnabled(false);
            }
            if (idx == 0 || idx == -1) {
                HeadFootDesignerPane.this.btnUp.setEnabled(false);
            } else {
                HeadFootDesignerPane.this.btnUp.setEnabled(true);
            }
            if (idx == HeadFootDesignerPane.this.lstRows.getElementCount() - 1 || idx == -1) {
                HeadFootDesignerPane.this.btnDown.setEnabled(false);
            } else {
                HeadFootDesignerPane.this.btnDown.setEnabled(true);
            }
        }
    }

    private class MyActionHandler
    implements ActionListener {
        private MyActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDWorkButton btn;
            Action action;
            Object source = e.getSource();
            if (source.equals(HeadFootDesignerPane.this.btnAdd)) {
                if (!HeadFootDesignerPane.this.txtRow.getText().equals("")) {
                    HeadFootRow newRow = new HeadFootRow(HeadFootDesignerPane.this.txtRow.getText());
                    HeadFootDesignerPane.this.lstRows.addElement((Object)newRow);
                    HeadFootDesignerPane.this.lstRows.setSelectedValue((Object)newRow, true);
                    HeadFootDesignerPane.this.updateModel();
                }
            } else if (source.equals(HeadFootDesignerPane.this.btnDel)) {
                if (HeadFootDesignerPane.this.lstRows.getSelectedIndex() != -1) {
                    HeadFootDesignerPane.this.lstRows.removeElementAt(HeadFootDesignerPane.this.lstRows.getSelectedIndex());
                    HeadFootDesignerPane.this.txtRow.setText("");
                    HeadFootDesignerPane.this.txtRow.requestFocus();
                    HeadFootDesignerPane.this.updateModel();
                }
            } else if (source.equals(HeadFootDesignerPane.this.btnMdf)) {
                if (HeadFootDesignerPane.this.lstRows.getSelectedIndex() != -1 && !HeadFootDesignerPane.this.txtRow.getText().equals("")) {
                    HeadFootRow oldRow = (HeadFootRow)HeadFootDesignerPane.this.lstRows.getSelectedValue();
                    HeadFootRow newRow = new HeadFootRow(HeadFootDesignerPane.this.txtRow.getText(), oldRow.getSA());
                    HeadFootDesignerPane.this.lstRows.setElement((Object)newRow, HeadFootDesignerPane.this.lstRows.getSelectedIndex());
                    HeadFootDesignerPane.this.updateModel();
                }
            } else if (source.equals(HeadFootDesignerPane.this.btnUp)) {
                if (HeadFootDesignerPane.this.lstRows.getSelectedIndex() > 0) {
                    int idx = HeadFootDesignerPane.this.lstRows.getSelectedIndex();
                    Object item = HeadFootDesignerPane.this.lstRows.getSelectedValue();
                    HeadFootDesignerPane.this.lstRows.removeElementAt(idx);
                    HeadFootDesignerPane.this.lstRows.insertElement(item, idx - 1);
                    HeadFootDesignerPane.this.lstRows.setSelectedIndex(idx - 1);
                    HeadFootDesignerPane.this.updateModel();
                }
            } else if (source.equals(HeadFootDesignerPane.this.btnDown)) {
                if (HeadFootDesignerPane.this.lstRows.getSelectedIndex() >= 0 && HeadFootDesignerPane.this.lstRows.getSelectedIndex() < HeadFootDesignerPane.this.lstRows.getElementCount() - 1) {
                    int idx = HeadFootDesignerPane.this.lstRows.getSelectedIndex();
                    Object item = HeadFootDesignerPane.this.lstRows.getSelectedValue();
                    HeadFootDesignerPane.this.lstRows.removeElementAt(idx);
                    HeadFootDesignerPane.this.lstRows.insertElement(item, idx + 1);
                    HeadFootDesignerPane.this.lstRows.setSelectedIndex(idx + 1);
                    HeadFootDesignerPane.this.updateModel();
                }
            } else if (source.equals(HeadFootDesignerPane.this.btnStyle)) {
                if (HeadFootDesignerPane.this.lstRows.getSelectedIndex() != -1) {
                    if (HeadFootDesignerPane.this.sd == null) {
                        Frame f = JOptionPane.getFrameForComponent((Component)((Object)HeadFootDesignerPane.this));
                        HeadFootDesignerPane.this.sd = new StyleDesigner(f, true);
                        int showPanel = 2;
                        HeadFootDesignerPane.this.sd.setShowPanel(showPanel);
                        HeadFootDesignerPane.this.sd.getPanFont().getLbcFontColor().setVisible(false);
                    }
                    HeadFootRow row = (HeadFootRow)HeadFootDesignerPane.this.lstRows.getSelectedValue();
                    HeadFootDesignerPane.this.sd.setSA(row.getSA());
                    HeadFootDesignerPane.this.sd.setTitle(HeadFootDesignerPane.this.getMLS("styleDesignerTitle1", "") + (HeadFootDesignerPane.this.lstRows.getSelectedIndex() + 1) + HeadFootDesignerPane.this.getMLS("styleDesignerTitle2", ""));
                    HeadFootDesignerPane.this.sd.setLocationRelativeTo(null);
                    HeadFootDesignerPane.this.sd.show();
                    if (HeadFootDesignerPane.this.sd.isChanged()) {
                        row.setSA(HeadFootDesignerPane.this.sd.getSA());
                    }
                    HeadFootDesignerPane.this.updateModel();
                }
            } else if (source.equals(HeadFootDesignerPane.this.btnMark)) {
                HeadFootDesignerPane.this.insertText("&|");
            } else if (source.equals(HeadFootDesignerPane.this.btnPage)) {
                HeadFootDesignerPane.this.insertText("&[Page]");
            } else if (source.equals(HeadFootDesignerPane.this.btnPageCnt)) {
                HeadFootDesignerPane.this.insertText("&[PageCount]");
            } else if (source.equals(HeadFootDesignerPane.this.btnDate)) {
                HeadFootDesignerPane.this.insertText("&[Date]");
            } else if (source.equals(HeadFootDesignerPane.this.btnTime)) {
                HeadFootDesignerPane.this.insertText("&[Time]");
            } else if (source instanceof KDWorkButton && (action = (btn = (KDWorkButton)source).getAction()) instanceof ExtendButtonAction) {
                HeadFootDesignerPane.this.insertText(((ExtendButtonAction)action).getString());
            }
        }
    }

    private class KeyTimeAction
    extends AbstractAction {
        private static final long serialVersionUID = -6750908632642036729L;

        private KeyTimeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeadFootDesignerPane.this.insertText("&[Time]");
        }
    }

    private class KeyDateAction
    extends AbstractAction {
        private static final long serialVersionUID = 4967287614180855951L;

        private KeyDateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeadFootDesignerPane.this.insertText("&[Date]");
        }
    }

    private class KeyPageCountAction
    extends AbstractAction {
        private static final long serialVersionUID = -5328033280987081983L;

        private KeyPageCountAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeadFootDesignerPane.this.insertText("&[PageCount]");
        }
    }

    private class KeyPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 5710698930322599726L;

        private KeyPageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeadFootDesignerPane.this.insertText("&[Page]");
        }
    }

    private class KeyMarkAction
    extends AbstractAction {
        private static final long serialVersionUID = -7817165174256506075L;

        private KeyMarkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeadFootDesignerPane.this.insertText("&|");
        }
    }
}

