/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.headfootdesigner;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.io.Serializable;

public class HeadFootRow
implements Serializable {
    private static final long serialVersionUID = 1255340217252535483L;
    private String text;
    private String originText;
    private StyleAttributes sa;

    public HeadFootRow() {
        this("");
    }

    public HeadFootRow(String text) {
        this(text, Styles.getDefaultSA());
    }

    public HeadFootRow(String text, StyleAttributes sa) {
        this.setText(text);
        this.setSA(sa);
    }

    public StyleAttributes getSA() {
        return this.sa;
    }

    public String getText() {
        return this.text;
    }

    public void setSA(StyleAttributes sa) {
        this.sa = sa;
    }

    public void setText(String string) {
        this.text = string;
        this.originText = null;
    }

    public String toString() {
        return this.getOriginText();
    }

    public int hashCode() {
        return this.text.hashCode() ^ this.sa.hashCode();
    }

    public boolean equals(Object o) {
        HeadFootRow r;
        return o instanceof HeadFootRow && (r = (HeadFootRow)o).getText().equals(this.getText()) && r.getSA().equals((Object)this.getSA());
    }

    public Object clone() {
        HeadFootRow newRow = new HeadFootRow();
        newRow.setText(this.getText());
        newRow.setOriginText(this.originText);
        newRow.setSA(Styles.getSA((ShareStyleAttributes)(this.getSA() == null ? Styles.getDefaultSSA() : this.getSA())));
        return newRow;
    }

    public IXmlElement writeToXmlNode(String rowName) {
        IXmlElement eleRow = XmlUtil.createNode((String)"HeadFootRow");
        eleRow.setAttribute("id", rowName);
        IXmlElement eleStyle = StyleParser.getStyleElement((ShareStyleAttributes)this.getSA(), (String)(rowName + "_Style"));
        IXmlElement eleText = XmlUtil.createNode((String)"Text");
        eleText.setAttribute("id", rowName + "_Text");
        eleText.addCData(this.getOriginText());
        eleRow.addChild(eleText);
        eleRow.addChild(eleStyle);
        return eleRow;
    }

    public boolean readFromXmlNode(IXmlElement eleRow) {
        if (eleRow.getName().equals("HeadFootRow")) {
            String text2 = eleRow.getChild("Text").getText();
            StyleAttributes sa2 = StyleParser.parseDefSA((IXmlElement)eleRow.getChild("Style"));
            this.setText(text2);
            this.setOriginText(text2);
            this.setSA(sa2);
            return true;
        }
        return false;
    }

    public void setOriginText(String originText) {
        this.originText = originText;
    }

    public String getOriginText() {
        if (StringUtil.isEmptyString((String)this.originText)) {
            return this.getText();
        }
        return this.originText;
    }
}

