/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.attribute;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.IXmlTranslate;
import javax.print.attribute.PrintRequestAttribute;
import org.apache.log4j.Logger;

public class ValidateAreaInfo
implements PrintRequestAttribute,
IXmlTranslate {
    private static final Logger logger = LogUtil.getPackageLogger(ValidateAreaInfo.class);
    private static final long serialVersionUID = -1875885047427733603L;
    private float top;
    private float left;
    private float bottom;
    private float right;
    public static String NAME = "ValideAreaInfo";
    public static final int INCH = 25400;
    public static final int MM = 1000;
    public static final ValidateAreaInfo DEFAULT = new ValidateAreaInfo(0.3f, 0.3f, 0.3f, 0.3f, 1000);

    public ValidateAreaInfo(float pTop, float pLeft, float pBottom, float pRight, int pUnits) {
        if ((double)pTop < 0.0 || (double)pLeft < 0.0 || (double)pBottom <= 0.0 || (double)pRight <= 0.0 || pUnits < 1) {
            throw new IllegalArgumentException("0 or negative value argument");
        }
        this.top = pTop * (float)pUnits;
        this.left = pLeft * (float)pUnits;
        this.bottom = pBottom * (float)pUnits;
        this.right = pRight * (float)pUnits;
    }

    public float getTop(int unit) {
        return ValidateAreaInfo.convertFromMicrometers(this.top, unit);
    }

    public float getLeft(int unit) {
        return ValidateAreaInfo.convertFromMicrometers(this.left, unit);
    }

    public float getBottom(int unit) {
        return ValidateAreaInfo.convertFromMicrometers(this.bottom, unit);
    }

    public float getRight(int unit) {
        return ValidateAreaInfo.convertFromMicrometers(this.right, unit);
    }

    public Class getCategory() {
        return ValidateAreaInfo.class;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public float[] getPrintableArea(int units) {
        return new float[]{this.getTop(units), this.getLeft(units), this.getBottom(units), this.getRight(units)};
    }

    public String toString(int units, String unitsName) {
        if (unitsName == null) {
            unitsName = "";
        }
        float[] vals = this.getPrintableArea(units);
        String str = "(" + vals[0] + "," + vals[1] + ")->(" + vals[2] + "," + vals[3] + ")";
        return str + unitsName;
    }

    public boolean equals(Object object) {
        boolean ret = false;
        if (object instanceof ValidateAreaInfo) {
            ValidateAreaInfo mm = (ValidateAreaInfo)object;
            if (ArrayUtil.isEqual((Float)Float.valueOf(this.top), (Float)Float.valueOf(mm.top)) && ArrayUtil.isEqual((Float)Float.valueOf(this.left), (Float)Float.valueOf(mm.left)) && ArrayUtil.isEqual((Float)Float.valueOf(this.bottom), (Float)Float.valueOf(mm.bottom)) && ArrayUtil.isEqual((Float)Float.valueOf(this.right), (Float)Float.valueOf(mm.right))) {
                ret = true;
            }
        }
        return ret;
    }

    public String toString() {
        return this.toString(1000, "mm");
    }

    public int hashCode() {
        return (int)(this.top + 37.0f * this.right + 43.0f * this.bottom + 47.0f * this.right);
    }

    private static float convertFromMicrometers(float v, int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        return v / (float)units;
    }

    @Override
    public IXmlElement toXmlElement() {
        IXmlElement e = AbstractXmlTranslate.createElement(this.getName());
        ValidateAreaInfo.setAttribute(e, "top", "" + this.top);
        ValidateAreaInfo.setAttribute(e, "left", "" + this.left);
        ValidateAreaInfo.setAttribute(e, "bottom", "" + this.bottom);
        ValidateAreaInfo.setAttribute(e, "right", "" + this.right);
        return e;
    }

    @Override
    public Object fromXmlElement(IXmlElement e) {
        if (e == null) {
            return null;
        }
        if (e.getName().equals(this.getName())) {
            try {
                this.top = Float.parseFloat(ValidateAreaInfo.getAttributeValue(e, "top"));
                this.left = Float.parseFloat(ValidateAreaInfo.getAttributeValue(e, "left"));
                this.bottom = Float.parseFloat(ValidateAreaInfo.getAttributeValue(e, "bottom"));
                this.right = Float.parseFloat(ValidateAreaInfo.getAttributeValue(e, "right"));
            }
            catch (Exception ex) {
                logger.error((Object)"err", (Throwable)ex);
            }
        }
        return this;
    }

    private static void setAttribute(IXmlElement e, String name, String value) {
        AbstractXmlTranslate.setAttribute(e, name, value);
    }

    private static String getAttributeValue(IXmlElement e, String name) {
        return AbstractXmlTranslate.getAttributeValue(e, name);
    }
}

