/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.ui;

import com.kingdee.cosmic.ctrl.print.ConfigManager;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import com.kingdee.cosmic.ctrl.print.config.attribute.PageRangeInfo;
import com.kingdee.cosmic.ctrl.print.config.ui.AbstractConfigUI;
import com.kingdee.cosmic.ctrl.print.config.ui.GeneralPanel;
import com.kingdee.cosmic.ctrl.print.config.ui.PrintConfigModel;
import java.awt.Component;
import java.awt.Dimension;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.PageRanges;
import sun.print.SunAlternateMedia;

public class PrintGeneralUI
extends AbstractConfigUI {
    private static final long serialVersionUID = 7537555352172147970L;
    public static final int PAGE_W = 405;
    protected GeneralPanel printConfigDialog;
    protected ConfigManager printermanager;

    public void init(ConfigManager manager) {
        this.printermanager = manager;
        this.config = manager.getModel();
        this.initPanel();
    }

    public void setManager(ConfigManager manager) {
        this.printermanager = manager;
        this.config = manager.getModel();
    }

    @Override
    public void init(PrintJobConfig manager, String uniqueName) {
        super.init(manager, uniqueName);
        this.initPanel();
        this.setManager(this.manager.getPrinter().getPrintConfig());
    }

    protected void initPanel() {
        PrintConfigModel theconfig = (PrintConfigModel)this.config;
        PrintService[] services = theconfig.getPrintServices();
        int defaultServiceIndex = theconfig.getPrintServiceIndex();
        this.printConfigDialog = new GeneralPanel(services, theconfig.getPrintRequestAttributeSet(), defaultServiceIndex, theconfig);
        this.add((Component)((Object)this.printConfigDialog));
        this.setPreferredSize(new Dimension(405, this.printConfigDialog.getPreferredSize().height));
    }

    @Override
    public IConfigModel createConfigModel() {
        return new PrintConfigModel();
    }

    @Override
    public void updateConfigToUI() {
    }

    public PrintService getPrintService() {
        return this.printConfigDialog.getPrintService();
    }

    @Override
    public void approve() {
        PrintConfigModel theconfig = (PrintConfigModel)this.config;
        PrintService service = this.printConfigDialog.getPrintService();
        if (service != null) {
            theconfig.setPrintService(service);
        }
        PrintRequestAttributeSet attributes = theconfig.getPrintRequestAttributeSet();
        PrintRequestAttributeSet newas = this.printConfigDialog.getAttributes();
        Class<Destination> dstCategory = Destination.class;
        Class<SunAlternateMedia> amCategory = SunAlternateMedia.class;
        Class<PageRanges> pageRangeCategory = PageRanges.class;
        for (Class category : new Class[]{dstCategory, amCategory, pageRangeCategory, PageRangeInfo.class}) {
            if (!attributes.containsKey(category) || newas.containsKey(category)) continue;
            attributes.remove(category);
        }
        if (theconfig.getEncode() != this.printConfigDialog.getEncode()) {
            this.printermanager.setChange(true);
        }
        theconfig.setEncode(this.printConfigDialog.getEncode());
        theconfig.setScaleType(this.printConfigDialog.getScaleType());
        if (attributes.addAll(newas)) {
            this.printermanager.setChange(true);
        }
        if (this.printConfigDialog.isPrintDirect()) {
            theconfig.setPrintDirect(true);
        }
    }

    public void cancel() {
        this.approve();
    }
}

