/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.control;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.config.ui.AbstractStartLocationModel;
import com.kingdee.cosmic.ctrl.print.control.ControlPrint;
import com.kingdee.cosmic.ctrl.print.control.CtrlPageFormat;
import com.kingdee.cosmic.ctrl.print.ui.component.Canvas;
import com.kingdee.cosmic.ctrl.print.ui.component.MultiPaper;
import com.kingdee.cosmic.ctrl.print.ui.component.PainterInfo;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import org.apache.log4j.Logger;

public class CtrlPrintable
implements Printable {
    private static final Logger logger = LogUtil.getPackageLogger(CtrlPrintable.class);
    protected KDPrinter printer;
    protected ControlPrint controlPrint;
    private int firstIndex = -1;
    private Canvas nowPaper = null;

    public CtrlPrintable(ControlPrint control, KDPrinter aprinter) {
        this.controlPrint = control;
        this.printer = aprinter;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        pageIndex = KDPrinterUtils.setReversePageIndex(this.controlPrint.getAttribute(), pageIndex);
        int res = 1;
        Graphics2D g2d = (Graphics2D)g;
        if (this.firstIndex != pageIndex) {
            this.nowPaper = this.getPaper(pageIndex);
            this.firstIndex = pageIndex;
        }
        try {
            if (this.nowPaper != null) {
                res = 0;
                double screenrate = KDPrinterUtils.getScreenMapRate(KDPrinterUtils.SCREEN_RESOLUTION);
                g2d.scale(1.0 / screenrate, 1.0 / screenrate);
                CtrlPageFormat format = (CtrlPageFormat)pageFormat;
                AbstractStartLocationModel startLocationModel = this.printer.getPrintConfig().getStartLocationModel();
                String printerName = this.printer.getPrintConfig().getPrintService().getName();
                float[] pageStartLoaction = startLocationModel.getStartValues(printerName);
                float pageAdjustX = pageStartLoaction[0];
                float pageAdjustY = pageStartLoaction[1];
                boolean adjust = false;
                if (!ArrayUtil.isEqual((Float)Float.valueOf(pageAdjustX), (Float)Float.valueOf(0.0f)) || !ArrayUtil.isEqual((Float)Float.valueOf(pageAdjustY), (Float)Float.valueOf(0.0f))) {
                    adjust = true;
                    pageAdjustX = pageAdjustX / 25.43f * (float)KDPrinterUtils.PTSPERINCH;
                    pageAdjustY = pageAdjustY / 25.43f * (float)KDPrinterUtils.PTSPERINCH;
                }
                if (adjust) {
                    g2d.translate(pageAdjustX, pageAdjustY);
                }
                format.getPainterInfo().setPreviewing(false);
                KDPrinterUtils.printOutCanvas(this.nowPaper, "PrintPaper");
                this.nowPaper.painting(g2d, ((CtrlPageFormat)pageFormat).getPainterInfo());
                if (adjust) {
                    g2d.translate(-pageAdjustX, -pageAdjustY);
                }
                ((Graphics2D)g).scale(screenrate, screenrate);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
        }
        if (this.controlPrint.isCancel()) {
            res = 1;
        }
        this.printer.getControlPrint().updatePrintingPrompt(res, pageIndex);
        return res;
    }

    protected void paintWatermark(Graphics p, PainterInfo info) {
    }

    public Canvas getPaper(int pageIndex) {
        int scaleType = this.printer.getPrintConfig().getModel().getScaleType();
        if (scaleType == 1) {
            return this.controlPrint.getPaper(pageIndex);
        }
        MultiPaper mPaper = new MultiPaper(scaleType, pageIndex, this.controlPrint);
        if (!mPaper.isEmpty()) {
            return mPaper;
        }
        return null;
    }

    public ControlPrint getControlPrint() {
        return this.controlPrint;
    }
}

