/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.extend;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.print.IPrintActionListener;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import java.awt.Component;

public abstract class AbstractSimplePrinter
implements IPrintActionListener {
    protected KDPrinter printer;
    protected IPrintJob printjob;
    protected Component parent;
    protected Object[] printData;

    public void setParent(Component parent) {
        this.parent = parent;
    }

    protected void resetKDPrinter() {
        if (this.printer == null) {
            this.printer = new KDPrinter();
        }
        this.printer.clear();
        this.printer.addPrintActionListener(this);
        if (this.parent != null) {
            this.printer.setParentWindow(this.parent);
        }
        this.printer.getPrintPreview().setWindowType(0);
    }

    public abstract IPrintJob newPrintJob();

    public IPrintJob createPrintJobs() {
        this.resetKDPrinter();
        if (this.printjob == null) {
            this.printjob = this.newPrintJob();
            this.printjob.setPrinter(this.printer);
        }
        this.printjob.clear();
        this.printer.addPrintJob(this.printjob);
        return this.printjob;
    }

    public KDPrinter getPrinter() {
        if (this.printer == null) {
            this.resetKDPrinter();
        }
        if (this.parent != null) {
            this.printer.setParentWindow(this.parent);
        }
        return this.printer;
    }

    public boolean pageDialog() {
        IPrintJob job = this.createPrintJobs();
        int status = job.pageDialog(this.parent, false);
        if (status == 3) {
            this.printPreview();
            return false;
        }
        return status == 1;
    }

    public int print() {
        return this.getPrinter().print2();
    }

    public void printDirect() {
        this.getPrinter().printDirect();
    }

    public void printPreview() {
        this.getPrinter().printPreview();
    }

    public void printPreview(Component parent) {
        this.parent = parent;
        this.printPreview();
    }

    @Override
    public void beforePrintOrPreview() {
        this.createPrintJobs();
    }

    @Override
    public void beforePreview() {
    }

    @Override
    public void closePreview() {
    }

    public IXmlElement toXmlElement() {
        IXmlElement e = this.getPrinter().getPrintConfig().toXmlElement();
        return e;
    }

    public void fromXmlElement(IXmlElement e) {
        this.createPrintJobs();
        this.getPrinter().getPrintConfig().fromXmlElement(e);
    }

    public void setPrintData(Object[] printData) {
        this.printData = printData;
    }

    public Object[] getPrintData() {
        return this.printData;
    }

    public boolean isEmpty() {
        return this.printData == null || this.printData.length == 0;
    }
}

