/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.io;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.print.io.AbstractExport;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import com.kingdee.cosmic.ctrl.print.ui.component.Paper;
import com.kingdee.cosmic.ctrl.print.ui.component.StyleCell;
import com.kingdee.cosmic.ctrl.print.ui.component.TableCell;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class XlsExport
extends AbstractExport {
    private HSSFWorkbook workbook = null;
    private HSSFCellStyle emptyCellStyle = null;
    private List loadedFonts;
    private HashMap loadedCellStyles;

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        String des;
        Page page = paper.getBody();
        List list = page.getAllPainter();
        int row = 0;
        int col = 0;
        this.workbook = new HSSFWorkbook();
        this.loadedFonts = new ArrayList();
        this.loadedCellStyles = new HashMap();
        this.createEmptyCellStyle();
        HSSFSheet sheet = this.workbook.createSheet();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            IPainter painter = (IPainter)list.get(i);
            if (!(painter instanceof TableCell)) continue;
            this.exportTableCell(sheet, (TableCell)painter, row, col);
            break;
        }
        if (!(des = fileNamePre + index).endsWith(".xls")) {
            des = des + ".xls";
        }
        File destFile = new File(FilenameUtils.normalize((String)des));
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(destFile);
                this.workbook.write((OutputStream)os);
                os.flush();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(destFile + " FileNotFoundException error:" + e.getMessage(), e);
            }
            catch (IOException e1) {
                throw new RuntimeException("IOException error:" + e1.getMessage(), e1);
            }
            finally {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException error:" + e.getMessage(), e);
        }
    }

    private void exportTableCell(HSSFSheet sheet, TableCell table, int row, int col) {
        for (int i = 0; i < table.getcolumnCount(); ++i) {
            sheet.setColumnWidth((int)((short)(col + i)), (int)((short)((double)table.getColumnWidth(i) * 25.4 / 96.0 * 140.0)));
        }
        int rowCount = table.getRowCount();
        for (int iRow = 0; iRow < rowCount; ++iRow) {
            HSSFRow xlsRow = sheet.createRow(row + iRow);
            float tempHeight = (short)StyleUtil.lomToPt((double)(table.getRowHeight(iRow) * 10.0f));
            xlsRow.setHeight((short)((double)tempHeight * 25.4 / 96.0 * 20.0));
            for (int iCol = 0; iCol < table.getcolumnCount(); ++iCol) {
                HSSFCell cell = xlsRow.createCell((int)((short)(iCol + col)));
                StyleCell painter = table.getCell(iRow, iCol);
                if (painter != null) {
                    cell.setCellValue((RichTextString)new HSSFRichTextString(painter.getText()));
                    HSSFCellStyle cellStyle = this.getLoadedCellStyle(painter);
                    cell.setCellStyle(cellStyle);
                } else {
                    cell.setCellStyle(this.emptyCellStyle);
                }
                TableCell.MergeBlock mergeBlock = table.getMerge(iRow, iCol);
                if (mergeBlock == null) continue;
                int rowFrom = row + iRow;
                short colFrom = (short)(iCol + col);
                int rowTo = mergeBlock.getRow2() + row;
                short colTo = (short)(mergeBlock.getCol2() + row);
                sheet.addMergedRegion(new CellRangeAddress(rowFrom, (int)colFrom, rowTo, (int)colTo));
            }
        }
    }

    private HSSFCellStyle getLoadedCellStyle(StyleCell cell) {
        HSSFCellStyle cellStyle = null;
        Style ssa = cell.getStyle();
        if (ssa.isEmpty()) {
            return this.emptyCellStyle;
        }
        if (this.loadedCellStyles != null && this.loadedCellStyles.size() > 0 && this.loadedCellStyles.containsKey(cell.getStyle())) {
            cellStyle = (HSSFCellStyle)this.loadedCellStyles.get(cell.getStyle());
        }
        if (cellStyle == null) {
            cellStyle = this.workbook.createCellStyle();
            Style stl = cell.getStyle();
            HSSFFont f = this.getLoadedFont((ShareStyleAttributes)stl);
            cellStyle.setFont(f);
            FillPatternType pattern = this.getHssfPattern((ShareStyleAttributes)stl);
            if (pattern == FillPatternType.NO_FILL) {
                cellStyle.setFillPattern(pattern);
            } else if (pattern == FillPatternType.SOLID_FOREGROUND) {
                short color;
                Color clr = stl.getBackground();
                if (Color.WHITE.equals(clr)) {
                    cellStyle.setFillPattern(FillPatternType.NO_FILL);
                } else {
                    color = XlsExport.getNearestColor(stl.getBackground()).getIndex();
                    cellStyle.setFillForegroundColor(color);
                    cellStyle.setFillPattern(pattern);
                }
                color = XlsExport.getNearestColor(stl.getFontColor()).getIndex();
                cellStyle.setFillBackgroundColor(color);
            } else {
                cellStyle.setFillBackgroundColor(XlsExport.getNearestColor(stl.getBackground()).getIndex());
                cellStyle.setFillForegroundColor(XlsExport.getNearestColor(stl.getFontColor()).getIndex());
                cellStyle.setFillPattern(pattern);
            }
            Styles.Position p = Styles.Position.LEFT;
            if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p))) {
                cellStyle.setBorderLeft(this.getHssfBorder((ShareStyleAttributes)stl, p));
                cellStyle.setLeftBorderColor(XlsExport.getNearestColor(stl.getBorderColor(p)).getIndex());
            }
            if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.RIGHT))) {
                cellStyle.setBorderRight(this.getHssfBorder((ShareStyleAttributes)stl, p));
                cellStyle.setRightBorderColor(XlsExport.getNearestColor(stl.getBorderColor(p)).getIndex());
            }
            if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.TOP))) {
                cellStyle.setBorderTop(this.getHssfBorder((ShareStyleAttributes)stl, p));
                cellStyle.setTopBorderColor(XlsExport.getNearestColor(stl.getBorderColor(p)).getIndex());
            }
            if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.BOTTOM))) {
                cellStyle.setBorderBottom(this.getHssfBorder((ShareStyleAttributes)stl, p));
                cellStyle.setBottomBorderColor(XlsExport.getNearestColor(stl.getBorderColor(p)).getIndex());
            }
            cellStyle.setAlignment((HorizontalAlignment)this.getHssfAlignment(true, (ShareStyleAttributes)stl));
            cellStyle.setVerticalAlignment((VerticalAlignment)this.getHssfAlignment(false, (ShareStyleAttributes)stl));
            cellStyle.setWrapText(stl.isWrapText());
            cellStyle.setRotation((short)stl.getRotation());
            cellStyle.setHidden(stl.isHided());
            this.loadedCellStyles.put(stl, cellStyle);
        }
        return cellStyle;
    }

    private void createEmptyCellStyle() {
        if (this.emptyCellStyle == null) {
            this.emptyCellStyle = this.workbook.createCellStyle();
            this.emptyCellStyle.setFillPattern(FillPatternType.NO_FILL);
            this.emptyCellStyle.setFillForegroundColor((short)0);
            this.emptyCellStyle.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
            this.emptyCellStyle.setAlignment(HorizontalAlignment.CENTER);
            this.emptyCellStyle.setHidden(false);
            this.emptyCellStyle.setLocked(false);
            this.emptyCellStyle.setBorderLeft(BorderStyle.NONE);
            this.emptyCellStyle.setBorderRight(BorderStyle.NONE);
            this.emptyCellStyle.setBorderTop(BorderStyle.NONE);
            this.emptyCellStyle.setBorderBottom(BorderStyle.NONE);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.emptyCellStyle.setBottomBorderColor(backColorIndex);
            this.emptyCellStyle.setTopBorderColor(backColorIndex);
            this.emptyCellStyle.setLeftBorderColor(backColorIndex);
            this.emptyCellStyle.setRightBorderColor(backColorIndex);
            this.emptyCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = this.workbook.createFont();
            defaultFont.setFontName(CtrlPrintMessages.getMLS("io.XlsExport.\u5fae\u8f6f\u96c5\u9ed1", ""));
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.emptyCellStyle.setFont(defaultFont);
        }
    }

    private HSSFFont getLoadedFont(ShareStyleAttributes ssa) {
        HSSFFont cellFont = null;
        short forecolor = XlsExport.getNearestColor(ssa.getFontColor()).getIndex();
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            HSSFFont cf = null;
            for (int i = 0; i < this.loadedFonts.size(); ++i) {
                cf = (HSSFFont)this.loadedFonts.get(i);
                if (!cf.getFontName().equals(ssa.getFontName()) || cf.getColor() != forecolor || cf.getFontHeight() != (short)(ssa.getFontSize() * 20) || !(cf.getUnderline() == 1 ? ssa.isUnderline() : !ssa.isUnderline()) || cf.getStrikeout() != ssa.isStrikeThrough() || !(cf.getBold() ? ssa.isBold() : !ssa.isBold()) || cf.getItalic() != ssa.isItalic()) continue;
                cellFont = cf;
                break;
            }
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(ssa.getFontName());
            cellFont.setColor(forecolor);
            cellFont.setFontHeightInPoints((short)ssa.getFontSize());
            if (ssa.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (ssa.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (ssa.isBold()) {
                cellFont.setBold(true);
            }
            if (ssa.isItalic()) {
                cellFont.setItalic(true);
            }
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    private static HSSFColor getNearestColor(Color awtColor) {
        HSSFColor color = null;
        Map triplets = HSSFColor.getTripletHash();
        Set entrySet = triplets.entrySet();
        if (entrySet.size() > 0) {
            Object var4_4 = null;
            HSSFColor crtColor = null;
            short[] rgb = null;
            int diff = 0;
            int minDiff = 999;
            for (Map.Entry entry : entrySet) {
                crtColor = (HSSFColor)entry.getValue();
                rgb = crtColor.getTriplet();
                diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                if (diff >= minDiff) continue;
                minDiff = diff;
                color = crtColor;
            }
        }
        if (color == null) {
            throw new RuntimeException(CtrlPrintMessages.getMLS("failedToGetHSSFColor", "HSSFColor \u83b7\u53d6\u5931\u8d25"));
        }
        return color;
    }

    FillPatternType getHssfPattern(ShareStyleAttributes ssa) {
        FillPatternType sret = FillPatternType.NO_FILL;
        switch (ssa.getPattern().getID()) {
            case 0: {
                sret = FillPatternType.NO_FILL;
                break;
            }
            case 1: {
                sret = FillPatternType.SOLID_FOREGROUND;
                break;
            }
            case 3: {
                sret = FillPatternType.FINE_DOTS;
                break;
            }
            case 26: {
                sret = FillPatternType.ALT_BARS;
                break;
            }
            case 19: {
                sret = FillPatternType.SPARSE_DOTS;
                break;
            }
            case 45: {
                sret = FillPatternType.THICK_HORZ_BANDS;
                break;
            }
            case 37: {
                sret = FillPatternType.THICK_VERT_BANDS;
                break;
            }
            case 20: {
                sret = FillPatternType.THICK_BACKWARD_DIAG;
                break;
            }
            case 28: {
                sret = FillPatternType.THICK_FORWARD_DIAG;
                break;
            }
            case 25: {
                sret = FillPatternType.BIG_SPOTS;
                break;
            }
            case 40: {
                sret = FillPatternType.BRICKS;
                break;
            }
            case 13: {
                sret = FillPatternType.THIN_HORZ_BANDS;
                break;
            }
            case 5: {
                sret = FillPatternType.THIN_VERT_BANDS;
                break;
            }
            case 4: {
                sret = FillPatternType.THIN_BACKWARD_DIAG;
                break;
            }
            case 12: {
                sret = FillPatternType.THIN_FORWARD_DIAG;
                break;
            }
            case 9: {
                sret = FillPatternType.SQUARES;
                break;
            }
            case 34: {
                sret = FillPatternType.DIAMONDS;
                break;
            }
            default: {
                sret = FillPatternType.SOLID_FOREGROUND;
            }
        }
        return sret;
    }

    Object getHssfAlignment(boolean bhorize, ShareStyleAttributes ssa) {
        if (bhorize) {
            Styles.HorizontalAlignment align = ssa.getHorizontalAlign();
            HorizontalAlignment horizontalAlignment = align == Styles.HorizontalAlignment.LEFT ? HorizontalAlignment.LEFT : (align == Styles.HorizontalAlignment.CENTER ? HorizontalAlignment.CENTER : (align == Styles.HorizontalAlignment.RIGHT ? HorizontalAlignment.RIGHT : HorizontalAlignment.JUSTIFY));
            return horizontalAlignment;
        }
        Styles.VerticalAlignment align = ssa.getVerticalAlign();
        VerticalAlignment verticalAlignment = align == Styles.VerticalAlignment.TOP ? VerticalAlignment.TOP : (align == Styles.VerticalAlignment.MIDDLE ? VerticalAlignment.CENTER : (align == Styles.VerticalAlignment.BOTTOM ? VerticalAlignment.BOTTOM : VerticalAlignment.TOP));
        return verticalAlignment;
    }

    BorderStyle getHssfBorder(ShareStyleAttributes ssa, Styles.Position pos) {
        PenStyle ps = ssa.getBorderPenStyle(pos);
        int width = ssa.getBorderLineStyle(pos).getWidth();
        switch (width) {
            case 0: {
                return BorderStyle.NONE;
            }
            case 1: {
                if (ps == PenStyle.PS_SOLID) {
                    return BorderStyle.THIN;
                }
                if (ps == PenStyle.PS_CONTINUOUS) {
                    return BorderStyle.DOTTED;
                }
                if (ps == PenStyle.PS_DOT) {
                    return BorderStyle.DASHED;
                }
                if (ps == PenStyle.PS_DASHDOTDOT) {
                    return BorderStyle.DASH_DOT;
                }
                if (ps == PenStyle.PS_DASHDOT) {
                    return BorderStyle.DASH_DOT_DOT;
                }
                return BorderStyle.THIN;
            }
        }
        if (ps == PenStyle.PS_SOLID || ps == PenStyle.PS_CONTINUOUS) {
            if (width == 2) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THICK;
        }
        if (ps == PenStyle.PS_DOT) {
            return BorderStyle.MEDIUM_DASHED;
        }
        if (ps == PenStyle.PS_DASHDOTDOT) {
            return BorderStyle.MEDIUM_DASH_DOT;
        }
        if (ps == PenStyle.PS_DASHDOT) {
            return BorderStyle.MEDIUM_DASH_DOT_DOT;
        }
        if (width == 2) {
            return BorderStyle.MEDIUM;
        }
        return BorderStyle.THICK;
    }
}

