/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.preview;

import com.kingdee.cosmic.ctrl.print.preview.OnePaperUI;
import com.kingdee.cosmic.ctrl.print.preview.PreviewBody;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.geom.Dimension2D;

public class MultiViewLayout
implements LayoutManager {
    private int topBottomMargin = 10;
    private int leftRightMargin = 10;
    private int paperSpace = 5;
    PreviewBody previewUI;

    public MultiViewLayout(PreviewBody comp) {
        this.previewUI = comp;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        int totalHeight;
        int startY;
        Insets insets = parent.getInsets();
        Dimension pDim = parent.getSize();
        int w = pDim.width - insets.left - insets.right;
        int h = pDim.height - insets.top - insets.bottom;
        int width = w - this.leftRightMargin * 2;
        int height = h - this.topBottomMargin * 2;
        int pWidth = 0;
        int pHeight = 0;
        if (this.previewUI.pagerUIList != null && this.previewUI.pagerUIList.size() > 0) {
            OnePaperUI ui = (OnePaperUI)((Object)this.previewUI.pagerUIList.get(0));
            if (ui != null && ui.getPaper() != null) {
                Dimension2D d = ui.getPaper().getPainterSize();
                pWidth = (int)d.getWidth();
                pHeight = (int)d.getHeight();
            }
        } else {
            return;
        }
        if (pWidth == 0 || pHeight == 0) {
            return;
        }
        int colCount = this.previewUI.multiViewRowCol[1];
        float scaleWidth = (float)(width - this.paperSpace * (colCount - 1)) / (float)colCount / (float)pWidth;
        int rowCount = this.previewUI.multiViewRowCol[0];
        float scaleHeight = (float)(height - this.paperSpace * (rowCount - 1)) / (float)rowCount / (float)pHeight;
        float scale = scaleWidth < scaleHeight ? scaleWidth : scaleHeight;
        this.previewUI.preview.getPreviewBar().setScaleText("" + Math.round(scale * 100.0f) + "%");
        int sWidth = (int)((float)pWidth * scale);
        int sHeight = (int)((float)pHeight * scale);
        int totalWidth = sWidth * colCount + this.paperSpace * (colCount - 1);
        int startX = (width - totalWidth) / 2 + this.paperSpace;
        if (startX < this.paperSpace) {
            startX = this.paperSpace;
        }
        if ((startY = (height - (totalHeight = sHeight * rowCount + this.paperSpace * (rowCount - 1))) / 2 + this.paperSpace) < this.paperSpace) {
            startY = this.paperSpace;
        }
        int m = 0;
        int size = this.previewUI.pagerUIList.size();
        int x = startX;
        int y = startY;
        for (int i = 0; i < rowCount; ++i) {
            x = startX;
            for (int j = 0; j < colCount && m <= size - 1; ++m, ++j) {
                OnePaperUI ui = (OnePaperUI)((Object)this.previewUI.pagerUIList.get(m));
                ui.setVisible(true);
                ui.setScale(scale);
                ui.setBounds(x, y, sWidth, sHeight);
                ui.setPreferredSize(new Dimension(sWidth, sHeight));
                x = x + sWidth + this.paperSpace;
            }
            y = y + sHeight + this.paperSpace;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(400, 300);
    }
}

