/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.preview;

import com.kingdee.cosmic.ctrl.print.resource.Resources;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class SelectMultiPageDialog
extends KDDialog
implements MouseMotionListener,
MouseListener,
FocusListener {
    private static final long serialVersionUID = 3432131793842451005L;
    Color back = new Color(181, 219, 255);
    Color border = new Color(115, 158, 198);
    ImageIcon icon1 = (ImageIcon)Resources.getIcon("action.multipage.icon1");
    ImageIcon icon2 = (ImageIcon)Resources.getIcon("action.multipage.icon2");
    KDLabel[] myPageIcons;
    Component curComp;
    KDPanel gridPane = new KDPanel();
    KDLabel status = new KDLabel();
    String statusSubfix;
    String statusCancel;
    boolean cancel = false;
    boolean bDrag = false;
    int rows;
    int cols;
    int selRows = 0;
    int selCols = 0;
    int iCurComp = -1;

    public SelectMultiPageDialog(Dialog parent, int cRows, int cCols, int cPages) {
        super(parent, true);
        this.init(cRows, cCols);
    }

    public SelectMultiPageDialog(Frame parent, int cRows, int cCols, int cPages) {
        super(parent, true);
        this.init(cRows, cCols);
    }

    private void init(int cRows, int cCols) {
        this.rows = cRows;
        this.cols = cCols;
        this.gridPane.setLayout((LayoutManager)new GridLayout(cRows, cCols, 0, 0));
        this.getContentPane().add((Component)this.gridPane, "North");
        this.myPageIcons = new KDLabel[cRows * cCols];
        for (int i = 0; i < cRows * cCols; ++i) {
            this.myPageIcons[i] = new KDLabel((Icon)this.icon1);
            this.gridPane.add((Component)this.myPageIcons[i]);
            this.myPageIcons[i].addMouseMotionListener((MouseMotionListener)this);
            this.myPageIcons[i].addMouseListener((MouseListener)this);
        }
        this.addFocusListener(this);
        this.statusSubfix = Resources.getMsg("label.strpage");
        this.statusCancel = Resources.getMsg("button.cancel");
        this.status.setHorizontalAlignment(0);
        this.status.setText(this.statusCancel);
        this.getContentPane().add((Component)this.status, "South");
        this.getContentPane().setBackground(this.back);
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createLineBorder(this.border));
        this.status.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SelectMultiPageDialog.this.status.setText(SelectMultiPageDialog.this.statusCancel);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                SelectMultiPageDialog.this.closeThis(false);
            }
        });
    }

    protected KDPanel createStatusBar() {
        KDPanel statusPane = new KDPanel();
        statusPane.setLayout((LayoutManager)new BorderLayout());
        return statusPane;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Component comp = (Component)e.getSource();
        if (comp != this.curComp) {
            for (int i = 0; i < this.myPageIcons.length; ++i) {
                if (comp != this.myPageIcons[i]) continue;
                this.setSelectedEffect(this.iCurComp, i);
                this.curComp = comp;
                this.iCurComp = i;
                this.selRows = i / this.cols;
                this.selCols = i % this.cols;
                this.status.setText(this.selRows + 1 + " x " + (this.selCols + 1) + this.statusSubfix);
            }
        }
    }

    private void setSelectedEffect(int iPrev, int index) {
        int j;
        int i;
        boolean[][] isSwap = new boolean[this.rows][this.cols];
        for (int i2 = 0; i2 < this.rows; ++i2) {
            for (int j2 = 0; j2 < this.cols; ++j2) {
                isSwap[i2][j2] = false;
            }
        }
        int theRows = index / this.cols;
        int theCols = index % this.cols;
        int prevRows = iPrev / this.cols;
        int prevCols = iPrev % this.cols;
        for (i = 0; i <= theRows; ++i) {
            for (j = 0; j <= theCols; ++j) {
                isSwap[i][j] = !isSwap[i][j];
            }
        }
        if (iPrev != -1) {
            for (i = 0; i <= prevRows; ++i) {
                for (j = 0; j <= prevCols; ++j) {
                    isSwap[i][j] = !isSwap[i][j];
                }
            }
        }
        int idxComp = 0;
        for (int i3 = 0; i3 < this.rows; ++i3) {
            for (int j3 = 0; j3 < this.cols; ++j3) {
                if (isSwap[i3][j3]) {
                    if (this.myPageIcons[idxComp].getIcon() == this.icon1) {
                        this.myPageIcons[idxComp].setIcon((Icon)this.icon2);
                    } else if (this.myPageIcons[idxComp].getIcon() == this.icon2) {
                        this.myPageIcons[idxComp].setIcon((Icon)this.icon1);
                    } else {
                        this.myPageIcons[idxComp].setIcon((Icon)this.icon1);
                    }
                }
                ++idxComp;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.closeThis(true);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
        this.bDrag = true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.bDrag) {
            // empty if block
        }
        this.bDrag = false;
    }

    public int getSelCols() {
        return this.selCols;
    }

    public int getSelRows() {
        return this.selRows;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean b) {
        this.cancel = b;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.closeThis(false);
    }

    private void closeThis(boolean ok) {
        this.setCancel(!ok);
        this.dispose();
    }

    public int[] getResult() {
        if (!this.isCancel()) {
            int r = this.getSelRows() + 1;
            int c = this.getSelCols() + 1;
            int[] rowcol = new int[]{r, c};
            return rowcol;
        }
        return null;
    }
}

