/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.ui.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.ObjectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TableSplitRectInfoXml;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.config.IXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.IXmlTranslate2;
import com.kingdee.cosmic.ctrl.print.ui.component.BasicPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.Canvas;
import com.kingdee.cosmic.ctrl.print.ui.component.IDecorate;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.ImageCell;
import com.kingdee.cosmic.ctrl.print.ui.component.LabelCell;
import com.kingdee.cosmic.ctrl.print.ui.component.LineBorder;
import com.kingdee.cosmic.ctrl.print.ui.component.LineCell;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import com.kingdee.cosmic.ctrl.print.ui.component.Paper;
import com.kingdee.cosmic.ctrl.print.ui.component.StyleCell;
import com.kingdee.cosmic.ctrl.print.ui.component.TableCell;
import com.kingdee.cosmic.ctrl.print.ui.component.VariantLabelCell;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class Xml2Painter {
    private Map styles;

    public Xml2Painter(Map styles) {
        this.styles = styles;
    }

    public IPainter parsePainter(IXmlElement xml) {
        String tag = xml.getName();
        if ("Label".equals(tag)) {
            return this.parseLabel(xml);
        }
        if ("StyleCell".equals(tag)) {
            return this.parseStyleCell(xml);
        }
        if ("ImageCell".equals(tag)) {
            return this.parseImage(xml);
        }
        if ("Line".equals(tag)) {
            return this.parseLine(xml);
        }
        if ("page".equals(tag)) {
            return this.parsePage(xml);
        }
        if ("Canvas".equals(tag)) {
            return this.parseCanvas(xml);
        }
        if ("Paper".equals(tag)) {
            return this.parsePaper(xml);
        }
        if ("VariantLabel".equals(tag)) {
            return this.parseVariantLabel(xml);
        }
        if ("Table".equals(tag)) {
            return this.parseTable(xml);
        }
        IPainter painter = null;
        IXmlTranslate xmlTrans = KDPrinter.getPainterXmlTranslate(xml.getName());
        if (xmlTrans instanceof IXmlTranslate2) {
            ((IXmlTranslate2)xmlTrans).setXml2Painter(this);
            painter = (IPainter)xmlTrans.fromXmlElement(xml);
        } else if (xmlTrans != null) {
            painter = (IPainter)xmlTrans.fromXmlElement(xml);
        } else {
            throw new UnsupportedOperationException("xml:[" + xml.getName() + "]:can't load.");
        }
        return painter;
    }

    private void parseChildren(Canvas cv, IXmlElement xml) {
        Iterator itr = xml.getChildren().iterator();
        while (itr.hasNext()) {
            IPainter pnt = this.parsePainter((IXmlElement)itr.next());
            if (pnt == null) continue;
            cv.addPainter(pnt);
        }
    }

    public void parseCommon(IPainter pnt, IXmlElement xml) {
        String layer;
        String extend;
        String decorate;
        if (xml.getAttribute("x") != null) {
            float x = Float.parseFloat(xml.getAttribute("x"));
            float y = Float.parseFloat(xml.getAttribute("y"));
            float width = Float.parseFloat(xml.getAttribute("width"));
            float height = Float.parseFloat(xml.getAttribute("height"));
            pnt.setPainterBounds(x, y, width, height);
            if (pnt instanceof BasicPainter) {
                String rotateAttrValue;
                BasicPainter bpnt = (BasicPainter)pnt;
                String zIndexAttrValue = xml.getAttribute("z-index");
                if (zIndexAttrValue != null && !zIndexAttrValue.isEmpty()) {
                    int zIndex = Integer.parseInt(zIndexAttrValue);
                    bpnt.setZIndex(zIndex);
                }
                if ((rotateAttrValue = xml.getAttribute("rotate")) != null && !rotateAttrValue.isEmpty()) {
                    int rotate = Integer.parseInt(rotateAttrValue);
                    bpnt.setRotate(rotate);
                }
            }
        }
        if (xml.getAttribute("background") != null) {
            String rgb = xml.getAttribute("background");
            pnt.setBackGround(KDPrinterUtils.hexToColor(rgb));
        }
        if (xml.getAttribute("style") != null) {
            String styleID = xml.getAttribute("style");
            Style style = this.getStyle(styleID);
            pnt.setStyle(style);
        }
        if ((decorate = xml.getAttribute("decorate")) != null) {
            IDecorate lineDecorate = this.parseLineDecorate(decorate);
            pnt.setDecorate(lineDecorate);
        }
        if ((extend = xml.getAttribute("extend")) != null) {
            pnt.setPainterExtend(Float.parseFloat(extend));
        }
        if ((layer = xml.getAttribute("layer")) != null) {
            pnt.setLayer(Integer.parseInt(layer));
        }
    }

    private IDecorate parseLineDecorate(String decorate) {
        LineBorder de = null;
        int index = decorate.indexOf(58);
        String name = null;
        String type = null;
        if (index >= 0) {
            name = decorate.substring(0, index);
            type = decorate.substring(index + 1);
        }
        if (LineBorder.getName().equals(name)) {
            de = new LineBorder();
            de.setType(Integer.parseInt(type));
        }
        return de;
    }

    public Object getObject(String Id) {
        return this.styles != null ? this.styles.get(Id) : null;
    }

    private Style getStyle(String styleID) {
        return this.styles != null ? (Style)this.styles.get(styleID) : null;
    }

    public StyleCell parseStyleCell(IXmlElement xml) {
        StyleCell lbl = new StyleCell();
        this.parseCommon(lbl, xml);
        lbl.setText(xml.getText());
        for (int i = 0; i < StyleCell.StylesDir.length; ++i) {
            String id = xml.getAttribute("aroundstyle" + i);
            if (id == null) continue;
            Style style = this.getStyle(id);
            lbl.setAroundStyles(StyleCell.StylesDir[i], style);
        }
        String isBlackWhite = xml.getAttribute("isBlackWhite");
        lbl.setBlackWhite(Boolean.parseBoolean(isBlackWhite));
        int borderSpace = StyleCell.BORDER_SPACE_DEFUALT;
        if (xml.getAttribute("borderspace") != null) {
            borderSpace = Integer.parseInt(xml.getAttribute("borderspace"));
            lbl.setBorderSpace(borderSpace);
        }
        int borderMode = Integer.parseInt(xml.getAttribute("bordermode"));
        lbl.setBorderMode(borderMode);
        IXmlElement diagonal = xml.getChild("DiagonalHeader");
        if (diagonal != null) {
            AbstractTableSplitRectInfo info = TableSplitRectInfoXml.fromXml((IXmlElement)diagonal, (Map)this.styles);
            lbl.setDiagonalInfo(info);
        }
        return lbl;
    }

    public LabelCell parseLabel(IXmlElement xml) {
        LabelCell lbl = new LabelCell();
        this.parseCommon(lbl, xml);
        String isBlackWhite = xml.getAttribute("isBlackWhite");
        if (isBlackWhite != null) {
            lbl.setBlackWhite(Boolean.parseBoolean(isBlackWhite));
        }
        lbl.setText(xml.getText());
        return lbl;
    }

    public LabelCell parseVariantLabel(IXmlElement xml) {
        VariantLabelCell lbl = new VariantLabelCell();
        this.parseCommon(lbl, xml);
        lbl.setText(xml.getText());
        return lbl;
    }

    public LineCell parseLine(IXmlElement xml) {
        LineCell ln = new LineCell();
        this.parseCommon(ln, xml);
        if (xml.getAttribute("color") != null) {
            String rgb = xml.getAttribute("color");
            ln.setColor(KDPrinterUtils.hexToColor(rgb));
        }
        if (xml.getAttribute("x1") != null) {
            String x1 = xml.getAttribute("x1");
            String y1 = xml.getAttribute("y1");
            String x2 = xml.getAttribute("x2");
            String y2 = xml.getAttribute("y2");
            ln.setLine(Float.parseFloat(x1), Float.parseFloat(y1), Float.parseFloat(x2), Float.parseFloat(y2));
        }
        return ln;
    }

    public ImageCell parseImage(IXmlElement xml) {
        ImageCell img = new ImageCell();
        this.parseCommon(img, xml);
        String text = xml.getText();
        if (!StringUtil.isEmptyString((String)text) && text.startsWith("OTHER|")) {
            String fileType = text.substring(6, text.indexOf(124, 6));
            byte[] content = (byte[])ObjectUtil.stringToObject((String)text.substring(6 + fileType.length() + 1));
            if (content != null) {
                img.setContent(content);
            }
            img.setFileType(fileType);
        } else {
            ImageIcon image = (ImageIcon)ObjectUtil.stringToObject((String)text);
            if (image != null) {
                img.setImage(image.getImage());
            }
            img.setFileType("IMAGE");
        }
        String scale = xml.getAttribute("scale");
        if (scale != null && !"".equals(scale)) {
            img.setScale(Integer.parseInt(scale));
        }
        return img;
    }

    public Canvas parseCanvas(IXmlElement xml) {
        Canvas pg = new Canvas();
        this.parseCommon(pg, xml);
        this.parseChildren(pg, xml);
        return pg;
    }

    public Page parsePage(IXmlElement xml) {
        Page pg = new Page();
        this.parseCommon(pg, xml);
        this.parseChildren(pg, xml);
        return pg;
    }

    private IPainter parseTable(IXmlElement xml) {
        String rows = xml.getAttribute("rows");
        String columns = xml.getAttribute("columns");
        float[] rowsHeight = StringUtil.str2FloatArray((String)rows, (String)",");
        float[] columnsHeight = StringUtil.str2FloatArray((String)columns, (String)",");
        TableCell table = new TableCell(rowsHeight.length, columnsHeight.length);
        this.parseCommon(table, xml);
        table.setRows(rowsHeight);
        table.setColumns(columnsHeight);
        String grid = xml.getAttribute("grid");
        table.setGrid("true".equals(grid));
        List cellChildren = xml.searchChildren("cell");
        int size = cellChildren.size();
        block0: for (int i = 0; i < size; ++i) {
            IXmlElement cell = (IXmlElement)cellChildren.get(i);
            int rowIndex = Integer.parseInt(cell.getAttribute("row"));
            int colIndex = Integer.parseInt(cell.getAttribute("column"));
            List content = cell.getChildren();
            int length = content.size();
            for (int j = 0; j < length; ++j) {
                Object pXml = content.get(j);
                if (!(pXml instanceof IXmlElement)) continue;
                IPainter painter = this.parsePainter((IXmlElement)pXml);
                table.setValue(rowIndex, colIndex, (StyleCell)painter);
                continue block0;
            }
        }
        List mergChildren = xml.searchChildren("mergeblock");
        int size2 = mergChildren.size();
        for (int i = 0; i < size2; ++i) {
            IXmlElement block = (IXmlElement)mergChildren.get(i);
            int row = Integer.parseInt(block.getAttribute("row"));
            int col = Integer.parseInt(block.getAttribute("col"));
            int row2 = Integer.parseInt(block.getAttribute("row2"));
            int col2 = Integer.parseInt(block.getAttribute("col2"));
            table.addMerge(row, col, row2, col2);
        }
        return table;
    }

    public Paper parsePaper(IXmlElement xml) {
        Paper pp = new Paper();
        this.parseCommon(pp, xml);
        this.parseChildren(pp, xml);
        return pp;
    }
}

