/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.util;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.swing.StringUtils;
import com.kingdee.eas.common.client.SysContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class KDPrintUtil {
    private static final Logger log = Logger.getLogger(KDPrintUtil.class);
    private static HashMap<String, String> directPrintConfigMap = new HashMap();
    private static final String property = System.getProperty("user.dir");
    private static final String directPrintConfigFilePath = property + "/cache/KDPrintConfig/{0}/{1}/KDPrintConfig.xml";
    private static final String directPrintConfigFileDir = property + "/cache/KDPrintConfig/{0}/{1}";
    private static final String ROOT_ELEMENT = "DirectPrint_Config";
    private static final String CONFIG_PRINTER_NAME = "printer_name";
    private static final String CONFIG_BILL_NAME = "bill_name";
    private static final String CONFIG_VALUE = "value";
    private static KDPrintUtil instance;

    public static synchronized KDPrintUtil getInstance() {
        if (instance == null) {
            KDPrintUtil.loadDirectPrintConfig();
            instance = new KDPrintUtil();
        }
        return instance;
    }

    public static boolean isPrintDirect(String templateType) {
        String printerName = directPrintConfigMap.get(templateType);
        return !StringUtils.isEmpty((String)printerName);
    }

    public static HashMap<String, String> getCachedConfig() {
        return directPrintConfigMap;
    }

    public static void loadDirectPrintConfig() {
        File printDirectConfigXML;
        if (directPrintConfigMap.size() > 0) {
            directPrintConfigMap.clear();
        }
        if (!(printDirectConfigXML = new File(FilenameUtils.normalize((String)MessageFormat.format(directPrintConfigFilePath, KDPrintUtil.getDcName(), KDPrintUtil.getUserId())))).exists()) {
            File configFileDir = new File(FilenameUtils.normalize((String)MessageFormat.format(directPrintConfigFileDir, KDPrintUtil.getDcName(), KDPrintUtil.getUserId())));
            if (!configFileDir.exists()) {
                configFileDir.mkdirs();
            }
            KDPrintUtil.createPrintConfigFile();
            return;
        }
        KDPrintUtil.generateXMLToMap();
    }

    private static void generateXMLToMap() {
        IXmlElement rootEle = KDPrintUtil.analyzFile2Element();
        if (null != rootEle) {
            try {
                List printerEleList = rootEle.searchChildren(CONFIG_PRINTER_NAME);
                if (printerEleList == null || printerEleList.isEmpty()) {
                    return;
                }
                for (IXmlElement printerEle : printerEleList) {
                    String printerName = printerEle.getAttribute(CONFIG_VALUE);
                    List billEleList = printerEle.getChildren();
                    if (billEleList == null || billEleList.isEmpty()) continue;
                    for (IXmlElement billEle : billEleList) {
                        String billName = billEle.getAttribute(CONFIG_VALUE);
                        directPrintConfigMap.put(billName, printerName);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"\u89e3\u6790\u76f4\u63a5\u6253\u5370\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    private static synchronized void createPrintConfigFile() {
        IXmlElement element = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)ROOT_ELEMENT);
        KDPrintUtil.saveToXml(element);
        log.info((Object)"\u521b\u5efa\u76f4\u63a5\u6253\u5370\u914d\u7f6e\u6587\u4ef6\u6210\u529f\uff01");
    }

    public static synchronized void addConfigToXml(String templateType, String printer) {
        if (!StringUtils.isEmpty((String)directPrintConfigMap.get(templateType))) {
            return;
        }
        IXmlElement rootEle = KDPrintUtil.analyzFile2Element();
        IXmlElement printerEle = null;
        try {
            printerEle = XmlUtil.selectSingleNode((IXmlElement)rootEle, (String)CONFIG_PRINTER_NAME, (String)CONFIG_VALUE, (String)printer);
        }
        catch (Exception e) {
            log.info((Object)("\u589e\u52a0\u76f4\u63a5\u6253\u5370\u914d\u7f6e\uff0c\u83b7\u53d6\u6253\u5370\u673a\u8282\u70b9\u5f02\u5e38\uff01\u6253\u5370\u673a\u540d\u79f0\uff1a" + printer), (Throwable)e);
        }
        if (null == printerEle && null != rootEle) {
            printerEle = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)CONFIG_PRINTER_NAME);
            printerEle.setAttribute(CONFIG_VALUE, printer);
            rootEle.addChild(printerEle);
        }
        if (null != printerEle) {
            IXmlElement billEle = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)CONFIG_BILL_NAME);
            billEle.setAttribute(CONFIG_VALUE, templateType);
            printerEle.addChild(billEle);
        }
        KDPrintUtil.saveToXml(rootEle);
        directPrintConfigMap.put(templateType, printer);
        log.info((Object)("\u589e\u52a0\u76f4\u63a5\u6253\u5370\u914d\u7f6e: \u5355\u636e\u7c7b\u578b:" + templateType + "\u6253\u5370\u673a\uff1a" + printer));
    }

    public static synchronized void deleteNotExistPrinter(String printer) {
        IXmlElement rootEle = KDPrintUtil.analyzFile2Element();
        IXmlElement printerEle = null;
        if (null != rootEle) {
            try {
                printerEle = XmlUtil.selectSingleNode((IXmlElement)rootEle, (String)CONFIG_PRINTER_NAME, (String)CONFIG_VALUE, (String)printer);
                if (printerEle == null) {
                    return;
                }
                rootEle.removeChild(printerEle);
                log.info((Object)("\u5220\u9664\u76f4\u63a5\u6253\u5370\u914d\u7f6e\uff1a\u6253\u5370\u673a\uff1a" + printer));
                KDPrintUtil.saveToXml(rootEle);
                for (Map.Entry<String, String> entry : directPrintConfigMap.entrySet()) {
                    if (!entry.getValue().equals(printer)) continue;
                    directPrintConfigMap.remove(entry.getKey());
                    log.info((Object)("\u5220\u9664\u76f4\u63a5\u6253\u5370\u914d\u7f6e\uff1a\u5355\u636e\u7c7b\u578b:" + entry.getKey() + "\u6253\u5370\u673a\uff1a" + printer));
                }
            }
            catch (Exception e) {
                log.error((Object)"\u5220\u9664\u76f4\u63a5\u6253\u5370\u6253\u5370\u673a\u8282\u70b9\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
    }

    private static void saveToXml(IXmlElement element) {
        try (FileOutputStream outputStream = new FileOutputStream(FilenameUtils.normalize((String)MessageFormat.format(directPrintConfigFilePath, KDPrintUtil.getDcName(), KDPrintUtil.getUserId())));){
            com.kingdee.bos.qing.common.xml.XmlUtil.save((IXmlElement)element, (OutputStream)outputStream);
        }
        catch (Exception e) {
            log.error((Object)"\u4fdd\u5b58\u76f4\u63a5\u6253\u5370\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    private static IXmlElement analyzFile2Element() {
        IXmlElement rootEle = null;
        String path = "";
        path = File.separatorChar == '\\' ? MessageFormat.format("file:\\" + directPrintConfigFilePath, KDPrintUtil.getDcName(), KDPrintUtil.getUserId()) : MessageFormat.format("file://" + directPrintConfigFilePath, KDPrintUtil.getDcName(), KDPrintUtil.getUserId());
        try {
            rootEle = com.kingdee.bos.qing.common.xml.XmlUtil.loadRootElementFromFile((File)new File(FilenameUtils.getName((String)path)));
        }
        catch (IOException e) {
            log.error((Object)"\u89e3\u6790\u76f4\u63a5\u6253\u5370\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (XmlParsingException e) {
            log.error((Object)"\u89e3\u6790\u76f4\u63a5\u6253\u5370\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        return rootEle;
    }

    public static String getPrinterName(String billName) {
        return directPrintConfigMap.get(billName);
    }

    private static String getDcName() {
        return SysContext.getSysContext().getDcName();
    }

    private static String getUserId() {
        return null;
    }

    public static boolean isShowExcelButton() {
        return false;
    }
}

