/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.util;

import com.kingdee.cosmic.ctrl.common.KDToolkit;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.print.IVariantParser;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import com.kingdee.cosmic.ctrl.print.config.attribute.FreeMediaSize;
import com.kingdee.cosmic.ctrl.print.config.attribute.HeadFootIntervalInfo;
import com.kingdee.cosmic.ctrl.print.config.attribute.MediaSizeNameExtend;
import com.kingdee.cosmic.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.cosmic.ctrl.print.config.attribute.PageRangeReverse;
import com.kingdee.cosmic.ctrl.print.config.attribute.ValidateAreaInfo;
import com.kingdee.cosmic.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.cosmic.ctrl.print.control.CtrlPageFormat;
import com.kingdee.cosmic.ctrl.print.preview.ButtonItem;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import com.kingdee.cosmic.ctrl.print.ui.component.Canvas;
import com.kingdee.cosmic.ctrl.print.ui.component.HeaderFooter;
import com.kingdee.cosmic.ctrl.print.ui.component.MultiPaper;
import com.kingdee.cosmic.ctrl.print.ui.component.PainterInfo;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import com.kingdee.cosmic.ctrl.swing.KDToggleButton;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class KDPrinterUtils {
    private static final Logger logger = LogUtil.getPackageLogger(KDPrinterUtils.class);
    public static int PTSPERINCH = 72;
    public static final int SCREEN_RESOLUTION = KDToolkit.getCurrentDpi();
    public static final int INCH = 25430;
    public static final float LOMETRIC_PER_INCH = 254.3f;
    public static final float MM_PER_INCH = 25.43f;
    public static float POINTMM10 = 254.3f / (float)SCREEN_RESOLUTION;
    public static final Insets ZEROINSET = new Insets(0, 0, 0, 0);
    public static final Rectangle ZERORECTANGLE = new Rectangle();
    private static final String[] myStringTable = new String[]{"iso-a0", "iso-a1", "iso-a2", "iso-a3", "iso-a4", "iso-a5", "iso-a6", "iso-a7", "iso-a8", "iso-a9", "iso-a10", "iso-b0", "iso-b1", "iso-b2", "iso-b3", "iso-b4", "iso-b5", "iso-b6", "iso-b7", "iso-b8", "iso-b9", "iso-b10", "jis-b0", "jis-b1", "jis-b2", "jis-b3", "jis-b4", "jis-b5", "jis-b6", "jis-b7", "jis-b8", "jis-b9", "jis-b10", "iso-c0", "iso-c1", "iso-c2", "iso-c3", "iso-c4", "iso-c5", "iso-c6", "na-letter", "na-legal", "executive", "ledger", "tabloid", "invoice", "folio", "quarto", "japanese-postcard", "oufuko-postcard", "a", "b", "c", "d", "e", "iso-designated-long", "italian-envelope", "monarch-envelope", "personal-envelope", "na-number-9-envelope", "na-number-10-envelope", "na-number-11-envelope", "na-number-12-envelope", "na-number-14-envelope", "na-6x9-envelope", "na-7x9-envelope", "na-9x11-envelope", "na-9x12-envelope", "na-10x13-envelope", "na-10x14-envelope", "na-10x15-envelope", "na-5x7", "na-8x10"};
    private static final MediaSizeName[] mediaSizeNameValueTable = new MediaSizeName[]{MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, MediaSizeName.JIS_B9, MediaSizeName.JIS_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.LEDGER, MediaSizeName.TABLOID, MediaSizeName.INVOICE, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.JAPANESE_DOUBLE_POSTCARD, MediaSizeName.A, MediaSizeName.B, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_5X7, MediaSizeName.NA_8X10};

    public static double lomToPrintPoint(double dfLom) {
        return dfLom / (double)254.3f * (double)SCREEN_RESOLUTION;
    }

    public static double printPointToLom(double prtPoint) {
        return Math.round(prtPoint * (double)254.3f / (double)SCREEN_RESOLUTION);
    }

    public static double getScreenMapRate(int unit) {
        return (double)unit / (double)PTSPERINCH;
    }

    public static int getPtsPerInch() {
        return PTSPERINCH;
    }

    public static Object doNullPaper() {
        return null;
    }

    public static float[] getDontPrintArea() {
        return null;
    }

    public static boolean isOddNum(int val) {
        return val % 2 != 0;
    }

    public static boolean isEvenNum(int val) {
        return val % 2 == 0;
    }

    public static String buildOddEvenNumberStr(int count, boolean isOdd) {
        return KDPrinterUtils.buildOddEvenNumberStr(count, isOdd, null);
    }

    public static String buildOddEvenNumberStr(int count, boolean isOdd, PageRanges ranges) {
        StringBuilder numStr = new StringBuilder();
        for (int i = 1; i <= count; ++i) {
            if (ranges != null && !ranges.contains(i)) continue;
            if (isOdd) {
                if (i % 2 == 0) continue;
                numStr.append(i).append(",");
                continue;
            }
            if (i % 2 != 0) continue;
            numStr.append(i).append(",");
        }
        String str = numStr.toString();
        if (str.length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static int buildReverseNumberStr(ArrayList printPage, int PageIndex) {
        int newArrayIndex = printPage.size() - 1 - printPage.indexOf(PageIndex);
        int newPageIndex = (Integer)printPage.get(newArrayIndex);
        return newPageIndex;
    }

    public static ArrayList getPrintPage(int count, PageRanges ranges) {
        ArrayList<Integer> printPage = new ArrayList<Integer>();
        for (int i = 1; i <= count; ++i) {
            if (ranges != null && !ranges.contains(i)) continue;
            printPage.add(i);
        }
        return printPage;
    }

    public static int setReversePageIndex(PrintRequestAttributeSet printRequestAttr, int pageIndex) {
        PageRangeReverse prr = (PageRangeReverse)printRequestAttr.get(PageRangeReverse.class);
        if (prr != null && prr.isReverse()) {
            ArrayList printPage = prr.getPrintPage();
            int p = KDPrinterUtils.buildReverseNumberStr(printPage, pageIndex + 1);
            pageIndex = p - 1;
            return pageIndex;
        }
        return pageIndex;
    }

    public static String printNowTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS ");
        return df.format(new Date(System.currentTimeMillis()));
    }

    public static int getTextWidth(FontMetrics fm, String text) {
        return text != null ? fm.stringWidth(text) : 0;
    }

    public static int getTextHeight(FontMetrics fm, String text) {
        return fm.getHeight();
    }

    public static int mmToPoint(float mm, int dpi) {
        return KDPrinterUtils.inchToPoint(mm / 25.4f, dpi);
    }

    public static int inchToPoint(float inch, int dpi) {
        return (int)((double)(inch * (float)dpi) + 0.5);
    }

    public static MediaPrintableArea getMediaPrintableArea(PrintRequestAttributeSet attributes) {
        Media media = (Media)attributes.get(Media.class);
        MediaSizeName msn = (MediaSizeName)media;
        MediaSize msz = MediaSize.getMediaSizeForName(msn);
        if (msz == null) {
            msz = MediaSize.ISO.A4;
        }
        float paperWidth = msz.getX(1000);
        float paperHeight = msz.getY(1000);
        MediaPrintableArea area = new MediaPrintableArea(0.0f, 0.0f, paperWidth, paperHeight, 1000);
        return area;
    }

    public static CtrlPageFormat getCtrlPageFormat(PrintRequestAttributeSet attributes, String id) {
        if (attributes == null) {
            attributes = new HashPrintRequestAttributeSet();
        }
        CtrlPageFormat pageFormat = KDPrinterUtils.getDefaultCtrlPageFormat();
        Paper paper = pageFormat.getPaper();
        try {
            float top;
            OrientationRequested orientReq = (OrientationRequested)attributes.get(OrientationRequested.class);
            if (orientReq != null) {
                int orient = orientReq != null && KDPrinterUtils.isSupportedValue(orientReq, attributes) ? (orientReq.equals(OrientationRequested.REVERSE_LANDSCAPE) ? 2 : (orientReq.equals(OrientationRequested.LANDSCAPE) ? 0 : 1)) : 1;
                pageFormat.setOrientation(orient);
            }
            Dimension paperDim = KDPrinterUtils.getPaperSize(attributes, 72);
            double paperWidth = paperDim.getWidth() / KDPrinterUtils.getScreenMapRate(72);
            double paperHeight = paperDim.getHeight() / KDPrinterUtils.getScreenMapRate(72);
            ValidateAreaInfo validateInfo = KDPrinterUtils.getValidateAreaInfo(attributes);
            float left = top = 0.0011811024f * (float)KDPrinterUtils.getPtsPerInch();
            float bottom = top;
            float right = top;
            if (validateInfo != null) {
                top = validateInfo.getTop(25400) * (float)KDPrinterUtils.getPtsPerInch();
                left = validateInfo.getLeft(25400) * (float)KDPrinterUtils.getPtsPerInch();
                bottom = validateInfo.getBottom(25400) * (float)KDPrinterUtils.getPtsPerInch();
                right = validateInfo.getRight(25400) * (float)KDPrinterUtils.getPtsPerInch();
            }
            paper.setSize(paperWidth, paperHeight);
            paper.setImageableArea(top, left, paperWidth - (double)left - (double)right, paperHeight - (double)top - (double)bottom);
            pageFormat.setPaper(paper);
            pageFormat = KDPrinterUtils.validatePage(pageFormat);
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
        }
        return pageFormat;
    }

    public static PageIntervalInfo countUnPrintableArea(PrintService printService, Media media) {
        MediaSizeName msn = null;
        PageIntervalInfo pageIntervalInfo = new PageIntervalInfo(0.0f, 0.0f, 0.0f, 0.0f, 1000);
        if (media == null) {
            msn = MediaSizeName.ISO_A4;
        } else if (media instanceof MediaSizeName) {
            msn = (MediaSizeName)media;
        }
        if (printService == null) {
            return pageIntervalInfo;
        }
        HashPrintRequestAttributeSet tmpASet = new HashPrintRequestAttributeSet();
        tmpASet.add(msn);
        DocFlavor.SERVICE_FORMATTED docFlavor0 = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        Object values = printService.getSupportedAttributeValues(MediaPrintableArea.class, docFlavor0, tmpASet);
        if (values == null) {
            return pageIntervalInfo;
        }
        MediaPrintableArea mpa = null;
        if (values instanceof Attribute[]) {
            Attribute[] mpas = (Attribute[])values;
            mpa = (MediaPrintableArea)mpas[0];
        } else if (values instanceof Attribute) {
            mpa = (MediaPrintableArea)values;
        }
        if (mpa == null) {
            return pageIntervalInfo;
        }
        MediaSize msz = MediaSize.getMediaSizeForName(msn);
        float paperWidth = msz.getX(1000);
        float paperHeight = msz.getY(1000);
        float[] pa = mpa.getPrintableArea(1000);
        float left = Math.abs(Math.round(pa[0]));
        float top = Math.abs(Math.round(pa[1]));
        float width = Math.round(pa[2]);
        float height = Math.round(pa[3]);
        float right = Math.abs(Math.round(paperWidth - left - width));
        float bottom = Math.abs(Math.round(paperHeight - top - height));
        return new PageIntervalInfo(top, left, bottom, right, 1000);
    }

    public static Dimension getPaperSize(PrintRequestAttributeSet attributes, int unit) {
        double screenRate = KDPrinterUtils.getScreenMapRate(unit);
        CtrlPageFormat pageFormat = KDPrinterUtils.getDefaultCtrlPageFormat();
        double paperWidth = pageFormat.getWidth() * screenRate;
        double paperHeight = pageFormat.getHeight() * screenRate;
        Media media = (Media)attributes.get(Media.class);
        if (KDPrinterUtils.isSupportedValue(media, attributes) && media instanceof MediaSizeName) {
            MediaSizeName msn = (MediaSizeName)media;
            MediaSize msz = MediaSize.getMediaSizeForName(msn);
            if (msz == null && msn == MediaSizeName.TABLOID) {
                msz = MediaSize.ISO.A4;
            }
            if (msz != null) {
                paperWidth = (double)(msz.getX(25400) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate;
                paperHeight = (double)(msz.getY(25400) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate;
            }
        }
        return new Dimension((int)paperWidth, (int)paperHeight);
    }

    public static Dimension getPaperSize2(PrintRequestAttributeSet attributes, int unit) {
        double paperWidth = 210.0;
        double paperHeight = 297.0;
        Media media = (Media)attributes.get(Media.class);
        if (KDPrinterUtils.isSupportedValue(media, attributes) && media instanceof MediaSizeName) {
            MediaSizeName msn = (MediaSizeName)media;
            MediaSize msz = MediaSize.getMediaSizeForName(msn);
            if (msz == null && msn == MediaSizeName.TABLOID) {
                msz = MediaSize.ISO.A4;
            }
            if (msz != null) {
                paperWidth = msz.getX(unit);
                paperHeight = msz.getY(unit);
            }
        }
        return new Dimension((int)paperWidth, (int)paperHeight);
    }

    protected static boolean isSupportedValue(Attribute attrval, PrintRequestAttributeSet attrset) {
        return true;
    }

    private static void validatePaper(Paper origPaper, Paper newPaper) {
        if (origPaper == null || newPaper == null) {
            return;
        }
        double wid = origPaper.getWidth();
        double hgt = origPaper.getHeight();
        double ix = origPaper.getImageableX();
        double iy = origPaper.getImageableY();
        double iw = origPaper.getImageableWidth();
        double ih = origPaper.getImageableHeight();
        Paper defaultPaper = new Paper();
        wid = wid > 0.0 ? wid : defaultPaper.getWidth();
        hgt = hgt > 0.0 ? hgt : defaultPaper.getHeight();
        ix = ix > 0.0 ? ix : defaultPaper.getImageableX();
        iy = iy > 0.0 ? iy : defaultPaper.getImageableY();
        iw = iw > 0.0 ? iw : defaultPaper.getImageableWidth();
        double d = ih = ih > 0.0 ? ih : defaultPaper.getImageableHeight();
        if (iw > wid) {
            iw = wid;
        }
        if (ih > hgt) {
            ih = hgt;
        }
        if (ix + iw > wid) {
            ix = wid - iw;
        }
        if (iy + ih > hgt) {
            iy = hgt - ih;
        }
        newPaper.setSize(wid, hgt);
        newPaper.setImageableArea(ix, iy, iw, ih);
    }

    private static CtrlPageFormat validatePage(CtrlPageFormat page) {
        CtrlPageFormat newPage = (CtrlPageFormat)page.clone();
        Paper newPaper = new Paper();
        KDPrinterUtils.validatePaper(newPage.getPaper(), newPaper);
        newPage.setPaper(newPaper);
        return newPage;
    }

    public static CtrlPageFormat getDefaultCtrlPageFormat() {
        CtrlPageFormat newPage = new CtrlPageFormat();
        newPage.setOrientation(1);
        Paper newPaper = new Paper();
        double mmPerInch = 25.4;
        double ptsPerInch = KDPrinterUtils.getPtsPerInch();
        double a4Width = Math.rint(210.0 / mmPerInch * ptsPerInch);
        double a4Height = Math.rint(297.0 / mmPerInch * ptsPerInch);
        newPaper.setSize(a4Width, a4Height);
        newPaper.setImageableArea(ptsPerInch, ptsPerInch, a4Width - 2.0 * ptsPerInch, a4Height - 2.0 * ptsPerInch);
        newPage.setPaper(newPaper);
        return newPage;
    }

    public static HeadFootIntervalInfo getHeadFootIntervalInfo(PrintRequestAttributeSet attributes) {
        if (attributes != null && attributes.get(HeadFootIntervalInfo.class) != null) {
            return (HeadFootIntervalInfo)attributes.get(HeadFootIntervalInfo.class);
        }
        return HeadFootIntervalInfo.DEFAULT;
    }

    public static ValidateAreaInfo getValidateAreaInfo(PrintRequestAttributeSet attribute) {
        if (attribute != null && attribute.get(ValidateAreaInfo.class) != null) {
            return (ValidateAreaInfo)attribute.get(ValidateAreaInfo.class);
        }
        return ValidateAreaInfo.DEFAULT;
    }

    public static PageIntervalInfo getPageContentArea(PrintRequestAttributeSet attribute) {
        if (attribute != null && attribute.get(PageIntervalInfo.class) != null) {
            return (PageIntervalInfo)attribute.get(PageIntervalInfo.class);
        }
        return PageIntervalInfo.getDefault();
    }

    public static Rectangle getPageBounds(PrintRequestAttributeSet attribute, int unit) {
        double screenRate = KDPrinterUtils.getScreenMapRate(unit);
        PageIntervalInfo pageInfo = KDPrinterUtils.getPageContentArea(attribute);
        Dimension paperDim = KDPrinterUtils.getPaperSize(attribute, unit);
        int width = paperDim.width;
        int height = paperDim.height;
        Attribute att = attribute.get(OrientationRequested.class);
        if (att == OrientationRequested.LANDSCAPE) {
            width = paperDim.height;
            height = paperDim.width;
        }
        Rectangle rect = new Rectangle();
        int pLeft = (int)((double)(pageInfo.getLeft(25430) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate + 0.5);
        int pTop = (int)((double)(pageInfo.getTop(25430) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate + 0.5);
        int pBottom = (int)((double)(pageInfo.getBottom(25430) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate + 0.5);
        int pRight = (int)((double)(pageInfo.getRight(25430) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate + 0.5);
        rect.x = pLeft;
        rect.y = pTop;
        rect.width = width - pLeft - pRight;
        rect.height = height - pTop - pBottom;
        return rect;
    }

    public static Rectangle getPageHeadBounds(PrintRequestAttributeSet attribute, int unit) {
        double screenRate = KDPrinterUtils.getScreenMapRate(unit);
        HeadFootIntervalInfo hfi = KDPrinterUtils.getHeadFootIntervalInfo(attribute);
        if (hfi != null) {
            double top = (double)(hfi.getHeadTop(25430) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate + 0.5;
            Rectangle pageRect = KDPrinterUtils.getPageBounds(attribute, unit);
            Rectangle headRect = new Rectangle();
            headRect.x = pageRect.x;
            headRect.y = (int)top;
            headRect.width = pageRect.width;
            headRect.height = pageRect.y - (int)top;
            return headRect;
        }
        return ZERORECTANGLE;
    }

    public static Rectangle getPageFootBounds(PrintRequestAttributeSet attribute, int unit) {
        double screenRate = KDPrinterUtils.getScreenMapRate(unit);
        HeadFootIntervalInfo hfi = KDPrinterUtils.getHeadFootIntervalInfo(attribute);
        if (hfi != null) {
            double bottom = (double)(hfi.getFootBottom(25430) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate + 0.5;
            Rectangle pageRect = KDPrinterUtils.getPageBounds(attribute, unit);
            Dimension pagerDim = KDPrinterUtils.getPaperSize(attribute, unit);
            int pheight = 0;
            pheight = pagerDim.height;
            Attribute att = attribute.get(OrientationRequested.class);
            if (att == OrientationRequested.LANDSCAPE) {
                pheight = pagerDim.width;
            }
            Rectangle footRect = new Rectangle();
            int defaultHeight = 100;
            footRect.x = pageRect.x;
            footRect.y = (int)((double)pheight - bottom - (double)defaultHeight - 1.0);
            footRect.width = pageRect.width;
            footRect.height = defaultHeight;
            return footRect;
        }
        return ZERORECTANGLE;
    }

    public static double getZoomScaleInfo(PrintRequestAttributeSet attributes) {
        try {
            ZoomScaleInfo obj = (ZoomScaleInfo)attributes.get(ZoomScaleInfo.class);
            if (obj != null) {
                double scale = obj.getScale();
                if (scale <= 0.0) {
                    scale = 1.0;
                }
                return scale;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1.0;
    }

    public static Rectangle getRectangleForZoom(Rectangle rect, double scale) {
        if (rect != null) {
            int w = rect.width;
            int h = rect.height;
            w = (int)((double)w / scale + 0.5);
            h = (int)((double)h / scale + 0.5);
            rect.width = w;
            rect.height = h;
            return rect;
        }
        return null;
    }

    public static JComponent getComponentOfButtonItem(ButtonItem bi) {
        if (bi.getCompType() == 0) {
            Icon icon;
            KDWorkButton wb = new KDWorkButton();
            String text = bi.getText();
            if (text != null) {
                wb.setText(text);
                wb.setToolTipText(text);
            }
            if ((icon = bi.getIcon()) != null) {
                wb.setIcon(icon);
            }
            wb.setEnabled(bi.isEnabled());
            wb.setVisible(bi.isVisible());
            return wb;
        }
        if (bi.getCompType() == 1) {
            Icon selectIcon;
            Icon rollverIcon;
            Icon pressedIcon;
            Icon disableIcon;
            Icon icon;
            KDToggleButton tb = new KDToggleButton();
            String text = bi.getText();
            if (text != null) {
                tb.setText(text);
                tb.setToolTipText(text);
            }
            if ((icon = bi.getIcon()) != null) {
                tb.setIcon(icon);
            }
            if ((disableIcon = bi.getDisabledIcon()) != null) {
                tb.setDisabledIcon(disableIcon);
            }
            if ((pressedIcon = bi.getPressedIcon()) != null) {
                tb.setPressedIcon(pressedIcon);
            }
            if ((rollverIcon = bi.getRolloverIcon()) != null) {
                tb.setRolloverIcon(rollverIcon);
            }
            if ((selectIcon = bi.getSelectedIcon()) != null) {
                tb.setSelectedIcon(selectIcon);
            }
            tb.setVisible(bi.isVisible());
            return tb;
        }
        if (bi.getCompType() == 2) {
            return bi.getOtherComponent();
        }
        return null;
    }

    public static String parseVariant(PainterInfo info, String name) {
        IVariantParser parser = info.getDefaultVariantParser();
        IVariantParser customparser = info.getVariantParser();
        return KDPrinterUtils.parseVariant(parser, customparser, name, info);
    }

    public static String parseVariant(KDPrinter printer, String variant) {
        return KDPrinterUtils.parseVariant(printer.getDefaultVariantParser(), printer.getVariantParser(), variant, null);
    }

    public static String parseVariant(IVariantParser defaultParser, IVariantParser customParser, String variant, PainterInfo info) {
        String str = null;
        if (defaultParser != null) {
            str = defaultParser.parse(variant, info);
        }
        if (str == null && customParser != null) {
            str = customParser.parse(variant, info);
        }
        return str;
    }

    public static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog || parentComponent == null) {
            return (Window)parentComponent;
        }
        return KDPrinterUtils.getWindowForComponent(parentComponent.getParent());
    }

    public static void adjustHeaderFooterBounds(com.kingdee.cosmic.ctrl.print.ui.component.Paper paper, Graphics g, PainterInfo info) {
        Canvas footer;
        Canvas header = paper.getHeader();
        if (header instanceof HeaderFooter) {
            ((HeaderFooter)header).adjustHeaderBounds(paper, g, info);
        }
        if ((footer = paper.getFooter()) instanceof HeaderFooter) {
            ((HeaderFooter)footer).adjustFooterBounds(paper, g, info);
        }
    }

    public static MediaSizeName getMediaSizeName(String name) {
        for (int i = 0; i < myStringTable.length; ++i) {
            if (!myStringTable[i].equals(name)) continue;
            return KDPrinterUtils.getMediaSizeNameByValue(i);
        }
        return null;
    }

    public static MediaSizeName getMediaSizeNameByValue(int value) {
        if (value < mediaSizeNameValueTable.length) {
            return mediaSizeNameValueTable[value];
        }
        return null;
    }

    public static MediaSizeName getMediaSizeNameByValue(int value, float x, float y) {
        if (value < mediaSizeNameValueTable.length) {
            return mediaSizeNameValueTable[value];
        }
        if (ArrayUtil.isEqual((Float)Float.valueOf(x), (Float)Float.valueOf(0.0f)) || ArrayUtil.isEqual((Float)Float.valueOf(y), (Float)Float.valueOf(0.0f))) {
            return null;
        }
        int unit = 1000;
        MediaSizeNameExtend mse = null;
        mse = MediaSizeNameExtend.CUSTOM;
        MediaSize ms = MediaSize.getMediaSizeForName(mse);
        if (ms instanceof FreeMediaSize) {
            ((FreeMediaSize)ms).setXY(x, y, unit);
        } else if (ms == null) {
            new FreeMediaSize(x, y, unit, (MediaSizeName)mse);
        }
        return mse;
    }

    public static ArrayList parseVariantText(String text) {
        String[] strings = text.split("&\\[");
        ArrayList<String> textList = new ArrayList<String>();
        textList.add(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            int varEnd = strings[i].indexOf(93);
            String varStr = "";
            String otherStr = "";
            if (varEnd == -1) {
                varStr = strings[i];
                textList.add("&[" + varStr);
                continue;
            }
            varStr = strings[i].substring(0, varEnd);
            otherStr = strings[i].substring(varEnd + 1);
            textList.add("&[" + varStr);
            textList.add(otherStr);
        }
        return textList;
    }

    public static boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isPercentStr(String str) {
        boolean b = false;
        if (str == null) {
            return b;
        }
        if (str.endsWith("%") && str.length() > 1) {
            return KDPrinterUtils.isNumber(str.substring(0, str.length() - 1));
        }
        return b;
    }

    public static float getPercentByStr(String str) {
        String value = str;
        if (str.endsWith("%") && str.length() > 1) {
            value = str.substring(0, str.length() - 1);
        }
        return Float.parseFloat(value) / 100.0f;
    }

    public static com.kingdee.cosmic.ctrl.print.ui.component.Paper adjustPaperBounds(com.kingdee.cosmic.ctrl.print.ui.component.Paper paper) {
        float pageHeight = paper.getContentHeight();
        IPrintJob job = paper.getPainterInfo().getAttributeManager().getPrinter().getPrintJobByPaperIndex(paper.getIndex());
        PrintJobConfig config = job.getConfig();
        float margin = config.getBodyTopMargin(25430) + config.getBodyBottomMargin(25430);
        float bottomMargin = config.getBodyBottomMargin(25430) + config.getBodyBottomMargin(25430);
        pageHeight = pageHeight + margin * 72.0f + bottomMargin * 72.0f;
        float pHeight = (float)paper.getPainterSize().getHeight();
        paper.setPainterSize((float)paper.getPainterSize().getWidth(), pageHeight);
        Canvas canvas = paper.getFooter();
        if (canvas != null) {
            canvas.setPainterLocation(canvas.getPainterLocation().x, canvas.getPainterLocation().y - (pHeight - pageHeight));
        }
        return paper;
    }

    public static Color hexToColor(String strColor) {
        try {
            return StyleParser.hexToColor((String)strColor);
        }
        catch (Exception e) {
            try {
                return new Color(Integer.parseInt(strColor));
            }
            catch (Exception ee) {
                return null;
            }
        }
    }

    public static String colorToHex(Color color) {
        return StyleParser.colorToHex((Color)color);
    }

    public static File openFileChooser(JComponent parent, final String[] accepts) {
        KDFileChooser fileChooser = new KDFileChooser();
        Frame f = JOptionPane.getFrameForComponent(parent);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                int extend = name.lastIndexOf(46);
                if (extend > 0) {
                    String extendName = name.substring(extend + 1);
                    if (accepts != null && accepts.length > 0) {
                        for (int i = 0; i < accepts.length; ++i) {
                            if (!extendName.equals(accepts[i])) continue;
                            return true;
                        }
                    }
                } else {
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                StringBuilder des = new StringBuilder();
                if (accepts != null && accepts.length > 0) {
                    for (int i = 0; i < accepts.length; ++i) {
                        des.append("*.").append(accepts[i]).append(";");
                    }
                }
                return des.toString();
            }
        };
        fileChooser.setFileFilter(fileFilter);
        fileChooser.showOpenDialog((Component)f);
        File file = fileChooser.getSelectedFile();
        return file;
    }

    public static Image openImageFileChooser(JComponent parent, String[] accepts) {
        File file = KDPrinterUtils.openFileChooser(parent, accepts);
        Image image = null;
        if (file != null) {
            image = parent.getToolkit().createImage(file.getAbsolutePath());
            KDPrinterUtils.waitForImage(image, parent);
        }
        return image;
    }

    public static Image createImageFromFile(Component parent, File file) {
        Image image = null;
        if (file != null) {
            if (parent == null) {
                parent = new Component(){};
            }
            image = parent.getToolkit().createImage(file.getAbsolutePath());
            KDPrinterUtils.waitForImage(image, parent);
        }
        return image;
    }

    public static boolean waitForImage(Image image, Component c) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !tracker.isErrorAny();
    }

    public static void printOutCanvas(Canvas canvas, String prefix) {
        com.kingdee.cosmic.ctrl.print.ui.component.Paper[] papers;
        if (canvas instanceof com.kingdee.cosmic.ctrl.print.ui.component.Paper) {
            KDPrinterUtils.printOutPaper((com.kingdee.cosmic.ctrl.print.ui.component.Paper)canvas, prefix);
        } else if (canvas instanceof MultiPaper && (papers = ((MultiPaper)canvas).getPapers()) != null) {
            for (int i = 0; i < papers.length; ++i) {
                KDPrinterUtils.printOutPaper(papers[i], prefix + "MultiPaper" + i);
            }
        }
    }

    public static void printOutPaper(com.kingdee.cosmic.ctrl.print.ui.component.Paper paper, String prefix) {
        if (paper != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("#CtrlPrint#");
            sb.append(prefix);
            sb.append("-----");
            sb.append("bound:");
            sb.append(paper.getPainterBounds());
            sb.append("head:");
            if (paper.getHeader() != null) {
                sb.append(paper.getHeader().getPainterBounds());
            } else {
                sb.append("null");
            }
            sb.append("body:");
            if (paper.getBody() != null) {
                sb.append(paper.getBody().getPainterBounds());
            } else {
                sb.append("null");
            }
            sb.append("foot:");
            if (paper.getFooter() != null) {
                sb.append(paper.getFooter().getPainterBounds());
            } else {
                sb.append("null");
            }
            System.out.println(sb);
        }
    }

    public static void printOutPageFormat(PageFormat pf, String prefix) {
        if (pf != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("#CtrlPrint#");
            sb.append(prefix);
            sb.append("-----");
            sb.append("Orientation:");
            sb.append(pf.getOrientation());
            sb.append("PageWidth:");
            sb.append(pf.getWidth());
            sb.append("PageHeight:");
            sb.append(pf.getHeight());
            sb.append("Imageable[X:");
            sb.append(pf.getImageableX());
            sb.append("Y:");
            sb.append(pf.getImageableY());
            sb.append("W:");
            sb.append(pf.getImageableWidth());
            sb.append("H:");
            sb.append(pf.getImageableHeight());
            sb.append(']');
            System.out.println(sb);
        }
    }
}

