/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.util;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.list.FileBasedList;
import com.kingdee.cosmic.ctrl.common.util.list.exception.OutOfCapacityException;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import com.kingdee.cosmic.ctrl.print.ui.io.Painter2Xml;
import com.kingdee.cosmic.ctrl.print.ui.io.Xml2Painter;
import com.kingdee.cosmic.ctrl.print.util.TempFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PrintPageFileBuffer
extends FileBasedList {
    private static final Logger logger = LogUtil.getPackageLogger(PrintPageFileBuffer.class);
    private int memoryBuffercount = 10;
    private List pageCache = new ArrayList();
    private Map styles = new HashMap();
    private Painter2Xml toXml = new Painter2Xml(this.styles);
    private Xml2Painter fromXml = new Xml2Painter(this.styles);

    public PrintPageFileBuffer(int memoryCount) throws IOException {
        super(-1, false);
        this.memoryBuffercount = memoryCount;
    }

    private void createBufferFile() throws IOException {
        if (this.randomFile == null) {
            File bufferFile = TempFileUtil.createTempFile();
            this.filePath = bufferFile.getAbsolutePath();
            this.randomFile = new RandomAccessFile(bufferFile, "rws");
            this.randomFile.setLength(0L);
        }
    }

    public Object get(int index) {
        if (index < this.memoryBuffercount) {
            return this.pageCache.get(index);
        }
        return super.get(index - this.memoryBuffercount);
    }

    public void add(int index, Object obj) throws OutOfCapacityException {
        if (index < this.memoryBuffercount) {
            this.pageCache.add(index, obj);
            return;
        }
        try {
            this.createBufferFile();
            super.add(index - this.memoryBuffercount, obj);
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
            throw new OutOfCapacityException((Throwable)e);
        }
    }

    public void add(Object obj) throws OutOfCapacityException {
        this.add(this.size(), obj);
    }

    public int size() {
        return this.pageCache.size() + super.size();
    }

    protected Object pureReadObject(int position, int objsize) {
        IXmlElement xml;
        byte[] data;
        try {
            data = super.readBytes(position, objsize);
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
            return null;
        }
        try {
            xml = XmlUtil.loadXmlBytes((byte[])data);
        }
        catch (IOException e1) {
            logger.error((Object)"err", (Throwable)e1);
            return null;
        }
        catch (XmlParsingException e1) {
            logger.error((Object)"err", (Throwable)e1);
            return null;
        }
        return this.fromXml.parsePage(xml);
    }

    protected int pureWriteObject(int position, Object object) {
        byte[] data;
        if (!(object instanceof Page)) {
            return 0;
        }
        IXmlElement xml = this.toXml.makePage((Page)object);
        try {
            data = XmlUtil.saveXmlBytes((IXmlElement)xml);
        }
        catch (IOException e1) {
            logger.error((Object)"err", (Throwable)e1);
            return 0;
        }
        try {
            super.writeBytes(position, data);
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
            return 0;
        }
        return data.length;
    }

    public void clear() {
        this.pageCache.clear();
        this.styles.clear();
        super.clear();
    }

    public Map getStyles() {
        return this.styles;
    }
}

