/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.xls;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.r1print.DivideModel;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.xls.AR1PNode_V2X;
import com.kingdee.cosmic.ctrl.print.xls.translater.DividableObject_V2X;
import com.kingdee.cosmic.ctrl.print.xls.widget.IXlsNode;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.server.ExportException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class R1PrintV2XExporter {
    private ObjectFactory _objFactory;
    private HashMap _catchFactory = new HashMap();
    protected Logger _log = LogUtil.getLogger((String)"R1PrintV2XExporter");
    private static final String DIVIDEV2XKEY = "divideObject";
    private DivideModel _model;
    private int _divideNum;

    public R1PrintV2XExporter() throws ExportException {
        String config = "R1PrintView2Xls.xml";
        try (InputStream in = this.getClass().getResourceAsStream(config);){
            if (in == null) {
                throw new ExportException("ObjectFactory config xml not found:" + config);
            }
            this._catchFactory.put(DIVIDEV2XKEY, new DividableObject_V2X());
            this._objFactory = new ObjectFactory(in);
        }
        catch (IOException e) {
            this._log.error((Object)"error", (Throwable)e);
        }
    }

    private AR1PNode_V2X createExporter(IPainter painter) {
        String key = painter.getClass().getName();
        this._model = null;
        AR1PNode_V2X exporter = (AR1PNode_V2X)this._catchFactory.get(key);
        if (exporter == null) {
            exporter = this._objFactory.getV2X(key);
            this._catchFactory.put(key, exporter);
        }
        return exporter;
    }

    public IXlsNode translate(IPainter painter, IXlsNode parent) {
        AR1PNode_V2X translater = this.createExporter(painter);
        if (translater == null) {
            return parent;
        }
        translater.setExporter(this);
        translater.setNode(painter);
        return translater.export(parent);
    }

    class ObjectFactory {
        private static final String NODE = "Node";
        private static final String TYPE = "type";
        private static final String CLASS = "class";
        private Map _classCache = new HashMap(8);

        public ObjectFactory(InputStream in) {
            try {
                IXmlElement root = XmlUtil.loadRootElement((InputStream)in);
                List children = root.searchChildren(NODE);
                for (IXmlElement element : children) {
                    String key = element.getAttribute(TYPE);
                    String value = element.getAttribute(CLASS);
                    this._classCache.put(key, value);
                }
            }
            catch (Exception e) {
                R1PrintV2XExporter.this._log.error((Object)"parse config file faild");
            }
        }

        public AR1PNode_V2X getV2X(String className) {
            String cls = (String)this._classCache.get(className);
            return (AR1PNode_V2X)this.createObject(cls);
        }

        private Object createObject(String cls) {
            Object obj = null;
            try {
                Class<?> c = Class.forName(cls);
                obj = c.newInstance();
            }
            catch (Exception e) {
                R1PrintV2XExporter.this._log.error((Object)("Can't create Instance of " + cls), (Throwable)e);
            }
            return obj;
        }
    }
}

