/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.xls.output;

import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import com.kingdee.cosmic.ctrl.print.xls.exobject.APaper;
import com.kingdee.cosmic.ctrl.print.xls.exobject.BasicCell;
import com.kingdee.cosmic.ctrl.print.xls.output.LinesList;
import com.kingdee.cosmic.ctrl.print.xls.output.StyleHelper;
import com.kingdee.cosmic.ctrl.print.xls.widget.IXlsNode;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsCell;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsContainer;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsImageCell;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsPaper;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsVariantCell;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Workbook;

public class PaperHelper {
    private Workbook _wb;
    private XlsPaper _paper;
    private LinesList _horizonLines;
    private LinesList _verticalLines;
    private Map _styleMap;

    public PaperHelper(Workbook wb, LinesList verticalLines, Map styleMap) {
        this._wb = wb;
        this._verticalLines = verticalLines;
        this._styleMap = styleMap;
    }

    public APaper exportPaper(XlsPaper paper) {
        this._paper = paper;
        this._horizonLines = paper.getHorizonLines();
        APaper apaper = this.exportBody();
        return apaper;
    }

    private APaper exportBody() {
        APaper returnPaper = new APaper();
        List children = this._paper.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                IXlsNode node = (IXlsNode)children.get(i);
                BasicCell aCell = null;
                aCell = node instanceof XlsContainer ? this.containerToCell((XlsContainer)node) : this.toCell((XlsCell)node);
                if (null == aCell) continue;
                returnPaper.addChild(aCell);
            }
        }
        return returnPaper;
    }

    private BasicCell containerToCell(XlsContainer container) {
        Style style = container.getStyle();
        BasicCell cell = new BasicCell(container.getId());
        if (container.isPicContainer()) {
            cell.setType(2);
        } else {
            cell.setType(3);
        }
        int layer = cell.getLayer();
        cell.setLayer(layer);
        cell.setX1(this._verticalLines.indexOf(container.getX1()));
        cell.setX2(this._verticalLines.indexOf(container.getX2()));
        cell.setY1(this._horizonLines.indexOf(container.getY1()));
        cell.setY2(this._horizonLines.indexOf(container.getY2()));
        float height = cell.getHeight();
        float width = cell.getWidth();
        cell.setHeight(height);
        cell.setWidth(width);
        CellStyle cellstyle = null;
        cellstyle = style != null ? this.getStyle(style, cell) : (container.getStyleKey() != null ? this.getStyle(container.getStyleKey(), cell) : this.getStyle("cellstyleisnull!!!", cell));
        if (cellstyle.getFillPattern() == FillPatternType.NO_FILL && cellstyle.getBorderLeft() == BorderStyle.NONE && cellstyle.getBorderRight() == BorderStyle.NONE && cellstyle.getBorderTop() == BorderStyle.NONE && cellstyle.getBorderBottom() == BorderStyle.NONE) {
            return null;
        }
        cell.setStyle(cellstyle);
        return cell;
    }

    private BasicCell toCell(XlsCell cell) {
        Style style = cell.getStyle();
        BasicCell returnCell = new BasicCell(cell.getId());
        returnCell.setLayer(cell.getLayer());
        returnCell.setX1(this._verticalLines.indexOf(cell.getX1()));
        returnCell.setX2(this._verticalLines.indexOf(cell.getX2()));
        returnCell.setY1(this._horizonLines.indexOf(cell.getY1()));
        returnCell.setY2(this._horizonLines.indexOf(cell.getY2()));
        returnCell.setHeight(cell.getHeight());
        returnCell.setWidth(cell.getWidth());
        CellStyle cellstyle = null;
        cellstyle = style != null ? this.getStyle(style, returnCell) : (cell.getStyleKey() != null ? this.getStyle(cell.getStyleKey(), returnCell) : this.getStyle("cellstyleisnull!!!", returnCell));
        returnCell.setStyle(cellstyle);
        if (cell instanceof XlsVariantCell) {
            String value = KDPrinterUtils.parseVariant(this._paper.getPainterInfo(), (String)cell.getValue());
            returnCell.setValue(value);
        } else if (cell instanceof XlsImageCell) {
            returnCell.setType(1);
            returnCell.setScaleModel(((XlsImageCell)cell).getScaleModel());
            returnCell.setValue(cell.getValue());
        } else {
            returnCell.setValue(cell.getValue());
        }
        return returnCell;
    }

    private CellStyle getStyle(Style style, BasicCell cell) {
        String key = this.generateStyleKey(style);
        return this.getStyle(key, cell);
    }

    private CellStyle getStyle(String style, BasicCell cell) {
        String key = style;
        CellStyle cstyle = (CellStyle)this._styleMap.get(key);
        if (cstyle == null) {
            cstyle = StyleHelper.getStyle(style, this._wb);
            this._styleMap.put(key, cstyle);
        }
        return cstyle;
    }

    private String generateStyleKey(Style style) {
        return StyleHelper.getKey(style);
    }

    public Map getStyleMap() {
        return this._styleMap;
    }
}

