/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ca;

import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.Certificate;
import com.google.common.base.Charsets;
import com.itrus.util.Base64;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.Resources;
import kd.bos.ca.itrus.CaECExchangeTool;
import kd.bos.ca.itrus.Config;
import kd.bos.ca.itrus.ConfigTool;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class KSign {
    private static final String VERIFY_SUCCESS = "success";
    private static final String VERIFY_MESSAGE = "message";
    private static final String PROJECT_NAME = "bos-util";

    public static Map<String, Object> verifySign(String signData, String plainData, String publicKey, Map<String, Object> caConfig) {
        Map<String, Object> result = KSign.verifyMessageRaw(signData, plainData, publicKey, caConfig);
        return result;
    }

    private static Map<String, Object> verifyMessageRaw(String signData, String plainData, String publicKey, Map<String, Object> caConfig) {
        HashMap<String, Object> result;
        block11: {
            result = new HashMap<String, Object>();
            if (publicKey != null) {
                try {
                    Config config = KSign.getConfig(caConfig);
                    if (ConfigTool.getInstance().getConfig() == null) {
                        ConfigTool.initialized = false;
                    } else if (!ConfigTool.getInstance().getConfig().equals(config)) {
                        ConfigTool.initialized = false;
                    }
                    ConfigTool.getInstance().setConfig(config);
                    ConfigTool.getInstance().init();
                    Certificate cert = new Certificate(publicKey);
                    Boolean flag = cert.verifyRaw(Base64.decode((byte[])signData.getBytes(Charsets.UTF_8)), plainData.getBytes(Charsets.UTF_8));
                    if (flag.booleanValue()) {
                        if (cert.verify()) {
                            result.put(VERIFY_SUCCESS, true);
                            result.put(VERIFY_MESSAGE, Resources.getString(PROJECT_NAME, "KSign_0", null));
                        } else {
                            result.put(VERIFY_SUCCESS, false);
                            result.put(VERIFY_MESSAGE, Resources.getString(PROJECT_NAME, "KSign_1", null));
                        }
                        break block11;
                    }
                    result.put(VERIFY_SUCCESS, false);
                    result.put(VERIFY_MESSAGE, result.put(VERIFY_MESSAGE, Resources.getString(PROJECT_NAME, "KSign_2", null)));
                }
                catch (CertApiException e) {
                    result.put(VERIFY_SUCCESS, false);
                    result.put(VERIFY_MESSAGE, Resources.getString(PROJECT_NAME, "KSign_3", null) + CaECExchangeTool.getEMByEC(e.getMessage()));
                }
                catch (Exception e) {
                    result.put(VERIFY_SUCCESS, false);
                    result.put(VERIFY_MESSAGE, Resources.getString(PROJECT_NAME, "KSign_4", null) + e.getMessage());
                }
            } else {
                result.put(VERIFY_SUCCESS, false);
                result.put(VERIFY_MESSAGE, Resources.getString(PROJECT_NAME, "KSign_5", null));
            }
        }
        return result;
    }

    public static Map<Object, Object> calculateSignTexts(Map<Object, Object> cleartexts) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        String encdeStr = "";
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        for (Map.Entry<Object, Object> entry : cleartexts.entrySet()) {
            Object id = entry.getKey();
            byte[] hash = messageDigest.digest(entry.getValue().toString().getBytes(Charsets.UTF_8));
            encdeStr = Hex.encodeHexString((byte[])hash);
            result.put(id, encdeStr);
        }
        return result;
    }

    public static String calculateSignText(String str) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String encdeStr = "";
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] hash = messageDigest.digest(str.getBytes(Charsets.UTF_8));
        encdeStr = Hex.encodeHexString((byte[])hash);
        return encdeStr;
    }

    private static Config getConfig(Map<String, Object> caConfig) throws IOException {
        String baseUrl1;
        String license;
        Config config = new Config();
        String caCert1 = caConfig.get("caCert1") == null ? "" : caConfig.get("caCert1").toString();
        String string = license = caConfig.get("license") == null ? "" : caConfig.get("license").toString();
        if (!KSign.isEmptyString(caCert1)) {
            config.setCaCert1(caCert1);
        }
        if (!KSign.isEmptyString(license)) {
            config.setLicense(license);
        }
        String url = caConfig.get("URL") == null ? "" : caConfig.get("URL").toString();
        String accountHash = caConfig.get("AccountHash") == null ? "" : caConfig.get("AccountHash").toString();
        String accountHashDouble = caConfig.get("AccountHashDouble") == null ? "" : caConfig.get("AccountHashDouble").toString();
        String password = caConfig.get("Password") == null ? "" : caConfig.get("Password").toString();
        String caCert = caConfig.get("caCert") == null ? "" : caConfig.get("caCert").toString();
        String checkRevoke = caConfig.get("checkRevoke") == null ? "" : caConfig.get("checkRevoke").toString();
        String baseUrl = caConfig.get("baseUrl") == null ? "" : caConfig.get("baseUrl").toString();
        String string2 = baseUrl1 = caConfig.get("baseUrl1") == null ? "" : caConfig.get("baseUrl1").toString();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            config.setURL(url);
        }
        if (StringUtils.isNotBlank((CharSequence)accountHash)) {
            config.setAccountHash(accountHash);
        }
        if (StringUtils.isNotBlank((CharSequence)accountHashDouble)) {
            config.setAccountHashDouble(accountHashDouble);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            config.setPasswprd(password);
        }
        if (StringUtils.isNotBlank((CharSequence)caCert)) {
            config.setCaCert(caCert);
        }
        if (StringUtils.isNotBlank((CharSequence)checkRevoke)) {
            config.setCheckRevoke(checkRevoke);
        }
        if (StringUtils.isNotBlank((CharSequence)baseUrl)) {
            config.setBaseUrl(baseUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)baseUrl1)) {
            config.setBaseUrl1(baseUrl1);
        }
        config.setJson();
        return config;
    }

    private static boolean isEmptyString(Object v) {
        if (v == null) {
            return true;
        }
        String value = (String)v;
        if ("".equals(value) || value.length() == 0) {
            return true;
        }
        return value.length() < 100 && value.trim().length() == 0;
    }
}

