/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V> {
    private final LinkedHashMap<K, V> map;
    private int cacheSize;
    private int cacheMaxSize;
    private int cachePutCount;
    private int cacheCreateCount;
    private int cacheEvictionCount;
    private int cacheHitCount;
    private int cacheMissCount;

    public LRUCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.cacheMaxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        V mapValue;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            mapValue = this.map.get(key);
            if (mapValue != null) {
                ++this.cacheHitCount;
                return mapValue;
            }
            ++this.cacheMissCount;
        }
        V createdValue = this.create(key);
        if (createdValue == null) {
            return null;
        }
        LRUCache lRUCache2 = this;
        synchronized (lRUCache2) {
            ++this.cacheCreateCount;
            mapValue = this.map.put(key, createdValue);
            if (mapValue != null) {
                this.map.put(key, mapValue);
            } else {
                this.cacheSize += this.safeSizeOf(key, createdValue);
            }
        }
        if (mapValue != null) {
            this.entryRemoved(false, key, createdValue, mapValue);
            return mapValue;
        }
        this.trimToSize(this.cacheMaxSize);
        return createdValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V previous;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            ++this.cachePutCount;
            this.cacheSize += this.safeSizeOf(key, value);
            previous = this.map.put(key, value);
            if (previous != null) {
                this.cacheSize -= this.safeSizeOf(key, previous);
            }
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, value);
        }
        this.trimToSize(this.cacheMaxSize);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(int maxSize) {
        while (true) {
            V value;
            K key;
            LRUCache lRUCache = this;
            synchronized (lRUCache) {
                if (this.cacheSize < 0 || this.map.isEmpty() && this.cacheSize != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.cacheSize <= maxSize || this.map.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> toEvict = this.map.entrySet().iterator().next();
                key = toEvict.getKey();
                value = toEvict.getValue();
                this.map.remove(key);
                this.cacheSize -= this.safeSizeOf(key, value);
                ++this.cacheEvictionCount;
            }
            this.entryRemoved(true, key, value, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V remove(K key) {
        Object previous;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            previous = this.map.remove(key);
            if (previous != null) {
                this.cacheSize -= this.safeSizeOf(key, previous);
            }
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, null);
        }
        return previous;
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int safeSizeOf(K key, V value) {
        int result = this.sizeOf(key, value);
        if (result < 0) {
            throw new IllegalStateException("Negative size: " + key + "=" + value);
        }
        return result;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.cacheSize;
    }

    public final synchronized int maxSize() {
        return this.cacheMaxSize;
    }

    public final synchronized int hitCount() {
        return this.cacheHitCount;
    }

    public final synchronized int missCount() {
        return this.cacheMissCount;
    }

    public final synchronized int createCount() {
        return this.cacheCreateCount;
    }

    public final synchronized int putCount() {
        return this.cachePutCount;
    }

    public final synchronized int evictionCount() {
        return this.cacheEvictionCount;
    }

    public final synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    public final synchronized String toString() {
        int accesses = this.cacheHitCount + this.cacheMissCount;
        int hitPercent = accesses != 0 ? 100 * this.cacheHitCount / accesses : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.cacheMaxSize, this.cacheHitCount, this.cacheMissCount, hitPercent);
    }
}

