/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import kd.bos.encrypt.impl.RSAEncrypterUtil;

public class EncryptKey {
    private String publicKey;
    private String privateKey;
    private String publicExponent;
    private String privateExponent;
    private String modulus;

    public EncryptKey() {
    }

    public EncryptKey(String publicKey, String privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public EncryptKey(String publicKey, String privateKey, String publicExponent, String privateExponent, String modulus) {
        this(publicKey, privateKey);
        this.publicExponent = publicExponent;
        this.privateExponent = privateExponent;
        this.modulus = modulus;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicExponent() {
        return this.publicExponent;
    }

    public String getPrivateExponent() {
        return this.privateExponent;
    }

    public String getModulus() {
        return this.modulus;
    }

    public void setModulus(String modulus) {
        this.modulus = modulus;
    }

    public static EncryptKey generateKey() {
        try {
            KeyPair keyPair = RSAEncrypterUtil.genKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            BigInteger modulus = ((RSAPublicKey)publicKey).getModulus();
            BigInteger publicexponent = ((RSAPublicKey)publicKey).getPublicExponent();
            BigInteger privateexponent = ((RSAPrivateKey)privateKey).getPrivateExponent();
            String publicKeyStr = new String(Base64.getEncoder().encode(publicKey.getEncoded()));
            String privateKeyStr = new String(Base64.getEncoder().encode(privateKey.getEncoded()));
            EncryptKey key = new EncryptKey(publicKeyStr, privateKeyStr, String.valueOf(publicexponent), String.valueOf(privateexponent), String.valueOf(modulus));
            return key;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

