/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt;

import java.lang.reflect.Constructor;
import java.security.SecureRandom;
import java.util.ArrayList;
import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.Encrypter;
import kd.bos.encrypt.aes.AESEncrypter;
import kd.bos.encrypt.aes.AESEncrypterImpl;
import kd.bos.encrypt.core.MatchableEncrypter;
import kd.bos.encrypt.core.SmartEncrypter;
import kd.bos.extension.ExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncrypterFactory {
    private static final Logger log = LoggerFactory.getLogger(EncrypterFactory.class);
    private static MatchableEncrypter defaultEncrypterImpl = null;
    private static MatchableEncrypter[] allEncrypterImpls = null;
    private static String DEFAULT_ENCRYPTER = "kd.bos.encrypt.impl.DAbcEncrypter";
    private static String ENCRYPTER = "kd.bos.encrypt.default";
    private static String ALL_ENCRYPTER = "kd.bos.encrypt.all";
    private static final String CUSTOMDEFAULT_KEY = "customdefault";
    private static String HAS_ALL_ENCRYPTER = "kd.bos.encrypt.impl.KAESEncrypter,kd.bos.encrypt.impl.DAbcEncrypter,kd.bos.encrypt.impl.AbcEncrypter,kd.bos.encrypt.impl.NPEncrypter";
    private static String RSAKEY_ENCRYPTER = "kd.bos.encrypt.impl.RSAKeyEncrypter";
    private static Encrypter instance = null;
    private static AESEncrypter aesInstance = null;
    private static SecureRandom random;

    private EncrypterFactory() {
    }

    public static AESEncrypter getAesEncrypter() {
        return aesInstance;
    }

    public static Encrypter getEncrypter() {
        return EncrypterFactory.getEncrypter(true);
    }

    public static Encrypter getEncrypter(boolean fixed) {
        if (fixed) {
            return instance;
        }
        return new SmartEncrypter(allEncrypterImpls[random.nextInt(allEncrypterImpls.length)], allEncrypterImpls);
    }

    public static Encrypter getEncrypterByPublicKey(String key) {
        try {
            Class<?> cls = Class.forName(RSAKEY_ENCRYPTER);
            Constructor<?> constructor = cls.getConstructor(String.class, String.class, Boolean.class);
            return (Encrypter)constructor.newInstance("", key, false);
        }
        catch (Exception e) {
            throw new EncryptException("can't find implement class for interface kd.bos.encrypt.Encrypter", e);
        }
    }

    public static Encrypter getEncrypterByPrivateKey(String key) {
        try {
            Class<?> cls = Class.forName(RSAKEY_ENCRYPTER);
            Constructor<?> constructor = cls.getConstructor(String.class, String.class, Boolean.class);
            return (Encrypter)constructor.newInstance("", key, true);
        }
        catch (Exception e) {
            throw new EncryptException("can't find implement class for interface kd.bos.encrypt.Encrypter", e);
        }
    }

    private static void loadAllEncrypter(String all) {
        String[] allencrytpers = all.split(",");
        ArrayList<MatchableEncrypter> list = new ArrayList<MatchableEncrypter>();
        list.add(defaultEncrypterImpl);
        String def = defaultEncrypterImpl.getClass().getName();
        for (String en : allencrytpers) {
            try {
                if (en.equals(def)) continue;
                Class<?> cls = Class.forName(en);
                MatchableEncrypter me = (MatchableEncrypter)cls.newInstance();
                list.add(me);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        allEncrypterImpls = new MatchableEncrypter[list.size()];
        for (int i = 0; i < allEncrypterImpls.length; ++i) {
            EncrypterFactory.allEncrypterImpls[i] = (MatchableEncrypter)list.get(i);
        }
    }

    static {
        String encrypter = System.getProperty(ENCRYPTER);
        if (encrypter == null) {
            try {
                ExtensionFactory<MatchableEncrypter> factory = ExtensionFactory.getExtensionFacotry(MatchableEncrypter.class);
                if (factory.existsExtension(CUSTOMDEFAULT_KEY)) {
                    defaultEncrypterImpl = factory.getExtension(CUSTOMDEFAULT_KEY);
                }
                if (defaultEncrypterImpl != null) {
                    HAS_ALL_ENCRYPTER = defaultEncrypterImpl.getClass().getName() + "," + HAS_ALL_ENCRYPTER;
                }
            }
            catch (Exception e) {
                log.info("have no custom default encrypter", (Throwable)e);
            }
        }
        if (defaultEncrypterImpl == null) {
            try {
                if (encrypter == null) {
                    encrypter = DEFAULT_ENCRYPTER;
                }
                Class<?> cls = Class.forName(encrypter);
                defaultEncrypterImpl = (MatchableEncrypter)cls.newInstance();
            }
            catch (Exception e) {
                throw new EncryptException("can't find implement class for interface kd.bos.encrypt.Encrypter", e);
            }
        } else {
            log.info("custom default class from extension is :" + defaultEncrypterImpl.getClass().getName());
        }
        String all = System.getProperty(ALL_ENCRYPTER, HAS_ALL_ENCRYPTER);
        EncrypterFactory.loadAllEncrypter(all);
        instance = new SmartEncrypter(defaultEncrypterImpl, allEncrypterImpls);
        aesInstance = new AESEncrypterImpl();
        random = new SecureRandom();
    }
}

