/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.impl;

import java.security.SecureRandom;

public class EncrypterUtil {
    private static final String SOURCES = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";

    public static String byte2hex(byte[] inStr) {
        StringBuilder out2 = new StringBuilder(inStr.length * 2);
        for (int n = 0; n < inStr.length; ++n) {
            String stmp = Integer.toHexString(inStr[n] & 0xFF);
            if (stmp.length() == 1) {
                out2.append("0" + stmp);
                continue;
            }
            out2.append(stmp);
        }
        return out2.toString();
    }

    public static byte[] hex2Bytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(EncrypterUtil.charToByte(hexChars[pos]) << 4 | EncrypterUtil.charToByte(hexChars[pos + 1]) & 0xFF);
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    public static String generateString(SecureRandom random, int length) {
        char[] text = new char[length];
        for (int i = 0; i < length; ++i) {
            text[i] = SOURCES.charAt(random.nextInt(SOURCES.length()));
        }
        return new String(text);
    }

    public static byte[] byteMerge(byte[] addByte, byte[] bodyByte) {
        int length = bodyByte.length + addByte.length;
        byte[] resutlByte = new byte[length];
        for (int i = 0; i < length; ++i) {
            resutlByte[i] = i < addByte.length ? addByte[i] : bodyByte[i - addByte.length];
        }
        return resutlByte;
    }
}

