/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.impl;

import com.google.common.base.Charsets;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import kd.bos.encrypt.core.PrefixMatchableEncrypter;
import kd.bos.encrypt.impl.EncrypterUtil;

public class NPEncrypter
extends PrefixMatchableEncrypter {
    private static final int NUMBERLENGTH = 128;
    private static final int MAXNUMBERLENGTH = 4096;

    public NPEncrypter() {
        super("N$P&E:");
    }

    @Override
    protected String decode0(String str) {
        String encodeStr = str.substring(16, str.indexOf("+"));
        byte[] bytes = EncrypterUtil.hex2Bytes(encodeStr);
        byte[] keyByte = "LmMGStGtOpF4xNyvYt54EQ==".getBytes();
        byte[] resutlByte = new byte[bytes.length - keyByte.length];
        for (int i = 0; i < resutlByte.length; ++i) {
            resutlByte[i] = bytes[i + keyByte.length];
        }
        return new String(resutlByte, Charsets.UTF_8);
    }

    @Override
    protected String encode0(String str) {
        int currentlength;
        byte[] strByte = str.getBytes(Charsets.UTF_8);
        byte[] keyByte = "LmMGStGtOpF4xNyvYt54EQ==".getBytes();
        byte[] newbyte = EncrypterUtil.byteMerge(keyByte, strByte);
        String encodeStr = EncrypterUtil.byte2hex(newbyte);
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append(random.nextInt(10));
        }
        encodeStr = sb.toString() + encodeStr + "+";
        int encodeStrlength = encodeStr.length();
        if (encodeStrlength > 4096) {
            throw new RuntimeException("the encrypt string [length:" + encodeStrlength + "] is to large,please use default option");
        }
        for (currentlength = 128; currentlength < encodeStrlength; currentlength *= 2) {
        }
        return encodeStr + EncrypterUtil.generateString(random, currentlength - encodeStrlength);
    }

    @Override
    protected boolean checkEncrypt(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        int strlength = str.length();
        if ((strlength == 128 || strlength / 128 % 2 == 0 && 4096 % strlength == 0) && str.indexOf("+") > 0) {
            String prefix = str.substring(0, 16);
            boolean isInt = Pattern.compile("^-?[0-9]\\d*$").matcher(prefix).find();
            if (isInt) {
                return true;
            }
        }
        return false;
    }
}

