/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.key;

import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.encrypt.key.EncryptKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptKeyFactory {
    private static final String KEY_MANAGER_CLASSNAME = "kd.bos.encrypt.keyManager";
    private static final String DEFAULT_KEY_MANAGER = "kd.bos.encrypt.key.MCEncryptKeyManagerImpl";
    private static final Logger log = LoggerFactory.getLogger(EncrypterFactory.class);
    private static EncryptKeyManager instance = null;

    public static EncryptKeyManager getEncrypterKeyManager() {
        return instance;
    }

    static {
        String className = System.getProperty(KEY_MANAGER_CLASSNAME, DEFAULT_KEY_MANAGER);
        try {
            Class<?> cls = Class.forName(className);
            instance = (EncryptKeyManager)cls.newInstance();
        }
        catch (Exception e) {
            String msg = "can't find implement class for interface kd.bos.encrypt.keyManager ";
            log.error(msg, (Throwable)e);
            throw new EncryptException(msg, e);
        }
    }
}

