/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.sm4;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.key.EncryptKeyFactory;
import kd.bos.encrypt.sm4.SM4;
import kd.bos.encrypt.sm4.SM4Context;
import kd.bos.encrypt.sm4.SM4Encrypter;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Base64;
import sun.misc.BASE64Encoder;

public class SM4EncrypterImpl
implements SM4Encrypter {
    private static final Object LOCKER = new Object();
    private static final Object LOCKER2 = new Object();
    private static final String SM4_DEFAULT_LENGTH = "128";
    private static final String SM4_KEY_LENGTH = "kd.bos.encrypt.keyLength";
    private static final String SM4_CIPHER_ALGORITHM = "kd.bos.encrypt.sm4Algorithm";
    private static final String DEFAULT_CIPHER_ALGORITHM = "CBC";
    private byte[] keyBytesFromCache;
    private byte[] ivBytesFromCache;
    private String sm4CipherAlgorithm = "CBC";
    private SM4 cipher = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SM4 getCipherInstance() {
        if (this.cipher == null) {
            Object object = LOCKER;
            synchronized (object) {
                if (this.cipher == null) {
                    this.initCipher();
                }
            }
        }
        return this.cipher;
    }

    private void initCipher() {
        boolean isZkReaded;
        boolean bl = isZkReaded = StringUtils.isNotEmpty(System.getProperty("kd.bos.encrypt.encryptKey")) || StringUtils.isNotEmpty(System.getProperty("redis.serversForSession"));
        if (isZkReaded) {
            try {
                this.sm4CipherAlgorithm = System.getProperty(SM4_CIPHER_ALGORITHM, DEFAULT_CIPHER_ALGORITHM);
                this.cipher = new SM4();
            }
            catch (Exception ex) {
                throw new EncryptException("Failed to create SM4Encrypt because the cipher initialization is failed, reason:", ex);
            }
        } else {
            throw new EncryptException("cannot init SM4Encrypt, because the SM4_KEY[MC-Key:kd.bos.encrypt.encryptKey]from zookeeper) is still null.");
        }
    }

    private byte[] getSM4Key() {
        if (this.keyBytesFromCache != null) {
            return this.keyBytesFromCache;
        }
        String sm4Key = EncryptKeyFactory.getEncrypterKeyManager().getEncryptKey();
        String sm4KeyLengthFromZK = System.getProperty(SM4_KEY_LENGTH, SM4_DEFAULT_LENGTH);
        int sm4KeyLength = Integer.parseInt(sm4KeyLengthFromZK);
        if (StringUtils.isNotEmpty(sm4Key)) {
            byte[] key = this.getSM4KeyFromString(sm4Key, sm4KeyLength);
            this.keyBytesFromCache = key;
            String sm4IvKey = EncryptKeyFactory.getEncrypterKeyManager().getEncryptIvKey();
            byte[] iv = this.getSM4KeyFromString(sm4IvKey, sm4KeyLength);
            this.ivBytesFromCache = iv;
            return key;
        }
        throw new EncryptException("get encrypt key failed(encrypt key cannot be empty)");
    }

    @Override
    public String encrypt(String originalStr) throws EncryptException {
        try {
            byte[] key = this.getSM4Key();
            return this.encrypt(originalStr, key, this.ivBytesFromCache);
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    @Override
    public String decrypt(String encryptStr) throws EncryptException {
        try {
            byte[] key = this.getSM4Key();
            return this.decrypt(encryptStr, key, this.ivBytesFromCache);
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    @Override
    public String encrypt(String originalStr, String sm4Key, int length) throws EncryptException {
        try {
            byte[] key = this.getSM4KeyFromString(sm4Key, length);
            return this.encrypt(originalStr, key, key);
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    @Override
    public String decrypt(String encryptStr, String sm4Key, int length) throws EncryptException {
        try {
            byte[] key = this.getSM4KeyFromString(sm4Key, length);
            return this.decrypt(encryptStr, key, key);
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getSM4KeyFromBuiltinResource(int length) {
        try (InputStream in = this.getClass().getResourceAsStream("/kd/bos/aes/aeskey.txt");){
            byte[] key;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String str = br.readLine();
            byte[] byArray = key = this.getSM4KeyFromString(str, length);
            return byArray;
        }
        catch (IOException e) {
            throw new EncryptException(e);
        }
    }

    private byte[] getSM4KeyFromString(String str, int length) throws EncryptException {
        if (str == null || str.length() < length / 8) {
            throw new EncryptException("The given SM4 key or iv is too short.");
        }
        try {
            byte[] keys = str.substring(0, length / 8).getBytes(Charsets.UTF_8);
            return keys;
        }
        catch (Exception ex) {
            throw new EncryptException("An error has occurred when getting SM4 key:" + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encrypt(String originalStr, byte[] sm4Key, byte[] ivBytes) throws IOException {
        if (originalStr == null) {
            return null;
        }
        SM4Context ctx = new SM4Context();
        ctx.isPadding = true;
        ctx.mode = 1;
        SM4 sm4 = this.getCipherInstance();
        Object object = LOCKER2;
        synchronized (object) {
            sm4.sm4_setkey_enc(ctx, sm4Key);
            byte[] encrypted = this.sm4CipherAlgorithm.equals("ECB") ? sm4.sm4_crypt_ecb(ctx, originalStr.getBytes("UTF-8")) : sm4.sm4_crypt_cbc(ctx, ivBytes, originalStr.getBytes("UTF-8"));
            BASE64Encoder encoder = new BASE64Encoder();
            return encoder.encode(encrypted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String decrypt(String encryptStr, byte[] sm4Key, byte[] ivBytes) throws IOException {
        if (encryptStr == null) {
            return null;
        }
        String cipherText = encryptStr;
        SM4Context ctx = new SM4Context();
        ctx.isPadding = true;
        ctx.mode = 0;
        SM4 sm4 = this.getCipherInstance();
        Object object = LOCKER2;
        synchronized (object) {
            sm4.sm4_setkey_dec(ctx, sm4Key);
            byte[] decrypted = this.sm4CipherAlgorithm.equals("ECB") ? sm4.sm4_crypt_ecb(ctx, Base64.decodeBase64((String)cipherText)) : sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decodeBase64((String)cipherText));
            return new String(decrypted, "UTF-8");
        }
    }
}

