/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.env;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kd.bos.env.EnvContext;
import kd.bos.util.ThreadLocals;

class EnvContextImpl
implements EnvContext {
    static EnvContext instance = new EnvContextImpl(false);
    static EnvContext thread = new EnvContextImpl(true);
    private final Supplier<Map<String, Object>> sp;

    public EnvContextImpl(boolean threadable) {
        if (threadable) {
            ThreadLocal<HashMap> th = ThreadLocals.create(() -> new HashMap());
            this.sp = () -> (HashMap)th.get();
        } else {
            this.sp = () -> new ConcurrentHashMap();
        }
    }

    @Override
    public <T> void set(String key, T value) {
        this.sp.get().put(key, value);
    }

    @Override
    public boolean exists(String key) {
        return this.sp.get().containsKey(key);
    }

    @Override
    public void remove(String key) {
        this.sp.get().remove(key);
    }

    @Override
    public void clear() {
        this.sp.get().clear();
    }

    @Override
    public <T> T get(String key) {
        return (T)this.sp.get().get(key);
    }

    @Override
    public <T> T get(String key, T defaultValue) {
        return (T)this.sp.get().getOrDefault(key, defaultValue);
    }

    @Override
    public Set<String> keys() {
        return Collections.unmodifiableSet(this.sp.get().keySet());
    }

    @Override
    public int size() {
        return this.sp.get().size();
    }
}

