/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.extension;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.extension.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionFactory<T> {
    private static final Logger log = LoggerFactory.getLogger(ExtensionFactory.class);
    private static final String EXTENSION_DIRECTORY = "META-INF/kd/bos/extension/";
    private static final ConcurrentMap<Class<?>, ExtensionFactory<?>> EXTENSION_FACTORYS = new ConcurrentHashMap();
    private Class<?> type;
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap();

    private ExtensionFactory() {
    }

    private ExtensionFactory(Class<?> type) {
        this.type = type;
    }

    public static <T> ExtensionFactory<T> getExtensionFacotry(Class<T> type) {
        ExtensionFactory factory = (ExtensionFactory)EXTENSION_FACTORYS.get(type);
        if (factory == null) {
            EXTENSION_FACTORYS.putIfAbsent(type, new ExtensionFactory<T>(type));
            factory = (ExtensionFactory)EXTENSION_FACTORYS.get(type);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name) {
        Object instance;
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            this.cachedInstances.putIfAbsent(name, new Holder());
            holder = (Holder)this.cachedInstances.get(name);
        }
        if ((instance = holder.get()) == null) {
            Holder holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name);
                    holder.set(instance);
                }
            }
        }
        if (holder != null) {
            return holder.get();
        }
        return null;
    }

    public T getExtension(String name, boolean fromCache) {
        if (fromCache) {
            return this.getExtension(name);
        }
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new RuntimeException("can't find class for name " + name);
        }
        try {
            return (T)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    public boolean existsExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        return clazz != null;
    }

    private T createExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new RuntimeException("can't find class for extention " + this.type.getName() + "/" + name);
        }
        try {
            Object instance = EXTENSION_INSTANCES.get(clazz);
            if (instance == null) {
                EXTENSION_INSTANCES.putIfAbsent(clazz, clazz.newInstance());
                instance = EXTENSION_INSTANCES.get(clazz);
            }
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = this.cachedClasses.get();
        if (classes == null) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.get();
                if (classes == null) {
                    classes = this.loadExtensionClasses();
                    this.cachedClasses.set(classes);
                }
            }
        }
        return classes;
    }

    private Map<String, Class<?>> loadExtensionClasses() {
        HashMap extensionClasses = new HashMap();
        this.loadFile(extensionClasses, EXTENSION_DIRECTORY);
        return extensionClasses;
    }

    private static ClassLoader findClassLoader() {
        return ExtensionFactory.class.getClassLoader();
    }

    private void loadFile(Map<String, Class<?>> extensionClasses, String dir) {
        String fileName = dir + this.type.getName();
        try {
            ClassLoader classLoader = ExtensionFactory.findClassLoader();
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    log.info("load extension class from " + url);
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            int ci = line.indexOf(35);
                            if (ci >= 0 || (line = line.trim()).length() <= 0) continue;
                            String name = null;
                            int i = line.indexOf(61);
                            if (i > 0) {
                                name = line.substring(0, i).trim();
                                line = line.substring(i + 1).trim();
                            }
                            if (line.length() <= 0) continue;
                            Class<?> clazz = Class.forName(line, true, classLoader);
                            Class<?> c = extensionClasses.get(name);
                            if (c == null) {
                                extensionClasses.put(name, clazz);
                                continue;
                            }
                            if (c == clazz) continue;
                            throw new IllegalStateException("Duplicate extension " + this.type.getName() + " name " + name + " on " + c.getName() + " and " + clazz.getName());
                        }
                    }
                    catch (Throwable t) {
                        log.error("Exception when load extension class(interface: " + this.type + ", class file: " + url + ") in " + url + ", message:" + t.getMessage(), t);
                    }
                }
            }
        }
        catch (Throwable t) {
            log.error("Exception when load extension class(interface: " + this.type + ", description file: " + fileName + ").", t);
        }
    }
}

