/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.thread;

import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ForwardingExecutorService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.thread.ArchiveRouteAutoContext;
import kd.bos.thread.ManagedThreadFeature;
import kd.bos.thread.ThreadContextWrapBuilder;
import kd.bos.thread.ThreadLifeCycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLifeCycleManager {
    private static final Logger log = LoggerFactory.getLogger(ThreadLifeCycleManager.class);
    private static final int MAX = 100;
    private static ConcurrentHashMap<ThreadLifeCycleListener, OrderedListener> listenerMap = new ConcurrentHashMap();
    private static final ThreadContextWrapBuilder CONTEXT_WRAP_BUILDER = ThreadLifeCycleManager.createBuilder();
    private static final String CONTEXT_WARP_BUILDER_CLASS_NAME = "kd.bos.threads.impl.ThreadContextWrapBuilderImpl";

    public static void addListener(ThreadLifeCycleListener l) {
        ThreadLifeCycleManager.addListener(l, 0);
    }

    public static void addListener(ThreadLifeCycleListener l, int order) {
        if (!listenerMap.contains(l)) {
            if (listenerMap.size() < 100) {
                listenerMap.put(l, new OrderedListener(order, l));
            } else {
                RuntimeException ex = new RuntimeException("Leak!!!");
                throw ex;
            }
        }
    }

    public static void removeListener(ThreadLifeCycleListener l) {
        listenerMap.remove(l);
    }

    public static void start() {
        Ordering.natural().sortedCopy(listenerMap.values()).forEach(l -> {
            try {
                ((OrderedListener)l).listener.start();
            }
            catch (Exception t) {
                log.error(t.getMessage());
            }
        });
    }

    public static void end() {
        Ordering.natural().sortedCopy(listenerMap.values()).forEach(l -> {
            try {
                ((OrderedListener)l).listener.end();
            }
            catch (Exception t) {
                log.error(t.getMessage());
            }
        });
    }

    public static TimerTask wrapTimerTask(Runnable timerTask) {
        if (timerTask instanceof TimerTaskWrap) {
            return (TimerTask)timerTask;
        }
        timerTask = CONTEXT_WRAP_BUILDER.build(timerTask);
        return new TimerTaskWrap(timerTask);
    }

    public static <T> Callable<T> wrapCallable(Callable<T> callable) {
        if (callable instanceof CallableWrap) {
            return callable;
        }
        callable = CONTEXT_WRAP_BUILDER.build(callable);
        return new CallableWrap<T>(callable);
    }

    private static ThreadContextWrapBuilder createBuilder() {
        try {
            return (ThreadContextWrapBuilder)Class.forName(CONTEXT_WARP_BUILDER_CLASS_NAME).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Init threadPool's context builder fail.msg: " + e.getMessage(), e);
        }
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        if (runnable instanceof RunnableWrap) {
            return runnable;
        }
        runnable = CONTEXT_WRAP_BUILDER.build(runnable);
        return new RunnableWrap(runnable);
    }

    public static ExecutorService wrapExecutorService(ExecutorService pool) {
        return new ExecutorServiceWrap(pool);
    }

    static {
        ThreadLifeCycleManager.addListener(new ManagedThreadFeature(), Integer.MAX_VALUE);
    }

    private static class RunnableWrap
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = -4002842778413363332L;
        private Runnable runnable;
        private ArchiveRouteAutoContext arCtx;

        public RunnableWrap(Runnable runnable) {
            if (runnable instanceof RunnableWrap) {
                throw new IllegalArgumentException("RunnableWrap shouldn't be wrap again.");
            }
            this.runnable = runnable;
            this.arCtx = ArchiveRouteAutoContext.create();
        }

        @Override
        public void run() {
            try {
                ThreadLifeCycleManager.start();
                this.runnable.run();
            }
            finally {
                this.arCtx.close();
                ThreadLifeCycleManager.end();
            }
        }
    }

    private static class CallableWrap<T>
    implements Callable<T>,
    Serializable {
        private static final long serialVersionUID = 4135018730909737867L;
        private Callable<T> callable;
        private ArchiveRouteAutoContext arCtx;

        public CallableWrap(Callable<T> callable) {
            this.callable = callable;
            this.arCtx = ArchiveRouteAutoContext.create();
        }

        @Override
        public T call() throws Exception {
            try {
                ThreadLifeCycleManager.start();
                T t = this.callable.call();
                return t;
            }
            finally {
                this.arCtx.close();
                ThreadLifeCycleManager.end();
            }
        }
    }

    private static class TimerTaskWrap
    extends TimerTask
    implements Serializable {
        private static final long serialVersionUID = -4002842777413363332L;
        private Runnable runnable;
        private ArchiveRouteAutoContext arCtx;

        public TimerTaskWrap(Runnable runnable) {
            if (runnable instanceof TimerTaskWrap) {
                throw new IllegalArgumentException("TimerTaskWrap shouldn't be wrap again.");
            }
            this.runnable = runnable;
            this.arCtx = ArchiveRouteAutoContext.create();
        }

        @Override
        public void run() {
            try {
                ThreadLifeCycleManager.start();
                this.runnable.run();
            }
            finally {
                this.arCtx.close();
                ThreadLifeCycleManager.end();
            }
        }
    }

    private static class ExecutorServiceWrap
    extends ForwardingExecutorService {
        private ExecutorService delegateService;

        public ExecutorServiceWrap(ExecutorService delegate) {
            this.delegateService = delegate;
        }

        protected ExecutorService delegate() {
            return this.delegateService;
        }

        private static <T> Collection<? extends Callable<T>> wrapCallableCollection(Collection<? extends Callable<T>> tasks) {
            ArrayList result = new ArrayList();
            tasks.forEach(task -> result.add(ThreadLifeCycleManager.wrapCallable(task)));
            return result;
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return super.invokeAll(ExecutorServiceWrap.wrapCallableCollection(tasks));
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return super.invokeAll(ExecutorServiceWrap.wrapCallableCollection(tasks), timeout, unit);
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return (T)super.invokeAny(ExecutorServiceWrap.wrapCallableCollection(tasks));
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)super.invokeAny(ExecutorServiceWrap.wrapCallableCollection(tasks), timeout, unit);
        }

        public void execute(Runnable command) {
            super.execute(ThreadLifeCycleManager.wrapRunnable(command));
        }

        public <T> Future<T> submit(Callable<T> task) {
            return super.submit(ThreadLifeCycleManager.wrapCallable(task));
        }

        public Future<?> submit(Runnable task) {
            return super.submit(ThreadLifeCycleManager.wrapRunnable(task));
        }

        public <T> Future<T> submit(Runnable task, T result) {
            return super.submit(ThreadLifeCycleManager.wrapRunnable(task), result);
        }
    }

    private static class OrderedListener
    implements Comparable<OrderedListener> {
        private ThreadLifeCycleListener listener;
        private int order;

        public OrderedListener(int order, ThreadLifeCycleListener listener) {
            this.order = order;
            this.listener = listener;
        }

        @Override
        public int compareTo(OrderedListener o) {
            return this.order - o.order;
        }
    }
}

