/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.thread;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalUtils {
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalUtils.class);
    private static HashSet<String> excludes = new HashSet();
    private static Method removeOfThreadLocalMap;
    private static Map<String, Field> fieldMap;

    public static void clearCurrentThreadLocals() {
        ThreadLocalUtils.clearThreadLocals(Thread.currentThread());
    }

    /*
     * WARNING - void declaration
     */
    public static void clearThreadLocals(Thread t) {
        void var6_8;
        Object threadLocals = ThreadLocalUtils.getFieldValue("threadLocals", t);
        Object[] tables = (Object[])ThreadLocalUtils.getFieldValue("table", threadLocals);
        if (null == tables) {
            return;
        }
        ArrayList<Object> toRemove = new ArrayList<Object>();
        Object[] objectArray = tables;
        int n = objectArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            Object entry = objectArray[var6_8];
            Object value = ThreadLocalUtils.getFieldValue("value", entry);
            if (null != value && ThreadLocalUtils.shouldClose(value)) {
                try {
                    ThreadLocalUtils.close(value);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                Object threadLocal = ThreadLocalUtils.getFieldValue("referent", entry);
                if (threadLocal != null) {
                    toRemove.add(threadLocal);
                }
            }
            ++var6_8;
        }
        Method method = ThreadLocalUtils.getRemoveMethod(threadLocals);
        for (Object e : toRemove) {
            try {
                method.invoke(threadLocals, e);
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    private static boolean shouldClose(Object value) {
        return !excludes.contains(value.getClass().getName());
    }

    private static void close(Object value) throws Exception {
        if (value instanceof AutoCloseable) {
            ((AutoCloseable)value).close();
        }
    }

    private static Method getRemoveMethod(Object obj) {
        if (removeOfThreadLocalMap == null) {
            for (Method method : obj.getClass().getDeclaredMethods()) {
                if (!method.getName().equals("remove")) continue;
                removeOfThreadLocalMap = method;
                method.setAccessible(true);
                return removeOfThreadLocalMap;
            }
        }
        return removeOfThreadLocalMap;
    }

    private static Object getFieldValue(String filedName, Object obj) {
        if (null == obj) {
            return null;
        }
        String filedKey = obj.getClass().getName() + filedName;
        Field field = null;
        if (fieldMap.containsKey(filedKey)) {
            field = fieldMap.get(filedKey);
        } else {
            for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(filedName);
                    break;
                }
                catch (Exception e) {
                    log.debug(e.getMessage());
                    continue;
                }
            }
            if (field == null) {
                return null;
            }
            fieldMap.put(filedKey, field);
        }
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            throw new IllegalStateException("get filed exception :" + e);
        }
    }

    private static void setFiledValue(String filedName, Object obj, Object value) {
        if (null == obj) {
            return;
        }
        String filedKey = obj.getClass().getName() + filedName;
        Field field = null;
        if (fieldMap.containsKey(filedKey)) {
            field = fieldMap.get(filedKey);
        } else {
            for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(filedName);
                    break;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    continue;
                }
            }
            fieldMap.put(filedKey, field);
        }
        if (field == null) {
            return;
        }
        field.setAccessible(true);
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("set filed exception :" + e);
        }
    }

    public static Object getThreadLocalMap(Thread t) {
        return ThreadLocalUtils.getFieldValue("threadLocals", t);
    }

    public static void setThreadLocalMap(Thread t, Object o) {
        ThreadLocalUtils.setFiledValue("threadLocals", t, o);
    }

    public static Object getThreadLocalValue(Thread t, ThreadLocal<?> threadlocal) {
        Object threadLocals = ThreadLocalUtils.getFieldValue("threadLocals", t);
        Object[] tables = (Object[])ThreadLocalUtils.getFieldValue("table", threadLocals);
        if (null == tables) {
            return null;
        }
        for (Object o : tables) {
            Object threadLocalFiled = ThreadLocalUtils.getFieldValue("referent", o);
            if (threadLocalFiled != threadlocal) continue;
            Object value = ThreadLocalUtils.getFieldValue("value", o);
            return value;
        }
        return null;
    }

    public static void main(String[] args) {
        ThreadLocal<Integer> localInteger = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return -1;
            }
        };
        ThreadLocal<AutoCloseable> localClose = new ThreadLocal<AutoCloseable>(){

            @Override
            protected AutoCloseable initialValue() {
                return new AutoCloseable(){

                    @Override
                    public void close() throws Exception {
                    }

                    public String toString() {
                        return "toString initial";
                    }
                };
            }
        };
        localInteger.set(10);
        localClose.set(new AutoCloseable(){

            @Override
            public void close() throws Exception {
            }

            public String toString() {
                return "toString 1";
            }
        });
        long t1 = System.nanoTime();
        ThreadLocalUtils.clearCurrentThreadLocals();
        long t2 = System.nanoTime();
        t1 = System.nanoTime();
        ThreadLocalUtils.clearCurrentThreadLocals();
        t2 = System.nanoTime();
        t1 = System.nanoTime();
        localInteger.get();
        localClose.get();
        ThreadLocalUtils.clearCurrentThreadLocals();
        t2 = System.nanoTime();
    }

    static {
        excludes.add("org.eclipse.jetty.server.HttpConnection");
        removeOfThreadLocalMap = null;
        fieldMap = new ConcurrentHashMap<String, Field>();
    }
}

