/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import com.google.common.base.Charsets;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtils {
    public static final String KEY_ALGORITHM = "AES";
    public static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        Key k = AESUtils.toKey(key);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, k);
        return cipher.doFinal(data);
    }

    public static String decrypt(String dataString, String keyString) throws Exception {
        String returnValue = null;
        if (StringUtils.isEmpty(dataString) || StringUtils.isEmpty(keyString)) {
            return returnValue;
        }
        byte[] key = AESUtils.getBase64DecodeKey(keyString);
        byte[] data = Base64.decodeBase64((String)dataString);
        return new String(AESUtils.decrypt(data, key));
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Key k = AESUtils.toKey(key);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static String encrypt(String dataString, String keyString) throws Exception {
        if (StringUtils.isEmpty(dataString) || StringUtils.isEmpty(keyString)) {
            return null;
        }
        byte[] data = dataString.getBytes(Charsets.UTF_8);
        byte[] key = AESUtils.getBase64DecodeKey(keyString);
        return new String(Base64.encodeBase64String((byte[])AESUtils.encrypt(data, key)));
    }

    public static byte[] initkey() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        kg.init(128);
        SecretKey secretKey = kg.generateKey();
        return secretKey.getEncoded();
    }

    public static String getBase64EncodeKey() throws Exception {
        byte[] keys = AESUtils.initkey();
        return Base64.encodeBase64String((byte[])keys);
    }

    public static byte[] getBase64DecodeKey(String base64) throws Exception {
        byte[] returnValue = null;
        if (StringUtils.isNotEmpty(base64)) {
            returnValue = Base64.decodeBase64((String)base64);
        }
        return returnValue;
    }

    public static Key toKey(byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
        return secretKey;
    }
}

