/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class FileNameUtils {
    public static final String FMT_PATH_EXPORT = "/%s/%s/%s/%s/%s/%s";
    public static final String FMT_PATH = "/%s/%s/%s/%s/%s/%s/%s/%s";
    public static final String FMT_ATT_PATH = "/%s/%s/%s/%s/%s";
    public static final String FMT_MONTH = "%s-%s";
    public static final String PATH_VERSION = "?v=1";
    public static final String TYPE_ATTACHMENT = "attachments";
    public static final String TYPE_IMAGE = "images";
    public static final String TYPE_RICH_RESOURCES = "rich_resources";

    private FileNameUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getAttachmentFileName(String tenantId, String accountId, String appId, String formId, Object pkId, String filename) {
        return FileNameUtils.getFileName(tenantId, accountId, appId, formId, pkId, TYPE_ATTACHMENT, filename);
    }

    public static String getAttachmentFileName(String tenantId, String accountId, Object AttPk, String filename) {
        return FileNameUtils.getAttachmentName(tenantId, accountId, AttPk, TYPE_ATTACHMENT, filename);
    }

    public static String getBillImageFileName(String tenantId, String accountId, String entityNumber, String fileName) {
        return String.format(FMT_ATT_PATH, tenantId, accountId, "bill", entityNumber, fileName);
    }

    public static String getRptImageFileName(String tenantId, String accountId, String entityNumber, String fileName) {
        return String.format(FMT_ATT_PATH, tenantId, accountId, "rpt", entityNumber, fileName);
    }

    public static String getImageAttFileName(String tenantId, String accountId, String entityNumber, Object pkId, String fileName) {
        return String.format(FMT_PATH_EXPORT, tenantId, accountId, "doc", entityNumber, String.valueOf(pkId), fileName);
    }

    public static String getImageFileName(String tenantId, String accountId, String appId, String formId, Object pkId, String filename) {
        return FileNameUtils.getFileName(tenantId, accountId, appId, formId, pkId, TYPE_IMAGE, filename);
    }

    public static String getRichTextResource(String tenantId, String accountId, String appId, String formId, Object pkId, String filename) {
        return FileNameUtils.getFileName(tenantId, accountId, appId, formId, pkId, TYPE_RICH_RESOURCES, filename);
    }

    static String getFileName(String tenantId, String accountId, String appId, String formId, Object pkId, String type, String filename) {
        String monthStr = FileNameUtils.getMonthStr();
        return String.format(FMT_PATH, tenantId, accountId, monthStr, appId, formId, pkId, type, filename);
    }

    static String getAttachmentName(String tenantId, String accountId, Object attPk, String type, String fileName) {
        String monthStr = FileNameUtils.getMonthStr();
        return String.format(FMT_ATT_PATH, tenantId, accountId, monthStr, String.valueOf(attPk), fileName);
    }

    public static String getExportFileName(String tenantId, String accountId, String appId, String tag, String filename) {
        String dateStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        return String.format(FMT_PATH_EXPORT, tenantId, accountId, dateStr, appId, tag, filename);
    }

    public static String getExportFolderName(String tenantId, String accountId, String appId, String tag, String filename) {
        String dateStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        return String.format(FMT_PATH_EXPORT, tenantId, accountId, dateStr, appId, tag, filename);
    }

    static String getMonthStr() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
        String monthStr = sf.format(cale.getTime());
        return monthStr;
    }
}

