/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtils {
    private static ArrayList<MBeanServer> mbservers;
    private static Logger logger;
    private static Map<String, ObjectName> objectNames;

    private static void init() {
        mbservers = MBeanServerFactory.findMBeanServer(null);
    }

    public static Object getAtt(String objectName, String attributeName) {
        return JmxUtils.getAtt(objectName, attributeName, true);
    }

    public static Object getAtt(String objectName, String attributeName, boolean log) {
        for (MBeanServer mbserver : mbservers) {
            try {
                ObjectName on;
                if (objectNames.containsKey(objectName)) {
                    on = objectNames.get(objectName);
                } else {
                    on = new ObjectName(objectName);
                    objectNames.put(objectName, on);
                }
                Object o = mbserver.getAttribute(on, attributeName);
                return o;
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
                if (!log) continue;
                logger.warn("mbean get getAtt error " + objectName + "  " + attributeName, (Throwable)e);
            }
        }
        return null;
    }

    public static Object getAtt(String objectName, String attributeName, String path) {
        Object o = JmxUtils.getAtt(objectName, attributeName);
        if (o instanceof CompositeDataSupport) {
            return ((CompositeDataSupport)o).get(path);
        }
        return o;
    }

    static {
        logger = LoggerFactory.getLogger(JmxUtils.class);
        JmxUtils.init();
        objectNames = new ConcurrentHashMap<String, ObjectName>();
    }
}

