/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kd.bos.util.EncryptUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordEncryptUtil {
    private static Logger LOG = LoggerFactory.getLogger(PasswordEncryptUtil.class);
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int SALT_BYTE_SIZE = 16;
    public static final int HASH_BIT_SIZE = 512;
    public static final int PBKDF2_ITERATIONS = 1000;
    private static final int PASSWORD_CHECK_LENGTH = 160;

    public static boolean authenticate(String attemptedPassword, String encryptedPassword, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String encryptedAttemptedPassword = PasswordEncryptUtil.getEncryptedPassword(attemptedPassword, salt);
        return encryptedAttemptedPassword.equals(encryptedPassword);
    }

    public static String getEncryptedPassword(String password, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), PasswordEncryptUtil.fromHex(salt), 1000, 512);
        SecretKeyFactory f = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
        return PasswordEncryptUtil.toHex(f.generateSecret(spec).getEncoded());
    }

    public static String generateSalt() throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return PasswordEncryptUtil.toHex(salt);
    }

    private static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }

    private static String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    public static String getEncryptePasswordWithSalt(String password) {
        String returnPass = "";
        try {
            String salt = PasswordEncryptUtil.generateSalt();
            String ciphertext = PasswordEncryptUtil.getEncryptedPassword(password, salt);
            returnPass = ciphertext + salt;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            LOG.error(e.getMessage());
        }
        return returnPass;
    }

    public static boolean authenticate(String oldPassword, String newPassword) {
        boolean passed = false;
        if (oldPassword != null && oldPassword.length() >= 160) {
            try {
                String salt = PasswordEncryptUtil.getSalt(oldPassword);
                String encrytedString = PasswordEncryptUtil.getEncryptedString(oldPassword, salt);
                String ciphertext = PasswordEncryptUtil.getEncryptedPassword(newPassword, salt);
                passed = encrytedString.equals(ciphertext);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error(e.getMessage());
            }
            catch (InvalidKeySpecException e) {
                LOG.error(e.getMessage());
            }
        }
        return passed;
    }

    private static String getEncryptedString(String oldPassword, String salt) {
        String returnValue = "";
        if (oldPassword != null && salt != null) {
            returnValue = oldPassword.replace(salt, "");
        }
        return returnValue;
    }

    private static String getSalt(String oldPassword) {
        String salt = "";
        if (oldPassword != null && oldPassword.length() >= 160) {
            salt = oldPassword.substring(oldPassword.length() - 32, oldPassword.length());
        }
        return salt;
    }

    public static boolean checkPassword(String password, String oldPassword) {
        boolean passed = false;
        if (password != null && oldPassword != null) {
            if (PasswordEncryptUtil.authenticate(oldPassword, password)) {
                passed = true;
            }
            if (!passed && oldPassword.equals(EncryptUtils.encryptPSW(password))) {
                passed = true;
            }
        }
        return passed;
    }
}

