/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.util.StringUtils;

public class PropertiesUtil {
    private static Map<String, String> constants = new HashMap<String, String>();
    private static Map<String, String> appIdNames = new HashMap<String, String>();
    private static boolean initConstant = false;
    private static boolean initAppId = false;

    public static String getConstant(String key) {
        try {
            if (!initConstant) {
                initConstant = true;
                Properties properties = new Properties();
                properties.load(PropertiesUtil.class.getResourceAsStream("/resources/constant.properties"));
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    String value = properties.getProperty(name);
                    constants.put(name, value);
                }
            }
            return constants.get(key);
        }
        catch (Exception var5) {
            throw new RuntimeException("can't found constant.properties");
        }
    }

    public static String getAppIdName(String appId) {
        try {
            if (!initAppId) {
                initAppId = true;
                Properties properties = new Properties();
                properties.load(new InputStreamReader(PropertiesUtil.class.getResourceAsStream("/resources/appid.properties"), "UTF-8"));
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    String value = properties.getProperty(name);
                    appIdNames.put(name.toLowerCase(), value);
                }
            }
            if (StringUtils.isNotEmpty(appId)) {
                appId = appId.toLowerCase();
            }
            return appIdNames.get(appId);
        }
        catch (Exception var5) {
            throw new RuntimeException("can't found appid.properties");
        }
    }
}

