/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.Resources;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class SmsUtils {
    public static void sendSmsMessage(String phone, String message, Map<String, String> smsConfig) throws IOException {
        HttpResponse response;
        String portString;
        if (StringUtils.isEmpty(phone) || phone.length() < 11) {
            return;
        }
        String smsApiUrl = smsConfig.get("apiUrl");
        String clientID = smsConfig.get("clientID");
        String clientSecret = smsConfig.get("clientPwd");
        String smsCode = smsConfig.get("smsCode");
        String signature = smsConfig.get("signature");
        String countryCode = smsConfig.get("countryCode");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientID);
        params.put("client_secret", clientSecret);
        params.put("phone", phone);
        params.put("smscode", smsCode);
        params.put("content", message);
        params.put("signature", signature);
        params.put("country_code", countryCode);
        String encoding = "UTF-8";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(smsApiUrl);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(10);
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                value = "";
            }
            BasicNameValuePair pair = new BasicNameValuePair(name, value);
            parameters.add(pair);
        }
        UrlEncodedFormEntity encodedFormEntity = new UrlEncodedFormEntity(parameters, encoding);
        post.setEntity((HttpEntity)encodedFormEntity);
        String host = smsConfig.get("proxyHost");
        if (StringUtils.isNotEmpty(host) && StringUtils.isNumericString(portString = smsConfig.get("proxyPort"))) {
            String scheme = smsConfig.get("proxyScheme");
            HttpHost proxy = new HttpHost(host, Integer.parseInt(portString), scheme);
            post.setConfig(RequestConfig.custom().setProxy(proxy).build());
        }
        if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(Resources.get("bos-util", "SmsUtil_0", "send sms fail", new Object[0]) + "\uff1a" + response.toString());
        }
    }
}

