/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import kd.bos.util.DisCardUtil;

public class StringUtils {
    private static final String SHA1PRNG = "SHA1PRNG";
    private static final String[] empty_string_array = new String[0];
    private static final String DOT = ".";

    public static boolean isEmpty(String string) {
        return StringUtils.isNull(string) || StringUtils.isBlank(string);
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static String getEmpty() {
        return "";
    }

    public static boolean isNull(String string) {
        return string == null;
    }

    public static boolean isNotNull(String string) {
        return !StringUtils.isNull(string);
    }

    public static boolean isBlank(String string) {
        return StringUtils.isNotNull(string) && string.trim().length() == 0;
    }

    public static boolean isNumericString(String str) {
        boolean isNumericString = false;
        if (str != null) {
            isNumericString = true;
            for (int i = 0; i < str.length(); ++i) {
                if (Character.isDigit(str.charAt(i))) continue;
                isNumericString = false;
                break;
            }
        }
        return isNumericString;
    }

    public static boolean isNumeric(String str) {
        boolean isNumeric = false;
        if (str != null && str.indexOf(DOT) == str.lastIndexOf(DOT)) {
            String tempString = str.replace(DOT, "");
            isNumeric = StringUtils.isNumericString(tempString);
        }
        return isNumeric;
    }

    public static String trim(String string) {
        if (StringUtils.isNull(string)) {
            return StringUtils.getEmpty();
        }
        return string.trim();
    }

    public static String[] split(String value, boolean withoutEmpty, char ... delim) {
        String[] stringArray;
        if (value == null || value.length() == 0) {
            if (withoutEmpty) {
                return empty_string_array;
            }
            return new String[]{""};
        }
        if (delim.length > 0) {
            ArrayList<String> ret = new ArrayList<String>();
            String split = "" + delim;
            char[] chs = value.toCharArray();
            StringBuilder token = new StringBuilder();
            int n = chs.length;
            for (int i = 0; i < n; ++i) {
                char ch = chs[i];
                if (split.indexOf(ch) != -1) {
                    if (withoutEmpty) {
                        String s = token.toString().trim();
                        if (s.length() > 0) {
                            ret.add(s);
                        }
                    } else {
                        ret.add(token.toString());
                    }
                    token.setLength(0);
                    continue;
                }
                token.append(ch);
            }
            if (split.indexOf(chs[chs.length - 1]) != -1) {
                if (!withoutEmpty) {
                    ret.add("");
                }
            } else if (withoutEmpty) {
                String s = token.toString().trim();
                if (s.length() > 0) {
                    ret.add(s);
                }
            } else {
                ret.add(token.toString());
            }
            return ret.toArray(new String[ret.size()]);
        }
        if (withoutEmpty) {
            value = value.trim();
        }
        if (value.length() == 0) {
            stringArray = empty_string_array;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        return stringArray;
    }

    private static String randomWord(boolean randomIndicator, int min, int max) {
        String str = "";
        int range = min;
        String[] arr = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        SecureRandom secRamdom = null;
        try {
            secRamdom = SecureRandom.getInstance(SHA1PRNG);
        }
        catch (NoSuchAlgorithmException e) {
            DisCardUtil.discard();
        }
        if (secRamdom == null) {
            secRamdom = new SecureRandom();
        }
        if (randomIndicator) {
            range = (int)(Math.round(StringUtils.random(secRamdom) * (double)(max - min)) + (long)min);
        }
        for (int i = 0; i < range; ++i) {
            int pos = (int)Math.round(StringUtils.random(secRamdom) * (double)(arr.length - 1));
            str = str + arr[pos];
        }
        return str;
    }

    public static String randomWord(int min) {
        return StringUtils.randomWord(false, min, min);
    }

    public static double random(SecureRandom secRamdom) {
        if (secRamdom != null) {
            BigDecimal result = new BigDecimal(Math.abs(secRamdom.nextInt())).divide(new BigDecimal(10000000)).divide(new BigDecimal(1000));
            return result.multiply(new BigDecimal(10)).doubleValue() - (double)result.multiply(new BigDecimal(10)).intValue();
        }
        return 1.0;
    }

    private static String randomNumber(boolean randomIndicator, int min, int max) {
        String str = "";
        int range = min;
        String[] arr = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        SecureRandom secRamdom = null;
        try {
            secRamdom = SecureRandom.getInstance(SHA1PRNG);
        }
        catch (NoSuchAlgorithmException e) {
            DisCardUtil.discard();
        }
        if (secRamdom == null) {
            if (randomIndicator) {
                range = (int)(Math.round(Math.random() * (double)(max - min)) + (long)min);
            }
            for (int i = 0; i < range; ++i) {
                int pos = (int)Math.round(Math.random() * (double)(arr.length - 1));
                str = str + arr[pos];
            }
        } else {
            if (randomIndicator) {
                range = (int)(Math.round(StringUtils.random(secRamdom) * (double)(max - min)) + (long)min);
            }
            for (int i = 0; i < range; ++i) {
                int pos = (int)Math.round(StringUtils.random(secRamdom) * (double)(arr.length - 1));
                str = str + arr[pos];
            }
        }
        return str;
    }

    public static String randomNumber(int min) {
        return StringUtils.randomNumber(false, min, min);
    }

    public static String fromInputStream(InputStream in, String encoding) throws IOException {
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        ByteStreams.copy((InputStream)in, (OutputStream)out2);
        return out2.toString(encoding);
    }
}

