/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.thread.ThreadLifeCycleListener;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.thread.ThreadLocalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocals {
    private static Logger LOG = LoggerFactory.getLogger(ThreadLocals.class);
    private static ThreadLocal<Set<ThreadLocal<?>>> th;

    public static void start() {
    }

    public static <T> ThreadLocal<T> create() {
        return ThreadLocals.create(null);
    }

    public static <T> ThreadLocal<T> create(final T initValue) {
        return new ThreadLocal<T>(){

            @Override
            protected T initialValue() {
                ((Set)th.get()).add(this);
                return initValue;
            }
        };
    }

    public static <T> ThreadLocal<T> create(final Supplier<T> supplier) {
        return new ThreadLocal<T>(){

            @Override
            protected T initialValue() {
                ((Set)th.get()).add(this);
                return supplier == null ? null : (Object)supplier.get();
            }
        };
    }

    public static void release() {
        Set<ThreadLocal<ThreadLocal<?>>> set = th.get();
        HashSet curSet = new HashSet(set);
        ThreadLocals.doRelease(curSet);
        if (set.size() > curSet.size()) {
            set.removeAll(curSet);
            ThreadLocals.doRelease(new HashSet(set));
        }
        set.clear();
    }

    private static void doRelease(Set<ThreadLocal<?>> set) {
        for (ThreadLocal<?> t : set) {
            Object o = t.get();
            t.remove();
            if (o == null || !(o instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)o).close();
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
        }
    }

    static {
        ThreadLifeCycleManager.addListener(new ThreadLifeCycleListener(){

            @Override
            public void start() {
            }

            @Override
            public void end() {
                ThreadLocals.release();
                ThreadLocalUtils.clearCurrentThreadLocals();
            }
        }, 0x7FFFFFFE);
        th = new ThreadLocal<Set<ThreadLocal<?>>>(){

            @Override
            protected Set<ThreadLocal<?>> initialValue() {
                return new HashSet();
            }
        };
    }
}

