/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util.async;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class WrapperTask<T>
implements Runnable {
    private long threadid;
    private List<T> ls = new ArrayList<T>(256);
    private Map<Long, ConcurrentLinkedQueue<T>> eventMaps;
    private final AtomicInteger totalSpanCount;
    private Consumer<List<T>> consumer;

    public WrapperTask(long threadId, Map<Long, ConcurrentLinkedQueue<T>> spanMaps, AtomicInteger totalSpanCount, Consumer<List<T>> consumer) {
        this.threadid = threadId;
        this.eventMaps = spanMaps;
        this.totalSpanCount = totalSpanCount;
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        ConcurrentLinkedQueue<T> eventLs = this.eventMaps.get(this.threadid);
        if (eventLs == null || eventLs.size() == 0) {
            return;
        }
        ConcurrentLinkedQueue<T> concurrentLinkedQueue = eventLs;
        synchronized (concurrentLinkedQueue) {
            T innerEvent;
            this.ls.clear();
            for (int count = 0; count < 256 && (innerEvent = eventLs.poll()) != null; ++count) {
                this.ls.add(innerEvent);
            }
            int size = this.ls.size();
            if (size > 0) {
                try {
                    this.consumer.accept(this.ls);
                }
                finally {
                    this.totalSpanCount.getAndAdd(-1 * size);
                }
            }
        }
    }
}

