/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zip.io.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import kd.bos.zip.crypto.StandardEncrypter;
import kd.bos.zip.io.outputstream.CipherOutputStream;
import kd.bos.zip.io.outputstream.ZipEntryOutputStream;
import kd.bos.zip.model.ZipParameters;
import kd.bos.zip.util.Zip4jUtil;

class ZipStandardCipherOutputStream
extends CipherOutputStream<StandardEncrypter> {
    public ZipStandardCipherOutputStream(ZipEntryOutputStream outputStream, ZipParameters zipParameters, char[] password) throws IOException {
        super(outputStream, zipParameters, password);
    }

    @Override
    protected StandardEncrypter initializeEncrypter(OutputStream outputStream, ZipParameters zipParameters, char[] password) throws IOException {
        long key = this.getEncryptionKey(zipParameters);
        StandardEncrypter encrypter = new StandardEncrypter(password, key);
        this.writeHeaders(encrypter.getHeaderBytes());
        return encrypter;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
    }

    private long getEncryptionKey(ZipParameters zipParameters) {
        if (zipParameters.isWriteExtendedLocalFileHeader()) {
            long dosTime = Zip4jUtil.epochToExtendedDosTime(zipParameters.getLastModifiedFileTime());
            return (dosTime & 0xFFFFL) << 16;
        }
        return zipParameters.getEntryCRC();
    }
}

